/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status.statuspage;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServerInterface;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.exception.ExceptionUtils;

public class StatusPageServer
implements Runnable,
StatusPageServerInterface {
    public static Logger log = Logger.getLogger(StatusPageServer.class.getName());
    private final Timer timer;
    private final Object monitor;
    private ServerSocket ssocket;
    private final Thread runner;
    private int port = 0;
    private boolean running = true;
    private boolean shouldBeConnected = false;
    private HttpRequest currentHttpRequest = null;
    private StatusPageResponse currentResponse = null;
    private long lastConnectErrorTime = 0L;
    private String lastConnectError = "";
    private PatternRequestRouter staticContentRouter = new PatternRequestRouter();
    private Date startTime = new Date();

    public StatusPageServer(Timer timer, Object monitor, int port) throws IOException, InterruptedException {
        this.timer = timer;
        this.monitor = monitor;
        this.port = port;
        this.connect();
        this.runner = new Thread(this);
        this.runner.start();
    }

    public boolean isConnected() {
        if (this.ssocket != null && this.ssocket.isBound() && (this.ssocket.getLocalPort() == this.port || this.port == 0)) {
            return true;
        }
        log.log((Level)LogLevel.SPAM, "Status page server socket is no longer connected: " + (this.ssocket != null) + " " + this.ssocket.isBound() + " " + this.ssocket.getLocalPort() + " " + this.port);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException, InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.ssocket != null) {
                if (this.ssocket.isBound() && this.ssocket.getLocalPort() == this.port) {
                    return;
                }
                this.disconnect();
            }
            this.ssocket = new ServerSocket();
            if (this.port != 0) {
                this.ssocket.setReuseAddress(true);
            }
            this.ssocket.setSoTimeout(100);
            this.ssocket.bind(new InetSocketAddress(this.port));
            this.shouldBeConnected = true;
            for (int i = 0; i < 200 && !this.isConnected(); ++i) {
                Thread.sleep(10L);
            }
            if (!this.isConnected()) {
                log.log(LogLevel.INFO, "Fleetcontroller: Server Socket not ready after connect()");
            }
            log.log((Level)LogLevel.DEBUG, "Fleet controller status page viewer listening to " + this.ssocket.getLocalSocketAddress());
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.shouldBeConnected = false;
            if (this.ssocket != null) {
                this.ssocket.close();
            }
            this.ssocket = null;
            this.monitor.notifyAll();
        }
    }

    @Override
    public void setPort(int port) throws IOException, InterruptedException {
        if (port != 0 && this.isConnected() && port != ((InetSocketAddress)this.ssocket.getLocalSocketAddress()).getPort()) {
            log.log(LogLevel.INFO, "Exchanging port used by status server. Moving from port " + ((InetSocketAddress)this.ssocket.getLocalSocketAddress()).getPort() + " to port " + port);
            this.disconnect();
            this.port = port;
            if (this.ssocket == null || !this.ssocket.isBound() || this.ssocket.getLocalPort() != port) {
                this.connect();
            }
        } else {
            this.port = port;
        }
    }

    @Override
    public int getPort() {
        if (this.ssocket == null || !this.ssocket.isBound()) {
            throw new IllegalStateException("Cannot ask for port before server socket is bound");
        }
        return ((InetSocketAddress)this.ssocket.getLocalSocketAddress()).getPort();
    }

    @Override
    public void shutdown() throws InterruptedException, IOException {
        this.running = false;
        this.runner.interrupt();
        this.runner.join();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block44: while (true) {
            try {
                while (this.running) {
                    OutputStream output;
                    Socket connection;
                    block62: {
                        connection = null;
                        ServerSocket serverSocket = null;
                        Object object = this.monitor;
                        synchronized (object) {
                            if (this.ssocket == null || !this.ssocket.isBound()) {
                                this.monitor.wait(1000L);
                                continue;
                            }
                            serverSocket = this.ssocket;
                        }
                        try {
                            connection = serverSocket.accept();
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                        }
                        catch (IOException e) {
                            log.log(this.shouldBeConnected ? LogLevel.WARNING : LogLevel.DEBUG, "Caught IO exception in ServerSocket.accept(): " + e.getMessage());
                        }
                        if (connection == null) continue;
                        log.log((Level)LogLevel.DEBUG, "Got a status page request.");
                        String requestString = "";
                        output = null;
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                            StringBuilder sb = new StringBuilder();
                            while (true) {
                                String s;
                                if ((s = br.readLine()) == null) {
                                    throw new IOException("No data in HTTP request on socket " + connection.toString());
                                }
                                if (s.length() > 4 && s.substring(0, 4).equals("GET ")) {
                                    int nextSpace = s.indexOf(32, 4);
                                    requestString = nextSpace == -1 ? s.substring(4) : s.substring(4, nextSpace);
                                }
                                if (s == null || s.equals("")) break;
                                sb.append(s).append("\n");
                            }
                            log.log((Level)LogLevel.DEBUG, "Got HTTP request: " + sb.toString());
                            HttpRequest httpRequest = null;
                            StatusPageResponse response = null;
                            try {
                                httpRequest = new HttpRequest(requestString);
                                RequestHandler contentHandler = this.staticContentRouter.resolveHandler(httpRequest);
                                if (contentHandler != null) {
                                    response = contentHandler.handle(httpRequest);
                                }
                            }
                            catch (Exception e) {
                                response = new StatusPageResponse();
                                response.setResponseCode(StatusPageResponse.ResponseCode.INTERNAL_SERVER_ERROR);
                                StringBuilder content = new StringBuilder();
                                response.writeHtmlHeader(content, "Internal Server Error");
                                response.writeHtmlFooter(content, ExceptionUtils.getStackTrace((Throwable)e));
                                response.writeContent(content.toString());
                            }
                            if (response == null) {
                                Object e = this.monitor;
                                synchronized (e) {
                                    this.currentHttpRequest = httpRequest;
                                    this.currentResponse = null;
                                    while (this.running) {
                                        if (this.currentResponse != null) {
                                            response = this.currentResponse;
                                            break;
                                        }
                                        this.monitor.wait(100L);
                                    }
                                }
                            }
                            if (response == null) {
                                response = new StatusPageResponse();
                                StringBuilder content = new StringBuilder();
                                response.setContentType("text/html");
                                response.writeHtmlHeader(content, "Failed to get response. Fleet controller probably in the process of shutting down.");
                                response.writeHtmlFooter(content, "");
                                response.writeContent(content.toString());
                            }
                            output = connection.getOutputStream();
                            StringBuilder header = new StringBuilder();
                            header.append("HTTP/1.1 ").append(response.getResponseCode().getCode()).append(" ").append(response.getResponseCode().getMessage()).append("\r\n").append("Date: ").append(new Date().toString()).append("\r\n").append("Connection: Close\r\n").append("Content-type: ").append(response.getContentType()).append("\r\n");
                            if (response.isClientCachingEnabled()) {
                                SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
                                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                                header.append("Last-Modified: ").append(df.format(this.startTime)).append("\r\n");
                            } else {
                                header.append("Expires: Fri, 01 Jan 1990 00:00:00 GMT\r\n").append("Pragma: no-cache\r\n").append("Cache-control: no-cache, must-revalidate\r\n");
                            }
                            header.append("\r\n");
                            output.write(header.toString().getBytes());
                            output.write(response.getOutputStream().toByteArray());
                        }
                        if (output == null) break block62;
                        try {
                            output.close();
                        }
                        catch (IOException e) {
                            log.log((Level)(e.getMessage().indexOf("Broken pipe") >= 0 ? LogLevel.DEBUG : LogLevel.INFO), "Failed to close output stream on socket " + connection + ": " + e.getMessage());
                        }
                    }
                    if (connection == null) continue;
                    try {
                        connection.close();
                        continue block44;
                    }
                    catch (IOException e) {
                        log.log(LogLevel.INFO, "Failed to close socket " + connection + ": " + e.getMessage());
                        continue;
                    }
                    catch (IOException e) {
                        block63: {
                            log.log((Level)(e.getMessage().indexOf("Broken pipe") >= 0 ? LogLevel.DEBUG : LogLevel.INFO), "Failed to process HTTP request : " + e.getMessage());
                            if (output == null) break block63;
                            try {
                                output.close();
                            }
                            catch (IOException e2) {
                                log.log((Level)(e2.getMessage().indexOf("Broken pipe") >= 0 ? LogLevel.DEBUG : LogLevel.INFO), "Failed to close output stream on socket " + connection + ": " + e2.getMessage());
                            }
                        }
                        if (connection == null) continue;
                        try {
                            connection.close();
                            continue block44;
                        }
                        catch (IOException e3) {
                            log.log(LogLevel.INFO, "Failed to close socket " + connection + ": " + e3.getMessage());
                            continue;
                        }
                    }
                    catch (Exception e) {
                        block64: {
                            log.log(LogLevel.WARNING, "Caught exception in HTTP server thread: " + e.getClass().getName() + ": " + e.getMessage());
                            if (output == null) break block64;
                            try {
                                output.close();
                            }
                            catch (IOException e4) {
                                log.log((Level)(e4.getMessage().indexOf("Broken pipe") >= 0 ? LogLevel.DEBUG : LogLevel.INFO), "Failed to close output stream on socket " + connection + ": " + e4.getMessage());
                            }
                        }
                        if (connection == null) continue;
                        try {
                            connection.close();
                            continue block44;
                        }
                        catch (IOException e5) {
                            log.log(LogLevel.INFO, "Failed to close socket " + connection + ": " + e5.getMessage());
                            continue;
                        }
                        {
                            continue block44;
                            catch (Throwable throwable) {
                                if (output != null) {
                                    try {
                                        output.close();
                                    }
                                    catch (IOException e6) {
                                        log.log((Level)(e6.getMessage().indexOf("Broken pipe") >= 0 ? LogLevel.DEBUG : LogLevel.INFO), "Failed to close output stream on socket " + connection + ": " + e6.getMessage());
                                    }
                                }
                                if (connection == null) throw throwable;
                                try {
                                    connection.close();
                                    throw throwable;
                                }
                                catch (IOException e7) {
                                    log.log(LogLevel.INFO, "Failed to close socket " + connection + ": " + e7.getMessage());
                                }
                                throw throwable;
                                return;
                            }
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                log.log((Level)LogLevel.DEBUG, "Status processing thread shut down by interrupt exception: " + e);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRequest getCurrentHttpRequest() {
        Object object = this.monitor;
        synchronized (object) {
            return this.currentHttpRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void answerCurrentStatusRequest(StatusPageResponse r) {
        block6: {
            if (!this.isConnected()) {
                long time = this.timer.getCurrentTimeInMillis();
                try {
                    this.connect();
                }
                catch (Exception e) {
                    if (e.getMessage().equals(this.lastConnectError) && time - this.lastConnectErrorTime <= 60000L) break block6;
                    this.lastConnectError = e.getMessage();
                    this.lastConnectErrorTime = time;
                    log.log(LogLevel.WARNING, "Failed to initialize HTTP status server server socket: " + e.getMessage());
                }
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            this.currentResponse = r;
            this.currentHttpRequest = null;
        }
    }

    public static class PatternRequestRouter
    implements RequestRouter {
        private List<PatternRouting> patterns = new ArrayList<PatternRouting>();

        public void addHandler(Pattern pattern, RequestHandler handler) {
            this.patterns.add(new PatternRouting(pattern, handler));
        }

        public void addHandler(String pattern, RequestHandler handler) {
            this.addHandler(Pattern.compile(pattern), handler);
        }

        @Override
        public RequestHandler resolveHandler(HttpRequest request) {
            for (PatternRouting routing : this.patterns) {
                Matcher m = routing.pattern.matcher(request.getPath());
                if (!m.matches()) continue;
                return routing.handler;
            }
            return null;
        }

        private static class PatternRouting {
            public Pattern pattern;
            public RequestHandler handler;

            private PatternRouting(Pattern pattern, RequestHandler handler) {
                this.pattern = pattern;
                this.handler = handler;
            }
        }
    }

    public static interface RequestRouter {
        public RequestHandler resolveHandler(HttpRequest var1);
    }

    public static interface RequestHandler {
        public StatusPageResponse handle(HttpRequest var1);
    }

    public static class HttpRequest {
        private final String request;
        private String pathPrefix = "";
        private final Map<String, String> params = new HashMap<String, String>();
        private String path;
        static Pattern pathPattern = Pattern.compile("^(/([\\w=\\./]+)?)(?:\\?((?:&?\\w+(?:=[\\w\\.]*)?)*))?$");

        public HttpRequest(String request) {
            this.request = request;
            Matcher m = pathPattern.matcher(request);
            if (!m.matches()) {
                throw new IllegalArgumentException("Illegal HTTP request path: " + request);
            }
            this.path = m.group(1);
            if (m.group(3) != null) {
                String[] rawParams;
                for (String param : rawParams = m.group(3).split("&")) {
                    String[] queryParts = param.split("=");
                    this.params.put(queryParts[0], queryParts.length > 1 ? queryParts[1] : null);
                }
            }
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String toString() {
            return "HttpRequest(" + this.request + ")";
        }

        public String getRequest() {
            return this.request;
        }

        public String getPath() {
            return this.path;
        }

        public boolean hasQueryParameters() {
            return !this.params.isEmpty();
        }

        public String getQueryParameter(String name) {
            return this.params.get(name);
        }

        public boolean hasQueryParameter(String name) {
            return this.params.containsKey(name);
        }

        public void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }
    }
}

