/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.AggregatedStatsMergePendingChecker;

public class ClusterStatsChangeTracker {
    private AggregatedClusterStats aggregatedStats;
    private AggregatedStatsMergePendingChecker checker;
    private boolean prevMayHaveMergesPending;

    public ClusterStatsChangeTracker(AggregatedClusterStats aggregatedStats) {
        this.setAggregatedStats(aggregatedStats);
        this.prevMayHaveMergesPending = false;
    }

    private void setAggregatedStats(AggregatedClusterStats aggregatedStats) {
        this.aggregatedStats = aggregatedStats;
        this.checker = new AggregatedStatsMergePendingChecker(this.aggregatedStats);
    }

    public void syncBucketsPendingFlag() {
        this.prevMayHaveMergesPending = this.checker.mayHaveMergesPendingInGlobalSpace();
    }

    public void updateAggregatedStats(AggregatedClusterStats newAggregatedStats) {
        this.syncBucketsPendingFlag();
        this.setAggregatedStats(newAggregatedStats);
    }

    public boolean statsHaveChanged() {
        if (!this.aggregatedStats.hasUpdatesFromAllDistributors()) {
            return false;
        }
        return this.prevMayHaveMergesPending != this.checker.mayHaveMergesPendingInGlobalSpace();
    }
}

