/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vespa.clustercontroller.core.AggregatedClusterStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import com.yahoo.vespa.clustercontroller.core.MergePendingChecker;

public class AggregatedStatsMergePendingChecker
implements MergePendingChecker {
    private final AggregatedClusterStats stats;

    public AggregatedStatsMergePendingChecker(AggregatedClusterStats stats) {
        this.stats = stats;
    }

    @Override
    public boolean mayHaveMergesPending(String bucketSpace, int contentNodeIndex) {
        if (!this.stats.hasUpdatesFromAllDistributors()) {
            return true;
        }
        ContentNodeStats nodeStats = this.stats.getStats().getContentNode(contentNodeIndex);
        if (nodeStats != null) {
            ContentNodeStats.BucketSpaceStats bucketSpaceStats = nodeStats.getBucketSpace(bucketSpace);
            return bucketSpaceStats != null && bucketSpaceStats.mayHaveBucketsPending();
        }
        return true;
    }

    public boolean mayHaveMergesPendingInGlobalSpace() {
        if (!this.stats.hasUpdatesFromAllDistributors()) {
            return true;
        }
        for (ContentNodeStats stats : this.stats.getStats()) {
            if (!this.mayHaveMergesPending(FixedBucketSpaces.globalSpace(), stats.getNodeIndex())) continue;
            return true;
        }
        return false;
    }
}

