/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.status.statuspage;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterStatsAggregator;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.HtmlTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class VdsClusterHtmlRendrer {
    private static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");

    public Table createNewClusterHtmlTable(String clusterName, int slobrokGenerationCount) {
        return new Table(clusterName, slobrokGenerationCount);
    }

    public static class Table {
        private final HtmlTable table = new HtmlTable();
        private final HtmlTable.CellProperties headerProperties;
        private final StringBuilder contentBuilder = new StringBuilder();
        private static final String TAG_NOT_SET = "not set";
        private static final HtmlTable.CellProperties WARNING_PROPERTY = new HtmlTable.CellProperties().setBackgroundColor(0xFFFFC0);
        private static final HtmlTable.CellProperties ERROR_PROPERTY = new HtmlTable.CellProperties().setBackgroundColor(0xFFC0C0);
        private static final HtmlTable.CellProperties CENTERED_PROPERTY = new HtmlTable.CellProperties().align(HtmlTable.Orientation.CENTER);

        Table(String clusterName, int slobrokGenerationCount) {
            this.table.getTableProperties().align(HtmlTable.Orientation.RIGHT).setBackgroundColor(0xC0FFC0);
            this.table.getColProperties(0).align(HtmlTable.Orientation.CENTER).setBackgroundColor(0xFFFFFF);
            this.table.getColProperties(1).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(2).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(3).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(7).align(HtmlTable.Orientation.LEFT);
            this.table.getColProperties(14).align(HtmlTable.Orientation.LEFT);
            for (int i = 4; i < 15; ++i) {
                this.table.getColProperties(i).allowLineBreaks(false);
            }
            this.headerProperties = new HtmlTable.CellProperties().setBackgroundColor(0xFFFFFF).align(HtmlTable.Orientation.CENTER);
            this.contentBuilder.append("<h2>State of content cluster '").append(clusterName).append("'.</h2>\n").append("<p>Based on information retrieved from slobrok at generation ").append(slobrokGenerationCount).append(".</p>\n");
        }

        public void addTable(StringBuilder destination, long stableStateTimePeriode) {
            destination.append((CharSequence)this.contentBuilder);
            destination.append(this.table.toString()).append("<p>").append("<p>");
            this.addFooter(destination, stableStateTimePeriode);
        }

        public void renderNodes(TreeMap<Integer, NodeInfo> storageNodeInfos, TreeMap<Integer, NodeInfo> distributorNodeInfos, Timer timer, ClusterState state, ClusterStatsAggregator statsAggregator, int maxPrematureCrashes, EventLog eventLog, String pathPrefix, String name) {
            String dominantVtag = this.findDominantVtag(storageNodeInfos, distributorNodeInfos);
            this.renderNodesOneType(storageNodeInfos, NodeType.STORAGE, timer, state, statsAggregator, maxPrematureCrashes, eventLog, pathPrefix, dominantVtag, name);
            this.renderNodesOneType(distributorNodeInfos, NodeType.DISTRIBUTOR, timer, state, statsAggregator, maxPrematureCrashes, eventLog, pathPrefix, dominantVtag, name);
        }

        private String findDominantVtag(Map<Integer, NodeInfo> storageNodeInfos, Map<Integer, NodeInfo> distributorNodeInfos) {
            ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>();
            nodeInfos.addAll(storageNodeInfos.values());
            nodeInfos.addAll(distributorNodeInfos.values());
            HashMap<String, Integer> versionTagToCount = new HashMap<String, Integer>();
            int maxCount = -1;
            String dominantVtag = null;
            for (NodeInfo nodeInfo : nodeInfos) {
                String buildTag = nodeInfo.getVtag();
                Integer count = (Integer)versionTagToCount.get(buildTag);
                count = count == null ? 1 : count + 1;
                versionTagToCount.put(buildTag, count);
                if (count <= maxCount) continue;
                maxCount = count;
                dominantVtag = buildTag;
            }
            return dominantVtag == null ? TAG_NOT_SET : dominantVtag;
        }

        private void addTableHeader(String name, NodeType nodeType) {
            this.table.addRow(new HtmlTable.Row().addCell(new HtmlTable.Cell("Group " + name).addProperties(new HtmlTable.CellProperties().setColSpan(0).setBackgroundColor(0xCCCCFF).align(HtmlTable.Orientation.LEFT))));
            this.table.addRow(new HtmlTable.Row().setHeaderRow().addProperties(this.headerProperties).addProperties(new HtmlTable.CellProperties().setRowSpan(2)).addCell(new HtmlTable.Cell(nodeType == NodeType.DISTRIBUTOR ? "Distributor" : "Storage")).addCell(new HtmlTable.Cell("Node states").addProperties(new HtmlTable.CellProperties().setColSpan(3).setRowSpan(1))).addCell(new HtmlTable.Cell("Build")).addCell(new HtmlTable.Cell("FC<sup>1)</sup>")).addCell(new HtmlTable.Cell("OCT<sup>2)</sup>")).addCell(new HtmlTable.Cell("SPT<sup>3)</sup>")).addCell(new HtmlTable.Cell("SSV<sup>4)</sup>")).addCell(new HtmlTable.Cell("PC<sup>5)</sup>")).addCell(new HtmlTable.Cell("ELW<sup>6)</sup>")).addCell(new HtmlTable.Cell("Buckets pending").addProperties(new HtmlTable.CellProperties().setColSpan(2).setRowSpan(1))).addCell(new HtmlTable.Cell("Start Time")).addCell(new HtmlTable.Cell("RPC Address")));
            this.table.addRow(new HtmlTable.Row().setHeaderRow().addProperties(this.headerProperties).addCell(new HtmlTable.Cell("Reported")).addCell(new HtmlTable.Cell("Wanted")).addCell(new HtmlTable.Cell("System")).addCell(new HtmlTable.Cell(FixedBucketSpaces.defaultSpace())).addCell(new HtmlTable.Cell(FixedBucketSpaces.globalSpace())));
        }

        private void renderNodesOneType(TreeMap<Integer, NodeInfo> nodeInfos, NodeType nodeType, Timer timer, ClusterState state, ClusterStatsAggregator statsAggregator, int maxPrematureCrashes, EventLog eventLog, String pathPrefix, String dominantVtag, String name) {
            long currentTime = timer.getCurrentTimeInMillis();
            this.addTableHeader(name, nodeType);
            for (NodeInfo nodeInfo : nodeInfos.values()) {
                long timeSinceContact;
                HtmlTable.Row row = new HtmlTable.Row();
                row.addCell(new HtmlTable.Cell("<a href=\"" + pathPrefix + "/node=" + nodeInfo.getNode() + "\">" + nodeInfo.getNodeIndex() + "</a>"));
                NodeState reportedState = nodeInfo.getReportedState().clone().setStartTimestamp(0L);
                row.addCell(new HtmlTable.Cell(HtmlTable.escape(reportedState.toString(true))));
                if (!nodeInfo.getReportedState().getState().equals((Object)State.UP)) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                if (nodeInfo.getWantedState() == null || nodeInfo.getWantedState().getState().equals((Object)State.UP)) {
                    row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
                } else {
                    row.addCell(new HtmlTable.Cell(HtmlTable.escape(nodeInfo.getWantedState().toString(true))));
                    if (nodeInfo.getWantedState().toString(true).indexOf("Disabled by fleet controller") != -1) {
                        row.getLastCell().addProperties(ERROR_PROPERTY);
                    } else {
                        row.getLastCell().addProperties(WARNING_PROPERTY);
                    }
                }
                NodeState ns = state.getNodeState(nodeInfo.getNode()).clone().setDescription("").setMinUsedBits(16);
                if (state.getClusterState().oneOf("uir")) {
                    row.addCell(new HtmlTable.Cell(HtmlTable.escape(ns.toString(true))));
                    if (ns.getState().equals((Object)State.DOWN)) {
                        row.getLastCell().addProperties(ERROR_PROPERTY);
                    } else if (ns.getState().oneOf("mi")) {
                        row.getLastCell().addProperties(WARNING_PROPERTY);
                    }
                } else {
                    row.addCell(new HtmlTable.Cell("Cluster " + state.getClusterState().name().toLowerCase()).addProperties(ERROR_PROPERTY));
                }
                String buildTagText = nodeInfo.getVtag() != null ? nodeInfo.getVtag() : TAG_NOT_SET;
                row.addCell(new HtmlTable.Cell(buildTagText));
                if (!dominantVtag.equals(nodeInfo.getVtag())) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                row.addCell(new HtmlTable.Cell("" + nodeInfo.getConnectionAttemptCount()));
                long l = timeSinceContact = nodeInfo.getTimeOfFirstFailingConnectionAttempt() == 0L ? 0L : currentTime - nodeInfo.getTimeOfFirstFailingConnectionAttempt();
                if (timeSinceContact > 60000L) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else if (nodeInfo.getConnectionAttemptCount() > 0) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                row.addCell(new HtmlTable.Cell(timeSinceContact / 1000L + " s"));
                if (timeSinceContact > 60000L) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else if (nodeInfo.getConnectionAttemptCount() > 0) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                if (nodeInfo.getLatestNodeStateRequestTime() == null) {
                    row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
                } else {
                    row.addCell(new HtmlTable.Cell(HtmlTable.escape(RealTimer.printDuration(currentTime - nodeInfo.getLatestNodeStateRequestTime()))));
                }
                row.addCell(new HtmlTable.Cell("" + nodeInfo.getSystemStateVersionAcknowledged()));
                if (nodeInfo.getSystemStateVersionAcknowledged() < state.getVersion() - 2) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else if (nodeInfo.getSystemStateVersionAcknowledged() < state.getVersion()) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                row.addCell(new HtmlTable.Cell("" + nodeInfo.getPrematureCrashCount()));
                if (nodeInfo.getPrematureCrashCount() >= maxPrematureCrashes) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else if (nodeInfo.getPrematureCrashCount() > 0) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                int nodeEvents = eventLog.getNodeEventsSince(nodeInfo.getNode(), currentTime - eventLog.getRecentTimePeriod());
                row.addCell(new HtmlTable.Cell("" + nodeEvents));
                if (nodeEvents > 20) {
                    row.getLastCell().addProperties(ERROR_PROPERTY);
                } else if (nodeEvents > 3) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
                if (nodeType.equals((Object)NodeType.STORAGE)) {
                    Table.addBucketsPending(row, Table.getStatsForContentNode(statsAggregator, nodeInfo, FixedBucketSpaces.defaultSpace()));
                    Table.addBucketsPending(row, Table.getStatsForContentNode(statsAggregator, nodeInfo, FixedBucketSpaces.globalSpace()));
                } else {
                    Table.addBucketsPending(row, Table.getStatsForDistributorNode(statsAggregator, nodeInfo, FixedBucketSpaces.defaultSpace()));
                    Table.addBucketsPending(row, Table.getStatsForDistributorNode(statsAggregator, nodeInfo, FixedBucketSpaces.globalSpace()));
                }
                if (nodeInfo.getStartTimestamp() == 0L) {
                    row.addCell(new HtmlTable.Cell("-").addProperties(ERROR_PROPERTY).addProperties(CENTERED_PROPERTY));
                } else {
                    String startTime = RealTimer.printDateNoMilliSeconds(1000L * nodeInfo.getStartTimestamp(), utcTimeZone);
                    row.addCell(new HtmlTable.Cell(HtmlTable.escape(startTime)));
                }
                if (nodeInfo.getRpcAddress() == null) {
                    row.addCell(new HtmlTable.Cell("-").addProperties(ERROR_PROPERTY));
                } else {
                    row.addCell(new HtmlTable.Cell(HtmlTable.escape(nodeInfo.getRpcAddress())));
                    if (nodeInfo.isRpcAddressOutdated()) {
                        row.getLastCell().addProperties(WARNING_PROPERTY);
                    }
                }
                this.table.addRow(row);
            }
        }

        private static ContentNodeStats.BucketSpaceStats getStatsForContentNode(ClusterStatsAggregator statsAggregator, NodeInfo nodeInfo, String bucketSpace) {
            ContentNodeStats nodeStats = statsAggregator.getAggregatedStats().getContentNode(nodeInfo.getNodeIndex());
            if (nodeStats != null) {
                return nodeStats.getBucketSpace(bucketSpace);
            }
            return null;
        }

        private static ContentNodeStats.BucketSpaceStats getStatsForDistributorNode(ClusterStatsAggregator statsAggregator, NodeInfo nodeInfo, String bucketSpace) {
            ContentNodeStats nodeStats = statsAggregator.getAggregatedStatsForDistributor(nodeInfo.getNodeIndex());
            return nodeStats.getBucketSpace(bucketSpace);
        }

        private static void addBucketsPending(HtmlTable.Row row, ContentNodeStats.BucketSpaceStats bucketSpaceStats) {
            if (bucketSpaceStats != null) {
                long bucketsPending = bucketSpaceStats.getBucketsPending();
                String cellValue = String.valueOf(bucketsPending);
                if (!bucketSpaceStats.valid()) {
                    cellValue = cellValue + "?";
                }
                row.addCell(new HtmlTable.Cell(cellValue));
                if (bucketsPending > 0L || !bucketSpaceStats.valid()) {
                    row.getLastCell().addProperties(WARNING_PROPERTY);
                }
            } else {
                row.addCell(new HtmlTable.Cell("-").addProperties(CENTERED_PROPERTY));
            }
        }

        private void addFooter(StringBuilder contentBuilder, long stableStateTimePeriode) {
            contentBuilder.append("<font size=\"-1\">\n").append("1) FC - Failed connections - We have tried to connect to the nodes this many times without being able to contact it.<br>\n").append("2) OCT - Out of contact time - Time in seconds we have failed to contact the node.<br>\n").append("3) SPT - State pending time - Time the current getNodeState request has been pending.<br>\n").append("4) SSV - System state version - The latest system state version the node has acknowledged.<br>\n").append("5) PC - Premature crashes - Number of times node has crashed since last time it had been stable in up or down state for more than " + RealTimer.printDuration(stableStateTimePeriode) + ".<br>\n").append("6) ELW - Events last week - The number of events that has occured on this node the last week. (Or shorter period if a week haven't passed since restart or more than max events to keep in node event log have happened during last week.)<br>\n").append("</font>\n");
        }
    }
}

