/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import com.yahoo.slime.BinaryFormat;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterStateBundle;
import com.yahoo.vespa.clustercontroller.core.rpc.ClusterStateBundleCodec;
import com.yahoo.vespa.clustercontroller.core.rpc.EncodedClusterStateBundle;
import java.util.HashMap;

public class SlimeClusterStateBundleCodec
implements ClusterStateBundleCodec {
    private static final Compressor compressor = new Compressor(CompressionType.LZ4, 3, 0.9, 1024);

    @Override
    public EncodedClusterStateBundle encode(ClusterStateBundle stateBundle) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        Cursor states = root.setObject("states");
        states.setString("baseline", stateBundle.getBaselineClusterState().toString());
        Cursor spaces = states.setObject("spaces");
        stateBundle.getDerivedBucketSpaceStates().entrySet().forEach(entry -> spaces.setString((String)entry.getKey(), ((ClusterState)entry.getValue()).toString()));
        byte[] serialized = BinaryFormat.encode((Slime)slime);
        Compressor.Compression compression = compressor.compress(serialized);
        return EncodedClusterStateBundle.fromCompressionBuffer(compression);
    }

    @Override
    public ClusterStateBundle decode(EncodedClusterStateBundle encodedClusterStateBundle) {
        byte[] uncompressed = compressor.decompress(encodedClusterStateBundle.getCompression());
        Slime slime = BinaryFormat.decode((byte[])uncompressed);
        Cursor root = slime.get();
        Inspector states = root.field("states");
        ClusterState baseline = ClusterState.stateFromString((String)states.field("baseline").asString());
        Inspector spaces = states.field("spaces");
        HashMap<String, ClusterState> derivedStates = new HashMap<String, ClusterState>();
        spaces.traverse((key, value) -> derivedStates.put(key, ClusterState.stateFromString((String)value.asString())));
        return ClusterStateBundle.of(AnnotatedClusterState.withoutAnnotations(baseline), derivedStates);
    }
}

