/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterStateDeriver;
import com.yahoo.vespa.clustercontroller.core.MergePendingChecker;
import java.util.HashSet;
import java.util.Set;

public class MaintenanceWhenPendingGlobalMerges
implements ClusterStateDeriver {
    private static final String bucketSpaceToCheck = FixedBucketSpaces.globalSpace();
    private static final String bucketSpaceToDerive = FixedBucketSpaces.defaultSpace();
    private final MergePendingChecker mergePendingChecker;

    public MaintenanceWhenPendingGlobalMerges(MergePendingChecker mergePendingChecker) {
        this.mergePendingChecker = mergePendingChecker;
    }

    @Override
    public ClusterState derivedFrom(ClusterState baselineState, String bucketSpace) {
        ClusterState derivedState = baselineState.clone();
        if (!bucketSpace.equals(bucketSpaceToDerive)) {
            return derivedState;
        }
        Set<Integer> incompleteNodeIndices = this.nodesWithMergesNotDone(baselineState);
        if (incompleteNodeIndices.isEmpty()) {
            return derivedState;
        }
        incompleteNodeIndices.forEach(nodeIndex -> derivedState.setNodeState(Node.ofStorage((int)nodeIndex), new NodeState(NodeType.STORAGE, State.MAINTENANCE)));
        return derivedState;
    }

    private Set<Integer> nodesWithMergesNotDone(ClusterState baselineState) {
        HashSet<Integer> incompleteNodes = new HashSet<Integer>();
        int nodeCount = baselineState.getNodeCount(NodeType.STORAGE);
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            if (!this.contentNodeIsAvailable(baselineState, nodeIndex) || !this.hasMergesNotDone(bucketSpaceToCheck, nodeIndex)) continue;
            incompleteNodes.add(nodeIndex);
        }
        return incompleteNodes;
    }

    private boolean contentNodeIsAvailable(ClusterState state, int nodeIndex) {
        return state.getNodeState(Node.ofStorage((int)nodeIndex)).getState().oneOf("uir");
    }

    private boolean hasMergesNotDone(String bucketSpace, int nodeIndex) {
        return this.mergePendingChecker.mayHaveMergesPending(bucketSpace, nodeIndex);
    }
}

