/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ClusterStatsAggregator;

public class ClusterStatsChangeTracker {
    private ClusterStatsAggregator aggregator;
    private boolean prevMayHaveBucketsPending;

    public ClusterStatsChangeTracker(ClusterStatsAggregator aggregator) {
        this.aggregator = aggregator;
        this.prevMayHaveBucketsPending = false;
    }

    public void syncBucketsPendingFlag() {
        this.prevMayHaveBucketsPending = this.aggregator.mayHaveBucketsPendingInGlobalSpace();
    }

    public void updateAggregator(ClusterStatsAggregator newAggregator) {
        this.syncBucketsPendingFlag();
        this.aggregator = newAggregator;
    }

    public boolean statsHaveChanged() {
        if (!this.aggregator.hasUpdatesFromAllDistributors()) {
            return false;
        }
        return this.prevMayHaveBucketsPending != this.aggregator.mayHaveBucketsPendingInGlobalSpace();
    }
}

