/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.document.FixedBucketSpaces;
import com.yahoo.vespa.clustercontroller.core.AggregatedStatsMergePendingChecker;
import com.yahoo.vespa.clustercontroller.core.ContentClusterStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClusterStatsAggregator {
    private final Set<Integer> distributors;
    private final Set<Integer> nonUpdatedDistributors;
    private final Map<Integer, ContentClusterStats> distributorToStats = new HashMap<Integer, ContentClusterStats>();
    private final ContentClusterStats aggregatedStats;

    ClusterStatsAggregator(Set<Integer> distributors, Set<Integer> storageNodes) {
        this.distributors = distributors;
        this.nonUpdatedDistributors = new HashSet<Integer>(distributors);
        this.aggregatedStats = new ContentClusterStats(storageNodes);
    }

    ContentClusterStats getAggregatedStats() {
        return this.aggregatedStats;
    }

    boolean hasUpdatesFromAllDistributors() {
        return this.nonUpdatedDistributors.isEmpty();
    }

    boolean mayHaveBucketsPendingInGlobalSpace() {
        if (!this.hasUpdatesFromAllDistributors()) {
            return true;
        }
        AggregatedStatsMergePendingChecker checker = new AggregatedStatsMergePendingChecker(this.aggregatedStats);
        for (ContentNodeStats stats : this.aggregatedStats) {
            if (!checker.mayHaveMergesPending(FixedBucketSpaces.globalSpace(), stats.getNodeIndex())) continue;
            return true;
        }
        return false;
    }

    void updateForDistributor(int distributorIndex, ContentClusterStats clusterStats) {
        if (!this.distributors.contains(distributorIndex)) {
            return;
        }
        this.nonUpdatedDistributors.remove(distributorIndex);
        this.addStatsFromDistributor(distributorIndex, clusterStats);
    }

    private void addStatsFromDistributor(int distributorIndex, ContentClusterStats clusterStats) {
        ContentClusterStats prevClusterStats = this.distributorToStats.put(distributorIndex, clusterStats);
        for (ContentNodeStats contentNode : this.aggregatedStats) {
            ContentNodeStats statsToSubtract;
            Integer nodeIndex = contentNode.getNodeIndex();
            ContentNodeStats statsToAdd = clusterStats.getContentNode(nodeIndex);
            if (statsToAdd != null) {
                contentNode.add(statsToAdd);
            }
            if (prevClusterStats == null || (statsToSubtract = prevClusterStats.getContentNode(nodeIndex)) == null) continue;
            contentNode.subtract(statsToSubtract);
        }
    }
}

