/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vespa.clustercontroller.core.ContentClusterStats;
import com.yahoo.vespa.clustercontroller.core.ContentNodeStats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClusterStatsAggregator {
    private final Set<Integer> distributors;
    private final Map<Integer, ContentClusterStats> distributorToStats = new HashMap<Integer, ContentClusterStats>();
    private final ContentClusterStats aggregatedStats;

    ClusterStatsAggregator(Set<Integer> distributors, Set<Integer> storageNodes) {
        this.distributors = distributors;
        this.aggregatedStats = new ContentClusterStats(storageNodes);
    }

    ContentClusterStats getAggregatedStats() {
        return this.aggregatedStats;
    }

    void updateForDistributor(int distributorIndex, ContentClusterStats clusterStats) {
        if (!this.distributors.contains(distributorIndex)) {
            return;
        }
        this.addStatsFromDistributor(distributorIndex, clusterStats);
    }

    private void addStatsFromDistributor(int distributorIndex, ContentClusterStats clusterStats) {
        ContentClusterStats prevClusterStats = this.distributorToStats.put(distributorIndex, clusterStats);
        for (ContentNodeStats contentNode : this.aggregatedStats) {
            ContentNodeStats statsToSubtract;
            Integer nodeIndex = contentNode.getNodeIndex();
            ContentNodeStats statsToAdd = clusterStats.getContentNode(nodeIndex);
            if (statsToAdd != null) {
                contentNode.add(statsToAdd);
            }
            if (prevClusterStats == null || (statsToSubtract = prevClusterStats.getContentNode(nodeIndex)) == null) continue;
            contentNode.subtract(statsToSubtract);
        }
    }
}

