/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.log.LogLevel;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.ClusterStatsAggregator;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.hostinfo.StorageNodeStatsBridge;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterStateView {
    private static Logger log = Logger.getLogger(ClusterStateView.class.getName());
    private final ClusterState clusterState;
    private final ClusterStatsAggregator statsAggregator;

    public static ClusterStateView create(String serializedClusterState) throws ParseException {
        ClusterState clusterState = new ClusterState(serializedClusterState);
        return new ClusterStateView(clusterState, ClusterStateView.createNewAggregator(clusterState));
    }

    public static ClusterStateView create(ClusterState clusterState) {
        return new ClusterStateView(clusterState, ClusterStateView.createNewAggregator(clusterState));
    }

    private static ClusterStatsAggregator createNewAggregator(ClusterState clusterState) {
        Set<Integer> upDistributors = ClusterStateView.getIndicesOfUpNodes(clusterState, NodeType.DISTRIBUTOR);
        Set<Integer> upStorageNodes = ClusterStateView.getIndicesOfUpNodes(clusterState, NodeType.STORAGE);
        return new ClusterStatsAggregator(upDistributors, upStorageNodes);
    }

    ClusterStateView(ClusterState clusterState, ClusterStatsAggregator statsAggregator) {
        this.clusterState = clusterState;
        this.statsAggregator = statsAggregator;
    }

    static Set<Integer> getIndicesOfUpNodes(ClusterState clusterState, NodeType type) {
        int nodeCount = clusterState.getNodeCount(type);
        HashSet<Integer> nodesBeingUp = new HashSet<Integer>();
        for (int i = 0; i < nodeCount; ++i) {
            Node node = new Node(type, i);
            NodeState nodeState = clusterState.getNodeState(node);
            State state = nodeState.getState();
            if (state != State.UP && state != State.INITIALIZING && state != State.RETIRED && state != State.MAINTENANCE) continue;
            nodesBeingUp.add(i);
        }
        return nodesBeingUp;
    }

    public ClusterStateView cloneForNewState() {
        ClusterState clonedClusterState = this.clusterState.clone();
        return new ClusterStateView(clonedClusterState, ClusterStateView.createNewAggregator(clonedClusterState));
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public void handleUpdatedHostInfo(Map<Integer, String> hostnames, NodeInfo node, HostInfo hostInfo) {
        int currentStateVersion;
        if (!node.isDistributor()) {
            return;
        }
        if (hostInfo.getClusterStateVersionOrNull() == null) {
            return;
        }
        int hostVersion = hostInfo.getClusterStateVersionOrNull();
        if (hostVersion != (currentStateVersion = this.clusterState.getVersion())) {
            log.log((Level)LogLevel.DEBUG, "Current state version is " + currentStateVersion + ", while host info received from distributor " + node.getNodeIndex() + " is " + hostVersion);
            return;
        }
        this.statsAggregator.updateForDistributor(node.getNodeIndex(), StorageNodeStatsBridge.generate(hostInfo.getDistributor()));
    }

    public String toString() {
        return this.clusterState.toString();
    }
}

