/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.hostinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class StorageNode {
    private final Integer index;
    @JsonProperty(value="ops-latency")
    private OpsLatency opsLatencies;
    @JsonProperty(value="min-current-replication-factor")
    private Integer minCurrentReplicationFactor;
    @JsonProperty(value="outstanding-merge-ops")
    private OutstandingMergeOps outstandingMergeOps;

    @JsonCreator
    public StorageNode(@JsonProperty(value="node-index") Integer index) {
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public OpsLatency getOpsLatenciesOrNull() {
        return this.opsLatencies;
    }

    public Integer getMinCurrentReplicationFactorOrNull() {
        return this.minCurrentReplicationFactor;
    }

    public OutstandingMergeOps getOutstandingMergeOpsOrNull() {
        return this.outstandingMergeOps;
    }

    public static class OutstandingMergeOps {
        @JsonProperty(value="syncing")
        private Buckets syncing;
        @JsonProperty(value="copying-in")
        private Buckets copyingIn;
        @JsonProperty(value="moving-out")
        private Buckets movingOut;
        @JsonProperty(value="copying-out")
        private Buckets copyingOut;

        public Buckets getSyncingOrNull() {
            return this.syncing;
        }

        public Buckets getCopyingInOrNull() {
            return this.copyingIn;
        }

        public Buckets getMovingOutOrNull() {
            return this.movingOut;
        }

        public Buckets getCopyingOutOrNull() {
            return this.copyingOut;
        }
    }

    public static class Buckets {
        private final long buckets;

        @JsonCreator
        public Buckets(@JsonProperty(value="buckets") Long buckets) {
            this.buckets = buckets;
        }

        public long getBuckets() {
            return this.buckets;
        }
    }

    public static class OpsLatency {
        private final Put put;

        @JsonCreator
        public OpsLatency(@JsonProperty(value="put") Put put) {
            this.put = put;
        }

        public Put getPut() {
            return this.put;
        }
    }

    public static class Put {
        private final Long latencyMsSum;
        private final Long count;

        @JsonCreator
        public Put(@JsonProperty(value="latency-ms-sum") Long latencyMsSum, @JsonProperty(value="count") Long count) {
            this.latencyMsSum = latencyMsSum;
            this.count = count;
        }

        public Long getLatencyMsSum() {
            return this.latencyMsSum;
        }

        public Long getCount() {
            return this.count;
        }
    }
}

