/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.slobrok.api.BackOffPolicy;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.distribution.Distribution;
import com.yahoo.vdslib.state.NodeType;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FleetControllerOptions
implements Cloneable {
    public String fleetControllerConfigId;
    public String slobrokConfigId;
    public String clusterName;
    public int fleetControllerIndex = 0;
    public int fleetControllerCount = 1;
    public int stateGatherCount = 2;
    public String[] slobrokConnectionSpecs;
    public int rpcPort = 0;
    public int httpPort = 0;
    public int distributionBits = 16;
    public int zooKeeperSessionTimeout = 300000;
    public int masterZooKeeperCooldownPeriod = 15000;
    public String zooKeeperServerAddress = null;
    public int statePollingFrequency = 5000;
    public Map<NodeType, Integer> maxTransitionTime = new TreeMap<NodeType, Integer>();
    public int maxInitProgressTime = 5000;
    public int maxPrematureCrashes = 4;
    public long stableStateTimePeriod = 0x6DDD00L;
    public int eventLogMaxSize = 1024;
    public int eventNodeLogMaxSize = 1024;
    public int minDistributorNodesUp = 1;
    public int minStorageNodesUp = 1;
    public double minRatioOfDistributorNodesUp = 0.5;
    public double minRatioOfStorageNodesUp = 0.5;
    public double minNodeRatioPerGroup = 0.0;
    public int cycleWaitTime = 100;
    public long minTimeBeforeFirstSystemStateBroadcast = 0L;
    public int nodeStateRequestTimeoutMS = 300000;
    public int nodeStateRequestTimeoutEarliestPercentage = 80;
    public int nodeStateRequestTimeoutLatestPercentage = 95;
    public int nodeStateRequestRoundTripTimeMaxSeconds = 5;
    public int minTimeBetweenNewSystemStates = 0;
    public boolean showLocalSystemStatesInEventLog = true;
    public int maxSlobrokDisconnectGracePeriod = 1000;
    public BackOffPolicy slobrokBackOffPolicy = null;
    public Distribution storageDistribution;
    public Set<ConfiguredNode> nodes;
    private Duration maxDeferredTaskVersionWaitTime = Duration.ofSeconds(30L);
    static DecimalFormat DecimalDot2 = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.ENGLISH));

    public FleetControllerOptions(String clusterName) {
        this.clusterName = clusterName;
        this.maxTransitionTime.put(NodeType.DISTRIBUTOR, 0);
        this.maxTransitionTime.put(NodeType.STORAGE, 5000);
        this.nodes = new TreeSet<ConfiguredNode>();
        for (int i = 0; i < 10; ++i) {
            this.nodes.add(new ConfiguredNode(i, false));
        }
    }

    public FleetControllerOptions(String clusterName, Collection<ConfiguredNode> nodes) {
        this.clusterName = clusterName;
        this.maxTransitionTime.put(NodeType.DISTRIBUTOR, 0);
        this.maxTransitionTime.put(NodeType.STORAGE, 5000);
        this.nodes = new TreeSet<ConfiguredNode>(nodes);
    }

    public void setStorageDistribution(Distribution distribution) {
        this.storageDistribution = distribution;
        this.nodes = distribution.getNodes();
    }

    public Duration getMaxDeferredTaskVersionWaitTime() {
        return this.maxDeferredTaskVersionWaitTime;
    }

    public void setMaxDeferredTaskVersionWaitTime(Duration maxDeferredTaskVersionWaitTime) {
        this.maxDeferredTaskVersionWaitTime = maxDeferredTaskVersionWaitTime;
    }

    public FleetControllerOptions clone() {
        try {
            return (FleetControllerOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Will not happen");
        }
    }

    public static String splitZooKeeperAddress(String s) {
        int index;
        StringBuilder sb = new StringBuilder();
        while ((index = s.indexOf(44)) > 0) {
            sb.append(s.substring(0, index + 1)).append(' ');
            s = s.substring(index + 1);
        }
        sb.append(s);
        return sb.toString();
    }

    public void writeHtmlState(StringBuilder sb, StatusPageServer.HttpRequest request) {
        String slobrokspecs = "";
        for (int i = 0; i < this.slobrokConnectionSpecs.length; ++i) {
            if (i != 0) {
                slobrokspecs = slobrokspecs + "<br>";
            }
            slobrokspecs = slobrokspecs + this.slobrokConnectionSpecs[i];
        }
        sb.append("<h1>Current config</h1>\n").append("<p>Fleet controller config id: ").append(this.fleetControllerConfigId == null ? null : this.fleetControllerConfigId.replaceAll("\n", "<br>\n")).append("</p>\n").append("<p>Slobrok config id: ").append(this.slobrokConfigId == null ? null : this.slobrokConfigId.replaceAll("\n", "<br>\n")).append("</p>\n").append("<table border=\"1\" cellspacing=\"0\"><tr><th>Property</th><th>Value</th></tr>\n");
        sb.append("<tr><td><nobr>Cluster name</nobr></td><td align=\"right\">").append(this.clusterName).append("</td></tr>");
        sb.append("<tr><td><nobr>Fleet controller index</nobr></td><td align=\"right\">").append(this.fleetControllerIndex).append("/").append(this.fleetControllerCount).append("</td></tr>");
        sb.append("<tr><td><nobr>Number of fleetcontrollers gathering states from nodes</nobr></td><td align=\"right\">").append(this.stateGatherCount).append("</td></tr>");
        sb.append("<tr><td><nobr>Slobrok connection spec</nobr></td><td align=\"right\">").append(slobrokspecs).append("</td></tr>");
        sb.append("<tr><td><nobr>RPC port</nobr></td><td align=\"right\">").append(this.rpcPort == 0 ? "Pick random available" : Integer.valueOf(this.rpcPort)).append("</td></tr>");
        sb.append("<tr><td><nobr>HTTP port</nobr></td><td align=\"right\">").append(this.httpPort == 0 ? "Pick random available" : Integer.valueOf(this.httpPort)).append("</td></tr>");
        sb.append("<tr><td><nobr>Master cooldown period</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.masterZooKeeperCooldownPeriod)).append("</td></tr>");
        String zooKeeperAddress = this.zooKeeperServerAddress == null ? "Not using Zookeeper" : FleetControllerOptions.splitZooKeeperAddress(this.zooKeeperServerAddress);
        sb.append("<tr><td><nobr>Zookeeper server address</nobr></td><td align=\"right\">").append(zooKeeperAddress).append("</td></tr>");
        sb.append("<tr><td><nobr>Zookeeper session timeout</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.zooKeeperSessionTimeout)).append("</td></tr>");
        sb.append("<tr><td><nobr>Cycle wait time</nobr></td><td align=\"right\">").append(this.cycleWaitTime).append(" ms</td></tr>");
        sb.append("<tr><td><nobr>Minimum time before first clusterstate broadcast as master</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.minTimeBeforeFirstSystemStateBroadcast)).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum time between official cluster states</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.minTimeBetweenNewSystemStates)).append("</td></tr>");
        sb.append("<tr><td><nobr>Slobrok mirror backoff policy</nobr></td><td align=\"right\">").append(this.slobrokBackOffPolicy == null ? "default" : "overridden").append("</td></tr>");
        sb.append("<tr><td><nobr>Node state request timeout</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.nodeStateRequestTimeoutMS)).append("</td></tr>");
        sb.append("<tr><td><nobr>VDS 4.1 node state polling frequency</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.statePollingFrequency)).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum distributor transition time</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.maxTransitionTime.get(NodeType.DISTRIBUTOR).intValue())).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum storage transition time</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.maxTransitionTime.get(NodeType.STORAGE).intValue())).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum initialize without progress time</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.maxInitProgressTime)).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum premature crashes</nobr></td><td align=\"right\">").append(this.maxPrematureCrashes).append("</td></tr>");
        sb.append("<tr><td><nobr>Stable state time period</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.stableStateTimePeriod)).append("</td></tr>");
        sb.append("<tr><td><nobr>Slobrok disconnect grace period</nobr></td><td align=\"right\">").append(RealTimer.printDuration(this.maxSlobrokDisconnectGracePeriod)).append("</td></tr>");
        sb.append("<tr><td><nobr>Number of distributor nodes</nobr></td><td align=\"right\">").append(this.nodes == null ? "Autodetect" : Integer.valueOf(this.nodes.size())).append("</td></tr>");
        sb.append("<tr><td><nobr>Number of storage nodes</nobr></td><td align=\"right\">").append(this.nodes == null ? "Autodetect" : Integer.valueOf(this.nodes.size())).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum distributor nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(this.minDistributorNodesUp).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum storage nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(this.minStorageNodesUp).append("</td></tr>");
        sb.append("<tr><td><nobr>Minimum percentage of distributor nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(DecimalDot2.format(100.0 * this.minRatioOfDistributorNodesUp)).append(" %</td></tr>");
        sb.append("<tr><td><nobr>Minimum percentage of storage nodes being up for cluster to be up</nobr></td><td align=\"right\">").append(DecimalDot2.format(100.0 * this.minRatioOfStorageNodesUp)).append(" %</td></tr>");
        sb.append("<tr><td><nobr>Show local cluster state changes</nobr></td><td align=\"right\">").append(this.showLocalSystemStatesInEventLog).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum event log size</nobr></td><td align=\"right\">").append(this.eventLogMaxSize).append("</td></tr>");
        sb.append("<tr><td><nobr>Maximum node event log size</nobr></td><td align=\"right\">").append(this.eventNodeLogMaxSize).append("</td></tr>");
        sb.append("<tr><td><nobr>Wanted distribution bits</nobr></td><td align=\"right\">").append(this.distributionBits).append("</td></tr>");
        sb.append("<tr><td><nobr>Max deferred task version wait time</nobr></td><td align=\"right\">").append(this.maxDeferredTaskVersionWaitTime.toMillis()).append("ms</td></tr>");
        sb.append("</table>");
    }
}

