/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core.rpc;

import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.SetClusterStateRequest;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCSetClusterStateRequest;

public class RPCSetClusterStateWaiter
implements RequestWaiter {
    SetClusterStateRequest request;
    Timer timer;
    Communicator.Waiter<SetClusterStateRequest> waiter;

    public RPCSetClusterStateWaiter(Communicator.Waiter<SetClusterStateRequest> waiter, Timer timer) {
        this.timer = timer;
        this.waiter = waiter;
    }

    public void setRequest(RPCSetClusterStateRequest request) {
        this.request = request;
    }

    public SetClusterStateRequest.Reply getReply(Request req) {
        NodeInfo info = this.request.getNodeInfo();
        if (req.methodName().equals("setsystemstate2")) {
            if (req.isError() && req.errorCode() == 106 && info.notifyNoSuchMethodError(req.methodName(), this.timer)) {
                return new SetClusterStateRequest.Reply(9999, "Trying lower version");
            }
            if (req.isError()) {
                return new SetClusterStateRequest.Reply(req.errorCode(), req.errorMessage());
            }
            if (!req.checkReturnTypes("")) {
                return new SetClusterStateRequest.Reply(110, "Got setsystemstate2 response with invalid return types from " + info);
            }
        } else {
            return new SetClusterStateRequest.Reply(110, "Unknown method " + req.methodName());
        }
        return new SetClusterStateRequest.Reply();
    }

    public void handleRequestDone(Request request) {
        SetClusterStateRequest.Reply reply = this.getReply(request);
        this.request.setReply(reply);
        this.waiter.done(this.request);
    }
}

