/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.MasterInterface;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeAddedOrRemovedListener;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeStateOrHostInfoChangeHandler;

public abstract class RemoteClusterControllerTask {
    private final Object monitor = new Object();
    private boolean completed = false;

    public abstract void doRemoteFleetControllerTask(Context var1);

    public boolean hasVersionAckDependency() {
        return false;
    }

    public void handleLeadershipLost() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Object object = this.monitor;
        synchronized (object) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCompleted() {
        Object object = this.monitor;
        synchronized (object) {
            this.completed = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        Object object = this.monitor;
        synchronized (object) {
            while (!this.completed) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class Context {
        public ContentCluster cluster;
        public ClusterState currentState;
        public MasterInterface masterInfo;
        public NodeStateOrHostInfoChangeHandler nodeStateOrHostInfoChangeHandler;
        public NodeAddedOrRemovedListener nodeAddedOrRemovedListener;
    }
}

