/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.clustercontroller.core;

import com.yahoo.jrt.ListenFailedException;
import com.yahoo.log.LogLevel;
import com.yahoo.vdslib.distribution.ConfiguredNode;
import com.yahoo.vdslib.state.ClusterState;
import com.yahoo.vdslib.state.Node;
import com.yahoo.vdslib.state.NodeState;
import com.yahoo.vdslib.state.State;
import com.yahoo.vespa.clustercontroller.core.AnnotatedClusterState;
import com.yahoo.vespa.clustercontroller.core.ClusterEvent;
import com.yahoo.vespa.clustercontroller.core.ClusterStateGenerator;
import com.yahoo.vespa.clustercontroller.core.Communicator;
import com.yahoo.vespa.clustercontroller.core.ContentCluster;
import com.yahoo.vespa.clustercontroller.core.Event;
import com.yahoo.vespa.clustercontroller.core.EventDiffCalculator;
import com.yahoo.vespa.clustercontroller.core.EventLog;
import com.yahoo.vespa.clustercontroller.core.FleetControllerOptions;
import com.yahoo.vespa.clustercontroller.core.MasterElectionHandler;
import com.yahoo.vespa.clustercontroller.core.MetricUpdater;
import com.yahoo.vespa.clustercontroller.core.NodeEvent;
import com.yahoo.vespa.clustercontroller.core.NodeInfo;
import com.yahoo.vespa.clustercontroller.core.NodeLookup;
import com.yahoo.vespa.clustercontroller.core.NodeStateGatherer;
import com.yahoo.vespa.clustercontroller.core.RealTimer;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTask;
import com.yahoo.vespa.clustercontroller.core.RemoteClusterControllerTaskScheduler;
import com.yahoo.vespa.clustercontroller.core.StateChangeHandler;
import com.yahoo.vespa.clustercontroller.core.StateVersionTracker;
import com.yahoo.vespa.clustercontroller.core.SystemStateBroadcaster;
import com.yahoo.vespa.clustercontroller.core.Timer;
import com.yahoo.vespa.clustercontroller.core.database.DatabaseHandler;
import com.yahoo.vespa.clustercontroller.core.hostinfo.HostInfo;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeAddedOrRemovedListener;
import com.yahoo.vespa.clustercontroller.core.listeners.NodeStateOrHostInfoChangeHandler;
import com.yahoo.vespa.clustercontroller.core.listeners.SystemStateListener;
import com.yahoo.vespa.clustercontroller.core.rpc.RPCCommunicator;
import com.yahoo.vespa.clustercontroller.core.rpc.RpcServer;
import com.yahoo.vespa.clustercontroller.core.rpc.SlobrokClient;
import com.yahoo.vespa.clustercontroller.core.status.ClusterStateRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.LegacyIndexPageRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.LegacyNodePageRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.NodeHealthRequestHandler;
import com.yahoo.vespa.clustercontroller.core.status.RunDataExtractor;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageResponse;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServer;
import com.yahoo.vespa.clustercontroller.core.status.statuspage.StatusPageServerInterface;
import com.yahoo.vespa.clustercontroller.utils.util.MetricReporter;
import com.yahoo.vespa.clustercontroller.utils.util.NoMetricReporter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.exception.ExceptionUtils;

public class FleetController
implements NodeStateOrHostInfoChangeHandler,
NodeAddedOrRemovedListener,
SystemStateListener,
Runnable,
RemoteClusterControllerTaskScheduler {
    private static Logger log = Logger.getLogger(FleetController.class.getName());
    private final Timer timer;
    private final Object monitor;
    private final EventLog eventLog;
    private final NodeLookup nodeLookup;
    private final ContentCluster cluster;
    private final Communicator communicator;
    private final NodeStateGatherer stateGatherer;
    private final StateChangeHandler stateChangeHandler;
    private final SystemStateBroadcaster systemStateBroadcaster;
    private final StateVersionTracker stateVersionTracker;
    private final StatusPageServerInterface statusPageServer;
    private final RpcServer rpcServer;
    private final DatabaseHandler database;
    private final MasterElectionHandler masterElectionHandler;
    private Thread runner = null;
    private AtomicBoolean running = new AtomicBoolean(true);
    private FleetControllerOptions options;
    private FleetControllerOptions nextOptions;
    private final List<SystemStateListener> systemStateListeners = new LinkedList<SystemStateListener>();
    private boolean processingCycle = false;
    private boolean wantedStateChanged = false;
    private long cycleCount = 0L;
    private long nextStateSendTime = 0L;
    private Long controllerThreadId = null;
    private boolean waitingForCycle = false;
    private StatusPageServer.PatternRequestRouter statusRequestRouter = new StatusPageServer.PatternRequestRouter();
    private final List<ClusterState> newStates = new ArrayList<ClusterState>();
    private long configGeneration = -1L;
    private long nextConfigGeneration = -1L;
    private Queue<RemoteClusterControllerTask> remoteTasks = new LinkedList<RemoteClusterControllerTask>();
    private final MetricUpdater metricUpdater;
    private boolean isMaster = false;
    private boolean isStateGatherer = false;
    private long firstAllowedStateBroadcast = Long.MAX_VALUE;
    private long tickStartTime = Long.MAX_VALUE;
    private final RunDataExtractor dataExtractor = new RunDataExtractor(){

        @Override
        public ClusterState getLatestClusterState() {
            return FleetController.this.stateVersionTracker.getVersionedClusterState();
        }

        @Override
        public FleetControllerOptions getOptions() {
            return FleetController.this.options;
        }

        @Override
        public long getConfigGeneration() {
            return FleetController.this.configGeneration;
        }

        @Override
        public ContentCluster getCluster() {
            return FleetController.this.cluster;
        }
    };
    public DatabaseHandler.Context databaseContext = new DatabaseHandler.Context(){

        @Override
        public ContentCluster getCluster() {
            return FleetController.this.cluster;
        }

        @Override
        public FleetController getFleetController() {
            return FleetController.this;
        }

        @Override
        public NodeAddedOrRemovedListener getNodeAddedOrRemovedListener() {
            return FleetController.this;
        }

        @Override
        public NodeStateOrHostInfoChangeHandler getNodeStateUpdateListener() {
            return FleetController.this;
        }
    };

    public FleetController(Timer timer, EventLog eventLog, ContentCluster cluster, NodeStateGatherer nodeStateGatherer, Communicator communicator, StatusPageServerInterface statusPage, RpcServer server, NodeLookup nodeLookup, DatabaseHandler database, StateChangeHandler stateChangeHandler, SystemStateBroadcaster systemStateBroadcaster, MasterElectionHandler masterElectionHandler, MetricUpdater metricUpdater, FleetControllerOptions options) throws Exception {
        log.info("Starting up cluster controller " + options.fleetControllerIndex + " for cluster " + cluster.getName());
        this.timer = timer;
        this.monitor = timer;
        this.eventLog = eventLog;
        this.options = options;
        this.nodeLookup = nodeLookup;
        this.cluster = cluster;
        this.communicator = communicator;
        this.database = database;
        this.stateGatherer = nodeStateGatherer;
        this.stateChangeHandler = stateChangeHandler;
        this.systemStateBroadcaster = systemStateBroadcaster;
        this.stateVersionTracker = new StateVersionTracker(metricUpdater);
        this.metricUpdater = metricUpdater;
        this.statusPageServer = statusPage;
        this.rpcServer = server;
        this.masterElectionHandler = masterElectionHandler;
        this.statusRequestRouter.addHandler("^/node=([a-z]+)\\.(\\d+)$", (StatusPageServer.RequestHandler)new LegacyNodePageRequestHandler(timer, eventLog, cluster));
        this.statusRequestRouter.addHandler("^/state.*", (StatusPageServer.RequestHandler)new NodeHealthRequestHandler(this.dataExtractor));
        this.statusRequestRouter.addHandler("^/clusterstate", (StatusPageServer.RequestHandler)new ClusterStateRequestHandler(this.stateVersionTracker));
        this.statusRequestRouter.addHandler("^/$", (StatusPageServer.RequestHandler)new LegacyIndexPageRequestHandler(timer, options.showLocalSystemStatesInEventLog, cluster, masterElectionHandler, this.stateVersionTracker, eventLog, timer.getCurrentTimeInMillis(), this.dataExtractor));
        this.propagateOptions();
    }

    public static FleetController createForContainer(FleetControllerOptions options, StatusPageServerInterface statusPageServer, MetricReporter metricReporter) throws Exception {
        RealTimer timer = new RealTimer();
        return FleetController.create(options, timer, statusPageServer, null, metricReporter);
    }

    public static FleetController createForStandAlone(FleetControllerOptions options) throws Exception {
        RealTimer timer = new RealTimer();
        RpcServer rpcServer = new RpcServer(timer, timer, options.clusterName, options.fleetControllerIndex, options.slobrokBackOffPolicy);
        StatusPageServer statusPageServer = new StatusPageServer(timer, timer, options.httpPort);
        return FleetController.create(options, timer, statusPageServer, rpcServer, (MetricReporter)new NoMetricReporter());
    }

    private static FleetController create(FleetControllerOptions options, Timer timer, StatusPageServerInterface statusPageServer, RpcServer rpcServer, MetricReporter metricReporter) throws Exception {
        MetricUpdater metricUpdater = new MetricUpdater(metricReporter, options.fleetControllerIndex);
        EventLog log = new EventLog(timer, metricUpdater);
        ContentCluster cluster = new ContentCluster(options.clusterName, options.nodes, options.storageDistribution, options.minStorageNodesUp, options.minRatioOfStorageNodesUp);
        NodeStateGatherer stateGatherer = new NodeStateGatherer(timer, timer, log);
        RPCCommunicator communicator = new RPCCommunicator(timer, options.fleetControllerIndex, options.nodeStateRequestTimeoutMS, options.nodeStateRequestTimeoutEarliestPercentage, options.nodeStateRequestTimeoutLatestPercentage, options.nodeStateRequestRoundTripTimeMaxSeconds);
        DatabaseHandler database = new DatabaseHandler(timer, options.zooKeeperServerAddress, options.fleetControllerIndex, timer);
        SlobrokClient lookUp = new SlobrokClient(timer);
        StateChangeHandler stateGenerator = new StateChangeHandler(timer, log, metricUpdater);
        SystemStateBroadcaster stateBroadcaster = new SystemStateBroadcaster(timer, timer);
        MasterElectionHandler masterElectionHandler = new MasterElectionHandler(options.fleetControllerIndex, options.fleetControllerCount, timer, timer);
        FleetController controller = new FleetController(timer, log, cluster, stateGatherer, communicator, statusPageServer, rpcServer, lookUp, database, stateGenerator, stateBroadcaster, masterElectionHandler, metricUpdater, options);
        controller.start();
        return controller;
    }

    public void start() {
        this.runner = new Thread(this);
        this.runner.start();
    }

    public Object getMonitor() {
        return this.monitor;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaster() {
        Object object = this.monitor;
        synchronized (object) {
            return this.masterElectionHandler.isMaster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getClusterState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.systemStateBroadcaster.getClusterState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(RemoteClusterControllerTask task) {
        Object object = this.monitor;
        synchronized (object) {
            log.fine("Scheduled remote task " + task.getClass().getName() + " for execution");
            this.remoteTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemStateListener(SystemStateListener listener) {
        List<SystemStateListener> list = this.systemStateListeners;
        synchronized (list) {
            this.systemStateListeners.add(listener);
            ClusterState state = this.getSystemState();
            if (state == null) {
                throw new NullPointerException("Cluster state should never be null at this point");
            }
            listener.handleNewSystemState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FleetControllerOptions getOptions() {
        Object object = this.monitor;
        synchronized (object) {
            return this.options.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getReportedNodeState(Node n) {
        Object object = this.monitor;
        synchronized (object) {
            NodeInfo node = this.cluster.getNodeInfo(n);
            if (node == null) {
                throw new IllegalStateException("Did not find node " + n + " in cluster " + this.cluster);
            }
            return node.getReportedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getWantedNodeState(Node n) {
        Object object = this.monitor;
        synchronized (object) {
            return this.cluster.getNodeInfo(n).getWantedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getSystemState() {
        Object object = this.monitor;
        synchronized (object) {
            return this.stateVersionTracker.getVersionedClusterState();
        }
    }

    public int getHttpPort() {
        return this.statusPageServer.getPort();
    }

    public int getRpcPort() {
        return this.rpcServer.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException, IOException {
        if (this.runner != null && this.isRunning()) {
            log.log(LogLevel.INFO, "Joining event thread.");
            this.running.set(false);
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
            this.runner.join();
        }
        log.log(LogLevel.INFO, "Fleetcontroller done shutting down event thread.");
        this.controllerThreadId = Thread.currentThread().getId();
        this.database.shutdown(this);
        if (this.statusPageServer != null) {
            this.statusPageServer.shutdown();
        }
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        this.communicator.shutdown();
        this.nodeLookup.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOptions(FleetControllerOptions options, long configGeneration) {
        Object object = this.monitor;
        synchronized (object) {
            assert (this.options.fleetControllerIndex == options.fleetControllerIndex);
            log.log(LogLevel.INFO, "Fleetcontroller " + options.fleetControllerIndex + " has new options");
            this.nextOptions = options.clone();
            this.nextConfigGeneration = configGeneration;
            this.monitor.notifyAll();
        }
    }

    private void verifyInControllerThread() {
        if (this.controllerThreadId != null && this.controllerThreadId.longValue() != Thread.currentThread().getId()) {
            throw new IllegalStateException("Function called from non-controller thread. Shouldn't happen.");
        }
    }

    private ClusterState latestCandidateClusterState() {
        return this.stateVersionTracker.getLatestCandidateState().getClusterState();
    }

    @Override
    public void handleNewNodeState(NodeInfo node, NodeState newState) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewReportedNodeState(this.latestCandidateClusterState(), node, newState, this);
    }

    @Override
    public void handleNewWantedNodeState(NodeInfo node, NodeState newState) {
        this.verifyInControllerThread();
        this.wantedStateChanged = true;
        this.stateChangeHandler.proposeNewNodeState(this.stateVersionTracker.getVersionedClusterState(), node, newState);
    }

    @Override
    public void handleUpdatedHostInfo(NodeInfo nodeInfo, HostInfo newHostInfo) {
        this.verifyInControllerThread();
        this.stateVersionTracker.handleUpdatedHostInfo(this.stateChangeHandler.getHostnames(), nodeInfo, newHostInfo);
    }

    @Override
    public void handleNewNode(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewNode(node);
    }

    @Override
    public void handleMissingNode(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleMissingNode(this.stateVersionTracker.getVersionedClusterState(), node, this);
    }

    @Override
    public void handleNewRpcAddress(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleNewRpcAddress(node);
    }

    @Override
    public void handleReturnedRpcAddress(NodeInfo node) {
        this.verifyInControllerThread();
        this.stateChangeHandler.handleReturnedRpcAddress(node);
    }

    @Override
    public void handleNewSystemState(ClusterState state) {
        this.verifyInControllerThread();
        this.newStates.add(state);
        this.metricUpdater.updateClusterStateMetrics(this.cluster, state);
        this.systemStateBroadcaster.handleNewSystemState(state);
        if (this.masterElectionHandler.isMaster()) {
            this.storeClusterStateVersionToZooKeeper(state);
        }
    }

    private void storeClusterStateVersionToZooKeeper(ClusterState state) {
        try {
            this.database.saveLatestSystemStateVersion(this.databaseContext, state.getVersion());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("ZooKeeper write interrupted", e);
        }
    }

    public void handleFleetData(Map<Integer, Integer> data) {
        this.verifyInControllerThread();
        log.log((Level)LogLevel.SPAM, "Sending fleet data event on to master election handler");
        this.metricUpdater.updateMasterElectionMetrics(data);
        this.masterElectionHandler.handleFleetData(data);
    }

    public void lostDatabaseConnection() {
        this.verifyInControllerThread();
        this.masterElectionHandler.lostDatabaseConnection();
    }

    public void handleAllDistributorsInSync(DatabaseHandler database, DatabaseHandler.Context context) throws InterruptedException {
        HashSet<ConfiguredNode> nodes = new HashSet<ConfiguredNode>(this.cluster.clusterInfo().getConfiguredNodes().values());
        this.stateChangeHandler.handleAllDistributorsInSync(this.stateVersionTracker.getVersionedClusterState(), nodes, database, context);
    }

    private boolean changesConfiguredNodeSet(Collection<ConfiguredNode> newNodes) {
        if (newNodes.size() != this.cluster.getConfiguredNodes().size()) {
            return true;
        }
        if (!this.cluster.getConfiguredNodes().values().containsAll(newNodes)) {
            return true;
        }
        for (ConfiguredNode node : newNodes) {
            if (node.retired() == this.cluster.getConfiguredNodes().get(node.index()).retired()) continue;
            return true;
        }
        return false;
    }

    private void propagateOptions() throws IOException, ListenFailedException {
        this.verifyInControllerThread();
        if (this.changesConfiguredNodeSet(this.options.nodes)) {
            this.cluster.setSlobrokGenerationCount(0);
        }
        this.communicator.propagateOptions(this.options);
        if (this.nodeLookup instanceof SlobrokClient) {
            ((SlobrokClient)this.nodeLookup).setSlobrokConnectionSpecs(this.options.slobrokConnectionSpecs);
        }
        this.eventLog.setMaxSize(this.options.eventLogMaxSize, this.options.eventNodeLogMaxSize);
        this.cluster.setPollingFrequency(this.options.statePollingFrequency);
        this.cluster.setDistribution(this.options.storageDistribution);
        this.cluster.setNodes(this.options.nodes);
        this.cluster.setMinRatioOfStorageNodesUp(this.options.minRatioOfStorageNodesUp);
        this.cluster.setMinStorageNodesUp(this.options.minStorageNodesUp);
        this.database.setZooKeeperAddress(this.options.zooKeeperServerAddress);
        this.database.setZooKeeperSessionTimeout(this.options.zooKeeperSessionTimeout);
        this.stateGatherer.setMaxSlobrokDisconnectGracePeriod(this.options.maxSlobrokDisconnectGracePeriod);
        this.stateGatherer.setNodeStateRequestTimeout(this.options.nodeStateRequestTimeoutMS);
        this.stateChangeHandler.reconfigureFromOptions(this.options);
        this.stateChangeHandler.setStateChangedFlag();
        this.masterElectionHandler.setFleetControllerCount(this.options.fleetControllerCount);
        this.masterElectionHandler.setMasterZooKeeperCooldownPeriod(this.options.masterZooKeeperCooldownPeriod);
        if (this.rpcServer != null) {
            this.rpcServer.setMasterElectionHandler(this.masterElectionHandler);
            try {
                this.rpcServer.setSlobrokConnectionSpecs(this.options.slobrokConnectionSpecs, this.options.rpcPort);
            }
            catch (ListenFailedException e) {
                log.log(LogLevel.WARNING, "Failed to bind RPC server to port " + this.options.rpcPort + ". This may be natural if cluster has altered the services running on this node: " + e.getMessage());
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Failed to initialize RPC server socket: " + e.getMessage());
            }
        }
        if (this.statusPageServer != null) {
            try {
                this.statusPageServer.setPort(this.options.httpPort);
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, "Failed to initialize status server socket. This may be natural if cluster has altered the services running on this node: " + e.getMessage());
            }
        }
        long currentTime = this.timer.getCurrentTimeInMillis();
        this.nextStateSendTime = Math.min(currentTime + (long)this.options.minTimeBetweenNewSystemStates, this.nextStateSendTime);
        this.configGeneration = this.nextConfigGeneration;
        this.nextConfigGeneration = -1L;
    }

    public StatusPageResponse fetchStatusPage(StatusPageServer.HttpRequest httpRequest) {
        String message;
        StatusPageResponse.ResponseCode responseCode;
        this.verifyInControllerThread();
        String hiddenMessage = "";
        try {
            StatusPageServer.RequestHandler handler = this.statusRequestRouter.resolveHandler(httpRequest);
            if (handler == null) {
                throw new FileNotFoundException("No handler found for request: " + httpRequest.getPath());
            }
            return handler.handle(httpRequest);
        }
        catch (FileNotFoundException e) {
            responseCode = StatusPageResponse.ResponseCode.NOT_FOUND;
            message = e.getMessage();
        }
        catch (Exception e) {
            responseCode = StatusPageResponse.ResponseCode.INTERNAL_SERVER_ERROR;
            message = "Internal Server Error";
            hiddenMessage = ExceptionUtils.getStackTrace((Throwable)e);
            log.log((Level)LogLevel.DEBUG, "Unknown exception thrown for request " + httpRequest.getRequest() + ": " + hiddenMessage);
        }
        TimeZone tz = TimeZone.getTimeZone("UTC");
        long currentTime = this.timer.getCurrentTimeInMillis();
        StatusPageResponse response = new StatusPageResponse();
        StringBuilder content = new StringBuilder();
        response.setContentType("text/html");
        response.setResponseCode(responseCode);
        content.append("<!-- Answer to request " + httpRequest.getRequest() + " -->\n");
        content.append("<p>UTC time when creating this page: ").append(RealTimer.printDateNoMilliSeconds(currentTime, tz)).append("</p>");
        response.writeHtmlHeader(content, message);
        response.writeHtmlFooter(content, hiddenMessage);
        response.writeContent(content.toString());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            boolean didWork = this.database.doNextZooKeeperTask(this.databaseContext);
            didWork |= this.updateMasterElectionState();
            didWork |= this.handleLeadershipEdgeTransitions();
            this.stateChangeHandler.setMaster(this.isMaster);
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.stateGatherer.processResponses(this);
            if (!this.isRunning()) {
                return;
            }
            if (this.masterElectionHandler.isAmongNthFirst(this.options.stateGatherCount)) {
                didWork |= this.resyncLocallyCachedState();
            } else {
                this.stepDownAsStateGatherer();
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.systemStateBroadcaster.processResponses();
            if (!this.isRunning()) {
                return;
            }
            if (this.masterElectionHandler.isMaster()) {
                didWork |= this.broadcastClusterStateToEligibleNodes();
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.processAnyPendingStatusPageRequest();
            if (!this.isRunning()) {
                return;
            }
            if (this.rpcServer != null) {
                didWork |= this.rpcServer.handleRpcRequests(this.cluster, this.consolidatedClusterState(), this, this);
            }
            if (!this.isRunning()) {
                return;
            }
            didWork |= this.processNextQueuedRemoteTask();
            this.processingCycle = false;
            ++this.cycleCount;
            long tickStopTime = this.timer.getCurrentTimeInMillis();
            if (tickStopTime >= this.tickStartTime) {
                this.metricUpdater.addTickTime(tickStopTime - this.tickStartTime, didWork);
            }
            if (!didWork && !this.waitingForCycle) {
                this.monitor.wait(this.options.cycleWaitTime);
            }
            if (!this.isRunning()) {
                return;
            }
            this.tickStartTime = this.timer.getCurrentTimeInMillis();
            this.processingCycle = true;
            if (this.nextOptions != null) {
                this.switchToNewConfig();
            }
        }
        if (this.isRunning()) {
            this.propagateNewStatesToListeners();
        }
    }

    private boolean updateMasterElectionState() throws InterruptedException {
        try {
            return this.masterElectionHandler.watchMasterElection(this.database, this.databaseContext);
        }
        catch (InterruptedException e) {
            throw (InterruptedException)new InterruptedException("Interrupted").initCause(e);
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Failed to watch master election: " + e.toString());
            return false;
        }
    }

    private void stepDownAsStateGatherer() {
        if (this.isStateGatherer) {
            this.cluster.clearStates();
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node is no longer a node state gatherer.", this.timer.getCurrentTimeInMillis()));
        }
        this.isStateGatherer = false;
    }

    private void switchToNewConfig() {
        this.options = this.nextOptions;
        this.nextOptions = null;
        try {
            this.propagateOptions();
        }
        catch (Exception e) {
            log.log((Level)LogLevel.ERROR, "Failed to handle new fleet controller config", e);
        }
    }

    private boolean processAnyPendingStatusPageRequest() {
        StatusPageServer.HttpRequest statusRequest;
        if (this.statusPageServer != null && (statusRequest = this.statusPageServer.getCurrentHttpRequest()) != null) {
            this.statusPageServer.answerCurrentStatusRequest(this.fetchStatusPage(statusRequest));
            return true;
        }
        return false;
    }

    private boolean broadcastClusterStateToEligibleNodes() throws InterruptedException {
        boolean sentAny = false;
        long currentTime = this.timer.getCurrentTimeInMillis();
        if ((currentTime >= this.firstAllowedStateBroadcast || this.cluster.allStatesReported()) && currentTime >= this.nextStateSendTime) {
            if (currentTime < this.firstAllowedStateBroadcast) {
                log.log((Level)LogLevel.DEBUG, "Not set to broadcast states just yet, but as we have gotten info from all nodes we can do so safely.");
                this.firstAllowedStateBroadcast = currentTime;
            }
            if (sentAny = this.systemStateBroadcaster.broadcastNewState(this.database, this.databaseContext, this.communicator, this)) {
                this.nextStateSendTime = currentTime + (long)this.options.minTimeBetweenNewSystemStates;
            }
        }
        return sentAny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateNewStatesToListeners() {
        if (!this.newStates.isEmpty()) {
            List<SystemStateListener> list = this.systemStateListeners;
            synchronized (list) {
                for (ClusterState state : this.newStates) {
                    for (SystemStateListener listener : this.systemStateListeners) {
                        listener.handleNewSystemState(state);
                    }
                }
                this.newStates.clear();
            }
        }
    }

    private boolean processNextQueuedRemoteTask() {
        if (!this.remoteTasks.isEmpty()) {
            RemoteClusterControllerTask.Context context = this.createRemoteTaskProcessingContext();
            RemoteClusterControllerTask task = this.remoteTasks.poll();
            log.finest("Processing remote task " + task.getClass().getName());
            task.doRemoteFleetControllerTask(context);
            task.notifyCompleted();
            log.finest("Done processing remote task " + task.getClass().getName());
            return true;
        }
        return false;
    }

    private RemoteClusterControllerTask.Context createRemoteTaskProcessingContext() {
        RemoteClusterControllerTask.Context context = new RemoteClusterControllerTask.Context();
        context.cluster = this.cluster;
        context.currentState = this.consolidatedClusterState();
        context.masterInfo = this.masterElectionHandler;
        context.nodeStateOrHostInfoChangeHandler = this;
        context.nodeAddedOrRemovedListener = this;
        return context;
    }

    ClusterState consolidatedClusterState() {
        ClusterState publishedState = this.stateVersionTracker.getVersionedClusterState();
        if (publishedState.getClusterState() == State.UP) {
            return publishedState;
        }
        ClusterState current = this.stateVersionTracker.getLatestCandidateState().getClusterState().clone();
        current.setVersion(publishedState.getVersion());
        return current;
    }

    private boolean resyncLocallyCachedState() throws InterruptedException {
        boolean didWork = false;
        if (!this.isMaster && this.cycleCount % 100L == 0L) {
            didWork = this.database.loadWantedStates(this.databaseContext);
            didWork |= this.database.loadStartTimestamps(this.cluster);
        }
        didWork |= this.nodeLookup.updateCluster(this.cluster, this);
        didWork |= this.stateGatherer.sendMessages(this.cluster, this.communicator, this);
        didWork |= this.stateChangeHandler.watchTimers(this.cluster, this.consolidatedClusterState(), this);
        didWork |= this.recomputeClusterStateIfRequired();
        if (!this.isStateGatherer && !this.isMaster) {
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node just became node state gatherer as we are fleetcontroller master candidate.", this.timer.getCurrentTimeInMillis()));
            this.stateVersionTracker.setVersionRetrievedFromZooKeeper(this.database.getLatestSystemStateVersion());
        }
        this.isStateGatherer = true;
        return didWork;
    }

    private boolean recomputeClusterStateIfRequired() {
        if (this.mustRecomputeCandidateClusterState()) {
            this.stateChangeHandler.unsetStateChangedFlag();
            AnnotatedClusterState candidate = this.computeCurrentAnnotatedState();
            this.stateVersionTracker.updateLatestCandidateState(candidate);
            if (this.stateVersionTracker.candidateChangedEnoughFromCurrentToWarrantPublish() || this.stateVersionTracker.hasReceivedNewVersionFromZooKeeper()) {
                long timeNowMs = this.timer.getCurrentTimeInMillis();
                AnnotatedClusterState before = this.stateVersionTracker.getAnnotatedVersionedClusterState();
                this.stateVersionTracker.promoteCandidateToVersionedState(timeNowMs);
                this.emitEventsForAlteredStateEdges(before, this.stateVersionTracker.getAnnotatedVersionedClusterState(), timeNowMs);
                this.handleNewSystemState(this.stateVersionTracker.getVersionedClusterState());
                return true;
            }
        }
        return false;
    }

    private AnnotatedClusterState computeCurrentAnnotatedState() {
        ClusterStateGenerator.Params params = ClusterStateGenerator.Params.fromOptions(this.options);
        params.currentTimeInMilllis(this.timer.getCurrentTimeInMillis()).cluster(this.cluster).lowestObservedDistributionBitCount(this.stateVersionTracker.getLowestObservedDistributionBits());
        return ClusterStateGenerator.generatedStateFrom(params);
    }

    private void emitEventsForAlteredStateEdges(AnnotatedClusterState fromState, AnnotatedClusterState toState, long timeNowMs) {
        List<Event> deltaEvents = EventDiffCalculator.computeEventDiff(EventDiffCalculator.params().cluster(this.cluster).fromState(fromState).toState(toState).currentTimeMs(timeNowMs));
        for (Event event : deltaEvents) {
            this.eventLog.add(event, this.isMaster);
        }
        this.emitStateAppliedEvents(timeNowMs, fromState.getClusterState(), toState.getClusterState());
    }

    private void emitStateAppliedEvents(long timeNowMs, ClusterState fromClusterState, ClusterState toClusterState) {
        this.eventLog.add(new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, "New cluster state version " + toClusterState.getVersion() + ". Change from last: " + fromClusterState.getTextualDifference(toClusterState), timeNowMs), this.isMaster);
        if (toClusterState.getDistributionBitCount() != fromClusterState.getDistributionBitCount()) {
            this.eventLog.add(new ClusterEvent(ClusterEvent.Type.SYSTEMSTATE, "Altering distribution bits in system from " + fromClusterState.getDistributionBitCount() + " to " + toClusterState.getDistributionBitCount(), timeNowMs), this.isMaster);
        }
    }

    private boolean mustRecomputeCandidateClusterState() {
        return this.stateChangeHandler.stateMayHaveChanged() || this.stateVersionTracker.hasReceivedNewVersionFromZooKeeper();
    }

    private boolean handleLeadershipEdgeTransitions() throws InterruptedException {
        boolean didWork = false;
        if (this.masterElectionHandler.isMaster()) {
            if (!this.isMaster) {
                this.metricUpdater.becameMaster();
                this.stateVersionTracker.setVersionRetrievedFromZooKeeper(this.database.getLatestSystemStateVersion());
                didWork = this.database.loadStartTimestamps(this.cluster);
                didWork |= this.database.loadWantedStates(this.databaseContext);
                this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node just became fleetcontroller master. Bumped version to " + this.stateVersionTracker.getCurrentVersion() + " to be in line.", this.timer.getCurrentTimeInMillis()));
                long currentTime = this.timer.getCurrentTimeInMillis();
                this.firstAllowedStateBroadcast = currentTime + this.options.minTimeBeforeFirstSystemStateBroadcast;
                log.log((Level)LogLevel.DEBUG, "At time " + currentTime + " we set first system state broadcast time to be " + this.options.minTimeBeforeFirstSystemStateBroadcast + " ms after at time " + this.firstAllowedStateBroadcast + ".");
            }
            this.isMaster = true;
            if (this.wantedStateChanged) {
                this.database.saveWantedStates(this.databaseContext);
                this.wantedStateChanged = false;
            }
        } else {
            if (this.isMaster) {
                this.eventLog.add(new ClusterEvent(ClusterEvent.Type.MASTER_ELECTION, "This node is no longer fleetcontroller master.", this.timer.getCurrentTimeInMillis()));
                this.firstAllowedStateBroadcast = Long.MAX_VALUE;
                this.metricUpdater.noLongerMaster();
            }
            this.wantedStateChanged = false;
            this.isMaster = false;
        }
        return didWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.controllerThreadId = Thread.currentThread().getId();
        try {
            this.processingCycle = true;
            while (this.isRunning()) {
                this.tick();
            }
        }
        catch (InterruptedException e) {
            log.log((Level)LogLevel.DEBUG, "Event thread stopped by interrupt exception: " + e);
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.log((Level)LogLevel.ERROR, "Fatal error killed fleet controller", t);
            Object object = this.monitor;
            synchronized (object) {
                this.running.set(false);
            }
            System.exit(1);
        }
        finally {
            this.running.set(false);
            Object e = this.monitor;
            synchronized (e) {
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompleteCycle(long timeoutMS) {
        long endTime = System.currentTimeMillis() + timeoutMS;
        Object object = this.monitor;
        synchronized (object) {
            long wantedCycle = this.cycleCount + (long)(this.processingCycle ? 2 : 1);
            this.waitingForCycle = true;
            try {
                while (this.cycleCount < wantedCycle) {
                    if (System.currentTimeMillis() > endTime) {
                        throw new IllegalStateException("Timed out waiting for cycle to complete. Not completed after " + timeoutMS + " ms.");
                    }
                    if (!this.isRunning()) {
                        throw new IllegalStateException("Fleetcontroller not running. Will never complete cycles");
                    }
                    try {
                        this.monitor.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.waitingForCycle = false;
            }
        }
    }

    public void waitForNodesHavingSystemStateVersionEqualToOrAbove(int version, int nodeCount, int timeout) throws InterruptedException {
        long maxTime = System.currentTimeMillis() + (long)timeout;
        Object object = this.monitor;
        synchronized (object) {
            while (true) {
                int ackedNodes = 0;
                for (NodeInfo node : this.cluster.getNodeInfo()) {
                    if (node.getSystemStateVersionAcknowledged() < version) continue;
                    ++ackedNodes;
                }
                if (ackedNodes >= nodeCount) {
                    log.log(LogLevel.INFO, ackedNodes + " nodes now have acked system state " + version + " or higher.");
                    return;
                }
                long remainingTime = maxTime - System.currentTimeMillis();
                if (remainingTime <= 0L) {
                    throw new IllegalStateException("Did not get " + nodeCount + " nodes to system state " + version + " within timeout of " + timeout + " milliseconds.");
                }
                this.monitor.wait(10L);
            }
        }
    }

    public void waitForNodesInSlobrok(int distNodeCount, int storNodeCount, int timeoutMillis) throws InterruptedException {
        long maxTime = System.currentTimeMillis() + (long)timeoutMillis;
        Object object = this.monitor;
        synchronized (object) {
            while (true) {
                int distCount = 0;
                int storCount = 0;
                for (NodeInfo info : this.cluster.getNodeInfo()) {
                    if (info.isRpcAddressOutdated()) continue;
                    if (info.isDistributor()) {
                        ++distCount;
                        continue;
                    }
                    ++storCount;
                }
                if (distCount == distNodeCount && storCount == storNodeCount) {
                    return;
                }
                long remainingTime = maxTime - System.currentTimeMillis();
                if (remainingTime <= 0L) {
                    throw new IllegalStateException("Did not get all " + distNodeCount + " distributors and " + storNodeCount + " storage nodes registered in slobrok within timeout of " + timeoutMillis + " ms. (Got " + distCount + " distributors and " + storCount + " storage nodes)");
                }
                this.monitor.wait(10L);
            }
        }
    }

    public boolean hasZookeeperConnection() {
        return !this.database.isClosed();
    }

    public int getSlobrokMirrorUpdates() {
        return ((SlobrokClient)this.nodeLookup).getMirror().updates();
    }

    public ContentCluster getCluster() {
        return this.cluster;
    }

    public List<NodeEvent> getNodeEvents(Node n) {
        return this.eventLog.getNodeEvents(n);
    }

    public EventLog getEventLog() {
        return this.eventLog;
    }
}

