/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.cd.cloud.impl;

import ai.vespa.cloud.Environment;
import ai.vespa.cloud.Zone;
import ai.vespa.feed.client.FeedClientBuilder;
import ai.vespa.hosted.api.ControllerHttpClient;
import ai.vespa.hosted.api.DefaultApiAuthenticator;
import ai.vespa.hosted.api.Properties;
import ai.vespa.hosted.api.TestConfig;
import ai.vespa.hosted.cd.Deployment;
import ai.vespa.hosted.cd.TestRuntime;
import ai.vespa.hosted.cd.commons.DefaultEndpointAuthenticator;
import ai.vespa.hosted.cd.commons.EndpointAuthenticator;
import ai.vespa.hosted.cd.commons.HttpDeployment;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.zone.ZoneId;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;

public class VespaTestRuntime
implements TestRuntime {
    private final TestConfig config;
    private final Deployment deploymentToTest;

    public VespaTestRuntime() {
        this(VespaTestRuntime.configFromPropertyOrController());
    }

    public VespaTestRuntime(byte[] config) {
        this(VespaTestRuntime.fromByteArray(config));
    }

    private VespaTestRuntime(TestConfig config) {
        this.config = config;
        DefaultEndpointAuthenticator authenticator = new DefaultEndpointAuthenticator(config.system());
        this.deploymentToTest = new HttpDeployment((Map)config.deployments().get(config.zone()), (EndpointAuthenticator)authenticator);
        ai.vespa.hosted.cd.commons.FeedClientBuilder.setEndpointAuthenticator((EndpointAuthenticator)authenticator);
        FeedClientBuilder.setFeedClientBuilderSupplier(ai.vespa.hosted.cd.commons.FeedClientBuilder::new);
    }

    public Zone zone() {
        return new Zone(Environment.valueOf((String)this.config.zone().environment().name()), this.config.zone().region().value());
    }

    public Deployment deploymentToTest() {
        return this.deploymentToTest;
    }

    private static TestConfig configFromPropertyOrController() {
        String configPath = System.getProperty("vespa.test.config");
        if (configPath != null) {
            System.out.println("TestRuntime: Using test config from " + configPath);
            return VespaTestRuntime.fromFile(configPath);
        }
        System.out.println("TestRuntime: Using test config from Vespa Cloud");
        return VespaTestRuntime.fromController();
    }

    private static TestConfig fromFile(String path) {
        try {
            return TestConfig.fromJson((byte[])Files.readAllBytes(Paths.get(path, new String[0])));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed reading config from '" + path + "'!", e);
        }
    }

    private static TestConfig fromByteArray(byte[] config) {
        return TestConfig.fromJson((byte[])config);
    }

    private static TestConfig fromController() {
        ControllerHttpClient controller = new DefaultApiAuthenticator().controller();
        ApplicationId id = Properties.application();
        com.yahoo.config.provision.Environment environment = Properties.environment().orElse(com.yahoo.config.provision.Environment.dev);
        ZoneId zone = Properties.region().map(region -> ZoneId.from((com.yahoo.config.provision.Environment)environment, (RegionName)region)).orElseGet(() -> controller.defaultZone(environment));
        System.out.println("TestRuntime: Requesting endpoint config for tenant.application.instance: " + id.toFullString());
        System.out.println("TestRuntime: Zone: " + zone.toString());
        return controller.testConfig(id, zone);
    }
}

