/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Sources;
import java.util.UUID;

public class UserInput
extends QueryChain {
    private final Annotation annotation;
    private final String value;
    private final boolean valueIsReference;
    private final String indexField;
    private boolean setDefaultIndex;

    UserInput(Sources sources, String value) {
        this(sources, A.empty(), value);
    }

    UserInput(Sources sources, Annotation annotation, String value) {
        this.sources = sources;
        this.annotation = annotation;
        this.value = value;
        this.valueIsReference = value.startsWith("@");
        this.nonEmpty = true;
        if (annotation.contains("defaultIndex")) {
            this.setDefaultIndex = true;
            this.indexField = (String)annotation.get("defaultIndex");
        } else {
            this.indexField = UUID.randomUUID().toString().substring(0, 5);
        }
    }

    UserInput(String value) {
        this(A.empty(), value);
    }

    UserInput(Annotation annotation, String value) {
        this(null, annotation, value);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.setDefaultIndex) {
            b.append("(").append(this.annotation);
        }
        b.append("userInput(");
        if (!this.valueIsReference) {
            b.append("\"");
        }
        b.append(this.value);
        if (!this.valueIsReference) {
            b.append("\"");
        }
        b.append(")");
        if (this.setDefaultIndex) {
            b.append(")");
        }
        return b.toString();
    }

    @Override
    boolean hasPositiveSearchField(String fieldName) {
        return !"andnot".equals(this.op) && this.indexField.equals(fieldName);
    }

    @Override
    boolean hasPositiveSearchField(String fieldName, Object value) {
        return this.hasPositiveSearchField(fieldName) && this.value.equals(value);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName) {
        return "andnot".equals(this.op) && this.indexField.equals(fieldName);
    }

    @Override
    boolean hasNegativeSearchField(String fieldName, Object value) {
        return this.hasNegativeSearchField(fieldName) && this.value.equals(value);
    }
}

