/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.client.dsl;

import ai.vespa.client.dsl.A;
import ai.vespa.client.dsl.Annotation;
import ai.vespa.client.dsl.Q;
import ai.vespa.client.dsl.QueryChain;
import ai.vespa.client.dsl.Select;
import ai.vespa.client.dsl.Text;
import java.util.List;
import java.util.Map;

public class Wand
extends QueryChain {
    private final String fieldName;
    private final Object value;
    private Annotation annotation;

    Wand(String fieldName, Map<String, Integer> weightedSet) {
        this.fieldName = fieldName;
        this.value = weightedSet;
        this.nonEmpty = true;
    }

    Wand(String fieldName, List<List<Integer>> numeric) {
        boolean invalid = numeric.stream().anyMatch(range -> range.size() != 2);
        if (invalid) {
            throw new IllegalArgumentException("incorrect range format");
        }
        this.fieldName = fieldName;
        this.value = numeric;
        this.nonEmpty = true;
    }

    public Wand annotate(Annotation annotation) {
        this.annotation = annotation;
        return this;
    }

    @Override
    public Select getSelect() {
        return this.sources.select;
    }

    @Override
    boolean hasPositiveSearchField(String fieldName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    @Override
    boolean hasPositiveSearchField(String fieldName, Object value) {
        throw new UnsupportedOperationException("method not implemented");
    }

    @Override
    boolean hasNegativeSearchField(String fieldName) {
        throw new UnsupportedOperationException("method not implemented");
    }

    @Override
    boolean hasNegativeSearchField(String fieldName, Object value) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public String toString() {
        boolean hasAnnotation = A.hasAnnotation(this.annotation);
        String s = Text.format("wand(%s, %s)", this.fieldName, Q.toJson(this.value));
        return hasAnnotation ? Text.format("([%s]%s)", this.annotation, s) : s;
    }
}

