/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.google.common.collect.Sets;
import com.yahoo.api.annotations.PublicApi;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.ExportPackageAnnotation;
import com.yahoo.container.plugin.classanalysis.Packages;
import com.yahoo.container.plugin.util.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PackageTally {
    private final Map<String, Optional<ExportPackageAnnotation>> definedPackagesMap;
    private final Set<String> referencedPackagesUnfiltered;

    PackageTally(Map<String, Optional<ExportPackageAnnotation>> definedPackagesMap, Set<String> referencedPackagesUnfiltered) {
        this.definedPackagesMap = definedPackagesMap;
        this.referencedPackagesUnfiltered = referencedPackagesUnfiltered;
    }

    public Set<String> definedPackages() {
        return this.definedPackagesMap.keySet();
    }

    public Set<String> referencedPackages() {
        return Sets.difference(this.referencedPackagesUnfiltered, this.definedPackages());
    }

    public Map<String, ExportPackageAnnotation> exportedPackages() {
        HashMap<String, ExportPackageAnnotation> ret = new HashMap<String, ExportPackageAnnotation>();
        this.definedPackagesMap.forEach((k, v) -> v.ifPresent(annotation -> ret.put((String)k, (ExportPackageAnnotation)annotation)));
        return ret;
    }

    public Set<String> referencedPackagesMissingFrom(Set<String> definedAndExportedPackages) {
        return Sets.difference(this.referencedPackages(), definedAndExportedPackages).stream().filter(pkg -> !pkg.startsWith("java.")).filter(pkg -> !pkg.equals(PublicApi.class.getPackageName())).collect(Collectors.toSet());
    }

    public PackageTally combine(PackageTally other) {
        Map<String, Optional<ExportPackageAnnotation>> map = Maps.combine(this.definedPackagesMap, other.definedPackagesMap, (l, r) -> l.isPresent() ? l : r);
        HashSet<String> referencedPkgs = new HashSet<String>(this.referencedPackagesUnfiltered);
        referencedPkgs.addAll(other.referencedPackagesUnfiltered);
        return new PackageTally(map, referencedPkgs);
    }

    public static PackageTally combine(Collection<PackageTally> packageTallies) {
        HashMap<String, Optional<ExportPackageAnnotation>> map = new HashMap<String, Optional<ExportPackageAnnotation>>();
        HashSet<String> referencedPkgs = new HashSet<String>();
        for (PackageTally pt : packageTallies) {
            pt.definedPackagesMap.forEach((k, v) -> map.merge((String)k, (Optional<ExportPackageAnnotation>)v, (l, r) -> l.isPresent() ? l : r));
            referencedPkgs.addAll(pt.referencedPackagesUnfiltered);
        }
        return new PackageTally(map, referencedPkgs);
    }

    public static PackageTally fromAnalyzedClassFiles(Collection<ClassFileMetaData> analyzedClassFiles) {
        HashMap<String, Optional<ExportPackageAnnotation>> map = new HashMap<String, Optional<ExportPackageAnnotation>>();
        HashSet<String> referencedPkgs = new HashSet<String>();
        for (ClassFileMetaData metaData : analyzedClassFiles) {
            String packageName = Packages.packageName(metaData.getName());
            map.merge(packageName, metaData.getExportPackage(), (l, r) -> l.isPresent() ? l : r);
            metaData.getReferencedClasses().forEach(className -> referencedPkgs.add(Packages.packageName(className)));
        }
        return new PackageTally(map, referencedPkgs);
    }
}

