/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.google.common.collect.Sets;
import com.yahoo.container.plugin.bundle.AnalyzeBundle;
import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.PackageTally;
import com.yahoo.container.plugin.classanalysis.Packages;
import com.yahoo.container.plugin.mojo.AbstractGenerateOsgiManifestMojo;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.osgi.ImportPackages;
import com.yahoo.container.plugin.util.ArtifactId;
import com.yahoo.container.plugin.util.Artifacts;
import com.yahoo.container.plugin.util.Files;
import com.yahoo.container.plugin.util.JarFiles;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-osgi-manifest", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateOsgiManifestMojo
extends AbstractGenerateOsgiManifestMojo {
    @Parameter
    private String discApplicationClass = null;
    @Parameter
    private String discPreInstallBundle = null;
    @Parameter(alias="Bundle-Activator")
    private String bundleActivator = null;
    @Parameter(alias="X-JDisc-Privileged-Activator")
    private String jdiscPrivilegedActivator = null;
    @Parameter(alias="WebInfUrl")
    private String webInfUrl = null;
    @Parameter(alias="Main-Class")
    private String mainClass = null;
    @Parameter(alias="Bundle-Type")
    private BundleType bundleType = BundleType.USER;
    @Parameter(defaultValue="false")
    private boolean suppressWarningMissingImportPackages;
    @Parameter(defaultValue="false")
    private boolean suppressWarningPublicApi;
    @Parameter(defaultValue="false")
    private boolean suppressWarningOverlappingPackages;
    @Parameter
    private List<String> allowEmbeddedArtifacts = List.of();
    @Parameter(defaultValue="false")
    private boolean failOnWarnings;
    @Parameter(defaultValue="false")
    private boolean buildLegacyVespaPlatformBundle;

    public void execute() throws MojoExecutionException {
        try {
            if (this.discPreInstallBundle != null && !this.buildLegacyVespaPlatformBundle) {
                throw new MojoExecutionException("The 'discPreInstallBundle' parameter can only be used by legacy Vespa platform bundles.");
            }
            Artifacts.ArtifactSet artifactSet = Artifacts.getArtifacts(this.project);
            this.warnOnUnsupportedArtifacts(artifactSet.getNonJarArtifacts());
            List<Artifact> artifactsToInclude = artifactSet.getJarArtifactsToInclude();
            if (!this.isContainerDiscArtifact(this.project.getArtifact())) {
                this.throwIfInternalContainerArtifactsAreIncluded(artifactsToInclude);
            }
            List<Artifact> providedJarArtifacts = artifactSet.getJarArtifactsProvided();
            List<File> providedJarFiles = providedJarArtifacts.stream().map(Artifact::getFile).toList();
            List<ExportPackages.Export> exportedPackagesFromProvidedJars = AnalyzeBundle.exportedPackagesAggregated(providedJarFiles);
            List<String> nonPublicApiPackagesFromProvidedJars = AnalyzeBundle.nonPublicApiPackagesAggregated(providedJarFiles);
            Set<String> exportedPackagesFromProvidedDeps = ExportPackages.packageNames(exportedPackagesFromProvidedJars);
            PackageTally projectPackages = this.getProjectClassesTally();
            PackageTally compileJarsPackages = this.definedPackages(artifactsToInclude);
            PackageTally includedPackages = projectPackages.combine(compileJarsPackages);
            this.logDebugPackageSets(exportedPackagesFromProvidedJars, includedPackages);
            Optional<Artifact> jdisc_core = Artifacts.getVespaArtifact("jdisc_core", providedJarArtifacts);
            Optional<Artifact> wantedProvidedArtifact = Artifacts.getVespaArtifact(this.wantedProvidedDependency(), providedJarArtifacts);
            if (wantedProvidedArtifact.isPresent()) {
                this.logMissingPackages(exportedPackagesFromProvidedDeps, projectPackages, compileJarsPackages, includedPackages);
                this.logProvidedArtifactsIncluded(artifactsToInclude, JarFiles.providedArtifactsFromManifest(wantedProvidedArtifact.get().getFile()));
            } else if (!this.suppressWarningMissingImportPackages && jdisc_core.isEmpty()) {
                this.warnOrThrow("This project does not have '%s' as provided dependency, so the generated 'Import-Package' OSGi header may be missing important packages.".formatted(this.wantedProvidedDependency()));
            }
            this.logOverlappingPackages(projectPackages, exportedPackagesFromProvidedDeps);
            Map<String, ExportPackages.Export> exportedPackagesByName = ExportPackages.exportsByPackageName(exportedPackagesFromProvidedJars);
            Map<String, ImportPackages.Import> importsForProjectPackages = ImportPackages.calculateImports(projectPackages.referencedPackages(), includedPackages.definedPackages(), exportedPackagesByName);
            List<String> nonPublicApiUsed = Packages.disallowedImports(importsForProjectPackages, nonPublicApiPackagesFromProvidedJars);
            this.logNonPublicApiUsage(nonPublicApiUsed);
            Map<String, ImportPackages.Import> importsForIncludedPackages = ImportPackages.calculateImports(includedPackages.referencedPackages(), includedPackages.definedPackages(), exportedPackagesByName);
            Map<String, String> manifestContent = this.generateManifestContent(artifactsToInclude, importsForIncludedPackages, includedPackages);
            this.addAdditionalManifestProperties(manifestContent);
            this.addManifestPropertiesForInternalAndCoreBundles(manifestContent, includedPackages, providedJarArtifacts);
            this.addManifestPropertiesForUserBundles(manifestContent, providedJarArtifacts, nonPublicApiUsed);
            GenerateOsgiManifestMojo.createManifestFile(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]), manifestContent);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed generating osgi manifest", e);
        }
    }

    private String wantedProvidedDependency() {
        return switch (this.effectiveBundleType()) {
            default -> throw new IncompatibleClassChangeError();
            case BundleType.CORE -> "jdisc_core";
            case BundleType.INTERNAL -> "container-dev";
            case BundleType.USER -> "container";
        };
    }

    private void addAdditionalManifestProperties(Map<String, String> manifestContent) {
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "Bundle-Activator", this.bundleActivator);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Privileged-Activator", this.jdiscPrivilegedActivator);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "Main-Class", this.mainClass);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Application", this.discApplicationClass);
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Preinstall-Bundle", GenerateOsgiManifestMojo.trimWhitespace(Optional.ofNullable(this.discPreInstallBundle)));
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "WebInfUrl", this.webInfUrl);
    }

    private void addManifestPropertiesForInternalAndCoreBundles(Map<String, String> manifestContent, PackageTally includedPackages, List<Artifact> providedJarArtifacts) {
        if (this.effectiveBundleType() == BundleType.USER) {
            return;
        }
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-PublicApi-Package", GenerateOsgiManifestMojo.publicApi(includedPackages));
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Non-PublicApi-Export-Package", GenerateOsgiManifestMojo.nonPublicApi(includedPackages));
    }

    private void addManifestPropertiesForUserBundles(Map<String, String> manifestContent, List<Artifact> providedArtifacts, List<String> nonPublicApiUsed) {
        if (this.effectiveBundleType() != BundleType.USER) {
            return;
        }
        Optional<Artifact> jdisc_core = Artifacts.getVespaArtifact("jdisc_core", providedArtifacts);
        jdisc_core.ifPresent(artifact -> GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Vespa-Build-Version", artifact.getVersion()));
        GenerateOsgiManifestMojo.addIfNotEmpty(manifestContent, "X-JDisc-Non-PublicApi-Import-Package", String.join((CharSequence)",", nonPublicApiUsed));
    }

    private void logNonPublicApiUsage(List<String> nonPublicApiUsed) {
        if (this.suppressWarningPublicApi || this.effectiveBundleType() != BundleType.USER || nonPublicApiUsed.isEmpty()) {
            return;
        }
        this.warnOrThrow("This project uses packages that are not part of Vespa's public api: %s".formatted(nonPublicApiUsed));
    }

    private static String publicApi(PackageTally tally) {
        return tally.publicApiPackages().stream().sorted().collect(Collectors.joining(","));
    }

    private static String nonPublicApi(PackageTally tally) {
        return tally.nonPublicApiExportedPackages().stream().sorted().collect(Collectors.joining(","));
    }

    private void logDebugPackageSets(List<ExportPackages.Export> exportedPackagesFromProvidedJars, PackageTally includedPackages) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Referenced packages = " + includedPackages.referencedPackages()));
            this.getLog().debug((CharSequence)("Defined packages = " + includedPackages.definedPackages()));
            this.getLog().debug((CharSequence)("Exported packages of dependencies = " + exportedPackagesFromProvidedJars.stream().map(e -> "(" + e.getPackageNames().toString() + ", " + e.version().orElse("")).collect(Collectors.joining(", "))));
        }
    }

    private void logMissingPackages(Set<String> exportedPackagesFromProvidedJars, PackageTally projectPackages, PackageTally compileJarPackages, PackageTally includedPackages) {
        Set<String> missingCompilePackages;
        Sets.SetView definedAndExportedPackages = Sets.union(includedPackages.definedPackages(), exportedPackagesFromProvidedJars);
        Set<String> missingProjectPackages = projectPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages);
        if (!missingProjectPackages.isEmpty()) {
            this.getLog().warn((CharSequence)("Packages unavailable runtime are referenced from project classes (annotations can usually be ignored): " + missingProjectPackages));
        }
        if (!(missingCompilePackages = compileJarPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages)).isEmpty()) {
            this.getLog().info((CharSequence)("Packages unavailable runtime are referenced from compile scoped jars (annotations can usually be ignored): " + missingCompilePackages));
        }
    }

    private void logOverlappingPackages(PackageTally projectPackages, Set<String> exportedPackagesFromProvidedDeps) {
        if (this.suppressWarningOverlappingPackages) {
            return;
        }
        Sets.SetView overlappingProjectPackages = Sets.intersection(projectPackages.definedPackages(), exportedPackagesFromProvidedDeps);
        if (!overlappingProjectPackages.isEmpty()) {
            this.warnOrThrow("This project defines packages that are also defined in provided scoped dependencies (overlapping packages are strongly discouraged): " + (Set)overlappingProjectPackages);
        }
    }

    private void logProvidedArtifactsIncluded(List<Artifact> includedArtifacts, List<ArtifactId> providedArtifacts) throws MojoExecutionException {
        if (this.effectiveBundleType() == BundleType.CORE) {
            return;
        }
        Set included = includedArtifacts.stream().map(ArtifactId::fromArtifact).collect(Collectors.toSet());
        this.getLog().debug((CharSequence)("Included  artifacts: " + included));
        this.getLog().debug((CharSequence)("Provided  artifacts: " + providedArtifacts));
        Sets.SetView includedProvided = Sets.intersection(included, new HashSet<ArtifactId>(providedArtifacts));
        this.getLog().debug((CharSequence)("Included provided artifacts: " + (Set)includedProvided));
        HashSet<ArtifactId> allowed = this.getAllowedEmbeddedArtifacts((Set<ArtifactId>)includedProvided);
        List<String> violations = includedProvided.stream().filter(a -> !allowed.contains(a)).map(ArtifactId::stringValue).sorted().toList();
        if (!violations.isEmpty()) {
            this.warnOrThrow("Artifacts provided from Vespa runtime are included in compile scope: " + violations + ". Direct dependencies should be removed. For transitive dependencies, run 'mvn dependency:tree' and add necessary exclusions.");
        }
    }

    private HashSet<ArtifactId> getAllowedEmbeddedArtifacts(Set<ArtifactId> providedIncluded) throws MojoExecutionException {
        if (this.allowEmbeddedArtifacts.isEmpty()) {
            return new HashSet<ArtifactId>();
        }
        HashSet<ArtifactId> allowed = new HashSet<ArtifactId>();
        try {
            this.allowEmbeddedArtifacts.stream().map(ArtifactId::fromStringValue).forEach(allowed::add);
        }
        catch (Exception e) {
            throw new MojoExecutionException("In config parameter 'allowEmbeddedArtifacts': " + e.getMessage(), e);
        }
        Sets.SetView allowedButUnused = Sets.difference(allowed, providedIncluded);
        if (!allowedButUnused.isEmpty()) {
            this.warnOrThrow("Configuration parameter 'allowEmbeddedArtifacts' contains artifact(s) not used in project: " + allowedButUnused);
        }
        this.getLog().info((CharSequence)("Ignoring artifacts embedded in bundle: " + allowed));
        return allowed;
    }

    private static String trimWhitespace(Optional<String> lines) {
        return Stream.of(lines.orElse("").split(",")).map(String::trim).collect(Collectors.joining(","));
    }

    private void warnOnUnsupportedArtifacts(Collection<Artifact> nonJarArtifacts) {
        List<Artifact> unsupportedArtifacts = nonJarArtifacts.stream().filter(a -> !a.getType().equals("pom")).toList();
        unsupportedArtifacts.forEach(artifact -> this.warnOrThrow(String.format("Unsupported artifact '%s': Type '%s' is not supported. Please file a feature request.", artifact.getId(), artifact.getType())));
    }

    private void throwIfInternalContainerArtifactsAreIncluded(Collection<Artifact> includedArtifacts) throws MojoExecutionException {
        if (includedArtifacts.stream().anyMatch(this::isJdiscComponentArtifact)) {
            throw new MojoExecutionException("This project includes the 'com.yahoo.vespa:component' artifact in compile scope. It must have scope 'provided' to avoid resource leaks in your application at runtime. Please use 'mvn dependency:tree' to find the root cause.");
        }
    }

    private BundleType effectiveBundleType() {
        if (this.bundleType != BundleType.USER) {
            return this.bundleType;
        }
        return this.isVespaInternalGroupId(this.project.getGroupId()) ? BundleType.INTERNAL : BundleType.USER;
    }

    private boolean isVespaInternalGroupId(String groupId) {
        return groupId.equals("com.yahoo.vespa") || groupId.equals("com.yahoo.vespa.hosted") || groupId.equals("com.yahoo.vespa.hosted.controller");
    }

    private boolean isJdiscComponentArtifact(Artifact a) {
        return a.getArtifactId().equals("component") && a.getGroupId().equals("com.yahoo.vespa");
    }

    private boolean isContainerDiscArtifact(Artifact a) {
        return a.getArtifactId().equals("container-disc") && a.getGroupId().equals("com.yahoo.vespa");
    }

    private PackageTally getProjectClassesTally() {
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        List<ClassFileMetaData> analyzedClasses = Files.allDescendantFiles(outputDirectory).filter(file -> file.getName().endsWith(".class")).map(classFile -> Analyze.analyzeClass(classFile, this.artifactVersionOrNull(this.bundleVersion))).toList();
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }

    private void warnOrThrow(String ... messages) {
        String message = String.join((CharSequence)"\n", messages);
        if (this.failOnWarnings) {
            throw new RuntimeException(message);
        }
        this.getLog().warn((CharSequence)message);
    }

    private static enum BundleType {
        CORE,
        INTERNAL,
        USER;

    }
}

