/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.classanalysis;

import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.osgi.ImportPackages;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Packages {
    public static String packageName(String fullClassName) {
        int index = fullClassName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fullClassName.substring(0, index);
    }

    public static List<String> disallowedVespaImports(Map<String, ImportPackages.Import> imports, List<String> allowed) {
        if (imports == null || imports.isEmpty()) {
            return List.of();
        }
        HashSet<String> publicApi = allowed == null ? Set.of() : new HashSet<String>(allowed);
        Set yahooImports = imports.keySet().stream().filter(pkg -> pkg.startsWith("com.yahoo") || pkg.startsWith("ai.vespa.")).collect(Collectors.toSet());
        List<String> disallowedImports = yahooImports.stream().collect(Collectors.groupingBy(publicApi::contains)).get(false);
        return disallowedImports == null ? List.of() : disallowedImports;
    }

    public static PackageMetaData analyzePackages(Set<ClassFileMetaData> allClasses) {
        HashSet<String> definedPackages = new HashSet<String>();
        HashSet<String> referencedPackages = new HashSet<String>();
        for (ClassFileMetaData metaData : allClasses) {
            definedPackages.add(Packages.packageName(metaData.getName()));
            metaData.getReferencedClasses().forEach(className -> referencedPackages.add(Packages.packageName(className)));
        }
        referencedPackages.removeAll(definedPackages);
        return new PackageMetaData(definedPackages, referencedPackages);
    }

    public static class PackageMetaData {
        public final Set<String> definedPackages;
        public final Set<String> referencedExternalPackages;

        public PackageMetaData(Set<String> definedPackages, Set<String> referencedExternalPackages) {
            this.definedPackages = definedPackages;
            this.referencedExternalPackages = referencedExternalPackages;
        }
    }
}

