/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.yahoo.container.plugin.bundle.AnalyzeBundle;
import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.PackageTally;
import com.yahoo.container.plugin.mojo.AbstractGenerateOsgiManifestMojo;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.osgi.ImportPackages;
import com.yahoo.container.plugin.util.Artifacts;
import com.yahoo.container.plugin.util.Files;
import com.yahoo.container.plugin.util.TestBundleDependencyScopeTranslator;
import com.yahoo.container.plugin.util.TestBundleUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-test-bundle-osgi-manifest", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateTestBundleOsgiManifestMojo
extends AbstractGenerateOsgiManifestMojo {
    @Parameter
    private String testBundleScopeOverrides;

    public void execute() throws MojoExecutionException {
        try {
            Artifacts.ArtifactSet artifactSet = Artifacts.getArtifacts(this.project, TestBundleDependencyScopeTranslator.from(this.project.getArtifactMap(), this.testBundleScopeOverrides));
            List<File> providedJars = artifactSet.getJarArtifactsProvided().stream().map(Artifact::getFile).collect(Collectors.toList());
            List<ExportPackages.Export> exportedPackagesFromProvidedJars = AnalyzeBundle.exportedPackagesAggregated(providedJars);
            PackageTally projectPackages = this.getProjectMainAndTestClassesTally();
            PackageTally jarArtifactsToInclude = this.definedPackages(artifactSet.getJarArtifactsToInclude());
            PackageTally includedPackages = projectPackages.combine(jarArtifactsToInclude);
            Map<String, ImportPackages.Import> calculatedImports = ImportPackages.calculateImports(includedPackages.referencedPackages(), includedPackages.definedPackages(), ExportPackages.exportsByPackageName(exportedPackagesFromProvidedJars));
            Map<String, String> manifestContent = this.generateManifestContent(artifactSet.getJarArtifactsToInclude(), calculatedImports, includedPackages);
            this.addAdditionalManifestProperties(manifestContent);
            GenerateTestBundleOsgiManifestMojo.createManifestFile(TestBundleUtils.outputDirectory(this.project), manifestContent);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed generating osgi manifest", e);
        }
    }

    private void addAdditionalManifestProperties(Map<String, String> manifestContent) {
        manifestContent.put("X-JDisc-Test-Bundle-Version", "1.0");
    }

    private PackageTally getProjectMainAndTestClassesTally() {
        List<ClassFileMetaData> analyzedClasses = Stream.concat(Files.allDescendantFiles(new File(this.project.getBuild().getOutputDirectory())), Files.allDescendantFiles(new File(this.project.getBuild().getTestOutputDirectory()))).filter(file -> file.getName().endsWith(".class")).map(classFile -> Analyze.analyzeClass(classFile, null)).collect(Collectors.toList());
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }
}

