/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.osgi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;

public class ProjectBundleClassPaths {
    public static final String CLASSPATH_MAPPINGS_FILENAME = "bundle-plugin.bundle-classpath-mappings.json";
    private static final ObjectMapper mapper = new ObjectMapper();
    @JsonProperty(value="mainBundle")
    public final BundleClasspathMapping mainBundle;
    @JsonProperty(value="providedDependencies")
    public final List<BundleClasspathMapping> providedDependencies;

    @JsonCreator
    public ProjectBundleClassPaths(@JsonProperty(value="mainBundle") BundleClasspathMapping mainBundle, @JsonProperty(value="providedDependencies") List<BundleClasspathMapping> providedDependencies) {
        this.mainBundle = mainBundle;
        this.providedDependencies = providedDependencies;
    }

    public static void save(Path path, ProjectBundleClassPaths mappings) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        mapper.writeValue(path.toFile(), (Object)mappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectBundleClassPaths that = (ProjectBundleClassPaths)o;
        return Objects.equals(this.mainBundle, that.mainBundle) && Objects.equals(this.providedDependencies, that.providedDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.mainBundle, this.providedDependencies);
    }

    public static class BundleClasspathMapping {
        @JsonProperty(value="bundleSymbolicName")
        public final String bundleSymbolicName;
        @JsonProperty(value="classPathElements")
        public final List<String> classPathElements;

        @JsonCreator
        public BundleClasspathMapping(@JsonProperty(value="bundleSymbolicName") String bundleSymbolicName, @JsonProperty(value="classPathElements") List<String> classPathElements) {
            this.bundleSymbolicName = bundleSymbolicName;
            this.classPathElements = classPathElements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BundleClasspathMapping that = (BundleClasspathMapping)o;
            return Objects.equals(this.bundleSymbolicName, that.bundleSymbolicName) && Objects.equals(this.classPathElements, that.classPathElements);
        }

        public int hashCode() {
            return Objects.hash(this.bundleSymbolicName, this.classPathElements);
        }
    }
}

