/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.google.common.collect.Sets;
import com.yahoo.container.plugin.bundle.AnalyzeBundle;
import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.ExportPackageAnnotation;
import com.yahoo.container.plugin.classanalysis.PackageTally;
import com.yahoo.container.plugin.mojo.Artifacts;
import com.yahoo.container.plugin.osgi.ExportPackageParser;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.osgi.ImportPackages;
import com.yahoo.container.plugin.util.Files;
import com.yahoo.container.plugin.util.IO;
import com.yahoo.container.plugin.util.Strings;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-osgi-manifest", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateOsgiManifestMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project = null;
    @Parameter(alias="UseArtifactVersionForExportPackages", defaultValue="false")
    private boolean useArtifactVersionForExportPackages;
    @Parameter
    private String discApplicationClass = null;
    @Parameter
    private String discPreInstallBundle = null;
    @Parameter(alias="Bundle-Version", defaultValue="${project.version}")
    private String bundleVersion = null;
    @Parameter(alias="Bundle-SymbolicName", defaultValue="${project.artifactId}")
    private String bundleSymbolicName = null;
    @Parameter(alias="Bundle-Activator")
    private String bundleActivator = null;
    @Parameter(alias="X-JDisc-Privileged-Activator")
    private String jdiscPrivilegedActivator = null;
    @Parameter(alias="Import-Package")
    private String importPackage = null;
    @Parameter(alias="WebInfUrl")
    private String webInfUrl = null;
    @Parameter(alias="Main-Class")
    private String mainClass = null;

    public void execute() throws MojoExecutionException {
        try {
            Artifacts.ArtifactSet artifactSet = Artifacts.getArtifacts(this.project);
            this.warnOnUnsupportedArtifacts(artifactSet.getNonJarArtifacts());
            List<ExportPackages.Export> exportedPackagesFromProvidedJars = AnalyzeBundle.exportedPackagesAggregated(artifactSet.getJarArtifactsProvided().stream().map(Artifact::getFile).collect(Collectors.toList()));
            Set<String> exportedPackagesFromProvidedDeps = ExportPackages.packageNames(exportedPackagesFromProvidedJars);
            PackageTally projectPackages = this.getProjectClassesTally();
            PackageTally compileJarsPackages = this.definedPackages(artifactSet.getJarArtifactsToInclude());
            PackageTally includedPackages = projectPackages.combine(compileJarsPackages);
            this.logDebugPackageSets(exportedPackagesFromProvidedJars, includedPackages);
            if (this.hasJdiscCoreProvided(artifactSet.getJarArtifactsProvided())) {
                this.logMissingPackages(exportedPackagesFromProvidedDeps, projectPackages, compileJarsPackages, includedPackages);
            } else {
                this.getLog().warn((CharSequence)"This project does not have jdisc_core as provided dependency, so the generated 'Import-Package' OSGi header may be missing important packages.");
            }
            this.logOverlappingPackages(projectPackages, exportedPackagesFromProvidedDeps);
            this.logUnnecessaryPackages(compileJarsPackages, exportedPackagesFromProvidedDeps);
            Map<String, ImportPackages.Import> calculatedImports = ImportPackages.calculateImports(includedPackages.referencedPackages(), includedPackages.definedPackages(), ExportPackages.exportsByPackageName(exportedPackagesFromProvidedJars));
            Map manualImports = GenerateOsgiManifestMojo.emptyToNone(this.importPackage).map(GenerateOsgiManifestMojo::getManualImports).orElseGet(HashMap::new);
            for (String packageName : manualImports.keySet()) {
                calculatedImports.remove(packageName);
            }
            GenerateOsgiManifestMojo.createManifestFile(new File(this.project.getBuild().getOutputDirectory()), this.manifestContent(this.project, artifactSet.getJarArtifactsToInclude(), manualImports, calculatedImports.values(), includedPackages));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed generating osgi manifest", e);
        }
    }

    private void logDebugPackageSets(List<ExportPackages.Export> exportedPackagesFromProvidedJars, PackageTally includedPackages) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Referenced packages = " + includedPackages.referencedPackages()));
            this.getLog().debug((CharSequence)("Defined packages = " + includedPackages.definedPackages()));
            this.getLog().debug((CharSequence)("Exported packages of dependencies = " + exportedPackagesFromProvidedJars.stream().map(e -> "(" + e.getPackageNames().toString() + ", " + e.version().orElse("")).collect(Collectors.joining(", "))));
        }
    }

    private boolean hasJdiscCoreProvided(List<Artifact> providedArtifacts) {
        return providedArtifacts.stream().anyMatch(artifact -> artifact.getArtifactId().equals("jdisc_core"));
    }

    private void logMissingPackages(Set<String> exportedPackagesFromProvidedJars, PackageTally projectPackages, PackageTally compileJarPackages, PackageTally includedPackages) {
        Set<String> missingCompilePackages;
        Sets.SetView definedAndExportedPackages = Sets.union(includedPackages.definedPackages(), exportedPackagesFromProvidedJars);
        Set<String> missingProjectPackages = projectPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages);
        if (!missingProjectPackages.isEmpty()) {
            this.getLog().warn((CharSequence)("Packages unavailable runtime are referenced from project classes (annotations can usually be ignored): " + missingProjectPackages));
        }
        if (!(missingCompilePackages = compileJarPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages)).isEmpty()) {
            this.getLog().info((CharSequence)("Packages unavailable runtime are referenced from compile scoped jars (annotations can usually be ignored): " + missingCompilePackages));
        }
    }

    private void logOverlappingPackages(PackageTally projectPackages, Set<String> exportedPackagesFromProvidedDeps) {
        Sets.SetView overlappingProjectPackages = Sets.intersection(projectPackages.definedPackages(), exportedPackagesFromProvidedDeps);
        if (!overlappingProjectPackages.isEmpty()) {
            this.getLog().warn((CharSequence)("This project defines packages that are also defined in provided scoped dependencies (overlapping packages are strongly discouraged): " + (Set)overlappingProjectPackages));
        }
    }

    private void logUnnecessaryPackages(PackageTally compileJarsPackages, Set<String> exportedPackagesFromProvidedDeps) {
        Sets.SetView unnecessaryPackages = Sets.intersection(compileJarsPackages.definedPackages(), exportedPackagesFromProvidedDeps);
        if (!unnecessaryPackages.isEmpty()) {
            this.getLog().info((CharSequence)("Compile scoped jars contain the following packages that are most likely available from jdisc runtime: " + (Set)unnecessaryPackages));
        }
    }

    private Collection<String> osgiExportPackages(Map<String, ExportPackageAnnotation> exportedPackages) {
        return exportedPackages.entrySet().stream().map(entry -> (String)entry.getKey() + ";version=" + ((ExportPackageAnnotation)entry.getValue()).osgiVersion()).collect(Collectors.toList());
    }

    private static String trimWhitespace(Optional<String> lines) {
        return Stream.of(lines.orElse("").split(",")).map(String::trim).collect(Collectors.joining(","));
    }

    private Map<String, String> manifestContent(MavenProject project, Collection<Artifact> jarArtifactsToInclude, Map<String, Optional<String>> manualImports, Collection<ImportPackages.Import> imports, PackageTally pluginPackageTally) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String importPackage = Stream.concat(manualImports.entrySet().stream().map(e -> GenerateOsgiManifestMojo.asOsgiImport((String)e.getKey(), (Optional)e.getValue())), imports.stream().map(ImportPackages.Import::asOsgiImport)).sorted().collect(Collectors.joining(","));
        String exportPackage = this.osgiExportPackages(pluginPackageTally.exportedPackages()).stream().sorted().collect(Collectors.joining(","));
        ret.put("Created-By", "vespa container maven plugin");
        ret.put("Bundle-ManifestVersion", "2");
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Bundle-Name", project.getName());
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Bundle-SymbolicName", this.bundleSymbolicName);
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Bundle-Version", GenerateOsgiManifestMojo.asBundleVersion(this.bundleVersion));
        ret.put("Bundle-Vendor", "Yahoo!");
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Bundle-ClassPath", GenerateOsgiManifestMojo.bundleClassPath(jarArtifactsToInclude));
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Bundle-Activator", this.bundleActivator);
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "X-JDisc-Privileged-Activator", this.jdiscPrivilegedActivator);
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Main-Class", this.mainClass);
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "X-JDisc-Application", this.discApplicationClass);
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "X-JDisc-Preinstall-Bundle", GenerateOsgiManifestMojo.trimWhitespace(Optional.ofNullable(this.discPreInstallBundle)));
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "WebInfUrl", this.webInfUrl);
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Import-Package", importPackage);
        GenerateOsgiManifestMojo.addIfNotEmpty(ret, "Export-Package", exportPackage);
        return ret;
    }

    private static void addIfNotEmpty(Map<String, String> map, String key, String value) {
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    private static String asOsgiImport(String packageName, Optional<String> version) {
        return version.map(s -> packageName + ";version=" + GenerateOsgiManifestMojo.quote(s)).orElse(packageName);
    }

    private static String quote(String s) {
        return "\"" + s + "\"";
    }

    private static void createManifestFile(File outputDirectory, Map<String, String> manifestContent) {
        Manifest manifest = GenerateOsgiManifestMojo.toManifest(manifestContent);
        IO.withFileOutputStream(new File(outputDirectory, "META-INF/MANIFEST.MF"), outputStream -> {
            manifest.write((OutputStream)outputStream);
            return null;
        });
    }

    private static Manifest toManifest(Map<String, String> manifestContent) {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifestContent.forEach(mainAttributes::putValue);
        return manifest;
    }

    private static String bundleClassPath(Collection<Artifact> artifactsToInclude) {
        return Stream.concat(Stream.of("."), artifactsToInclude.stream().map(GenerateOsgiManifestMojo::dependencyPath)).collect(Collectors.joining(","));
    }

    private static String dependencyPath(Artifact artifact) {
        return "dependencies/" + artifact.getFile().getName();
    }

    private static String asBundleVersion(String projectVersion) {
        if (projectVersion == null) {
            throw new IllegalArgumentException("Missing project version.");
        }
        String[] parts = projectVersion.split("-", 2);
        List numericPart = Stream.of(parts[0].split("\\.")).map(s -> Strings.replaceEmptyString(s, "0")).limit(3L).collect(Collectors.toList());
        while (numericPart.size() < 3) {
            numericPart.add("0");
        }
        return String.join((CharSequence)".", numericPart);
    }

    private void warnOnUnsupportedArtifacts(Collection<Artifact> nonJarArtifacts) {
        List<Artifact> unsupportedArtifacts = nonJarArtifacts.stream().filter(a -> !a.getType().equals("pom")).collect(Collectors.toList());
        unsupportedArtifacts.forEach(artifact -> this.getLog().warn((CharSequence)String.format("Unsupported artifact '%s': Type '%s' is not supported. Please file a feature request.", artifact.getId(), artifact.getType())));
    }

    private ArtifactVersion artifactVersionOrNull(String version) {
        return this.useArtifactVersionForExportPackages ? new DefaultArtifactVersion(version) : null;
    }

    private PackageTally getProjectClassesTally() {
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        List<ClassFileMetaData> analyzedClasses = Files.allDescendantFiles(outputDirectory).filter(file -> file.getName().endsWith(".class")).map(classFile -> Analyze.analyzeClass(classFile, this.artifactVersionOrNull(this.bundleVersion))).collect(Collectors.toList());
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }

    private PackageTally definedPackages(Collection<Artifact> jarArtifacts) {
        ArrayList<PackageTally> tallies = new ArrayList<PackageTally>();
        for (Artifact artifact : jarArtifacts) {
            try {
                tallies.add(GenerateOsgiManifestMojo.definedPackages(new JarFile(artifact.getFile()), this.artifactVersionOrNull(artifact.getVersion())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return PackageTally.combine(tallies);
    }

    private static PackageTally definedPackages(JarFile jarFile, ArtifactVersion version) throws MojoExecutionException {
        ArrayList<ClassFileMetaData> analyzedClasses = new ArrayList<ClassFileMetaData>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            analyzedClasses.add(GenerateOsgiManifestMojo.analyzeClass(jarFile, entry, version));
        }
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }

    private static ClassFileMetaData analyzeClass(JarFile jarFile, JarEntry entry, ArtifactVersion version) throws MojoExecutionException {
        try {
            return Analyze.analyzeClass(jarFile.getInputStream(entry), version);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("While analyzing the class '%s' in jar file '%s'", entry.getName(), jarFile.getName()), e);
        }
    }

    private static Map<String, Optional<String>> getManualImports(String importPackage) {
        try {
            HashMap<String, Optional<String>> ret = new HashMap<String, Optional<String>>();
            List<ExportPackages.Export> imports = GenerateOsgiManifestMojo.parseImportPackages(importPackage);
            for (ExportPackages.Export imp : imports) {
                Optional<String> version = GenerateOsgiManifestMojo.getVersionThrowOthers(imp.getParameters());
                imp.getPackageNames().forEach(pn -> ret.put((String)pn, version));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in Import-Package:" + importPackage, e);
        }
    }

    private static Optional<String> getVersionThrowOthers(List<ExportPackages.Parameter> parameters) {
        if (parameters.size() == 1 && "version".equals(parameters.get(0).getName())) {
            return Optional.of(parameters.get(0).getValue());
        }
        if (parameters.size() == 0) {
            return Optional.empty();
        }
        List paramNames = parameters.stream().map(ExportPackages.Parameter::getName).collect(Collectors.toList());
        throw new RuntimeException("A single, optional version parameter expected, but got " + paramNames);
    }

    private static List<ExportPackages.Export> parseImportPackages(String importPackages) {
        return ExportPackageParser.parseExports(importPackages);
    }

    private static Optional<String> emptyToNone(String str) {
        return Optional.ofNullable(str).map(String::trim).filter(s -> !s.isEmpty());
    }
}

