/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.google.common.collect.Sets;
import com.yahoo.container.plugin.bundle.AnalyzeBundle;
import com.yahoo.container.plugin.classanalysis.Analyze;
import com.yahoo.container.plugin.classanalysis.ClassFileMetaData;
import com.yahoo.container.plugin.classanalysis.ExportPackageAnnotation;
import com.yahoo.container.plugin.classanalysis.PackageTally;
import com.yahoo.container.plugin.mojo.Artifacts;
import com.yahoo.container.plugin.osgi.ExportPackageParser;
import com.yahoo.container.plugin.osgi.ExportPackages;
import com.yahoo.container.plugin.osgi.ImportPackages;
import com.yahoo.container.plugin.util.Files;
import com.yahoo.container.plugin.util.IO;
import com.yahoo.container.plugin.util.JarFiles;
import com.yahoo.container.plugin.util.Strings;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-osgi-manifest", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class GenerateOsgiManifestMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project = null;
    @Parameter
    private String discApplicationClass = null;
    @Parameter
    private String discPreInstallBundle = null;
    @Parameter(alias="Bundle-Version", defaultValue="${project.version}")
    private String bundleVersion = null;
    @Parameter(alias="Bundle-SymbolicName", defaultValue="${project.artifactId}")
    private String bundleSymbolicName = null;
    @Parameter(alias="Bundle-Activator")
    private String bundleActivator = null;
    @Parameter(alias="X-JDisc-Privileged-Activator")
    private String jdiscPrivilegedActivator = null;
    @Parameter(alias="Import-Package")
    private String importPackage = null;
    @Parameter(alias="WebInfUrl")
    private String webInfUrl = null;
    @Parameter(alias="Main-Class")
    private String mainClass = null;

    public void execute() throws MojoExecutionException {
        try {
            Artifacts.ArtifactSet artifactSet = Artifacts.getArtifacts(this.project);
            this.warnOnUnsupportedArtifacts(artifactSet.getNonJarArtifacts());
            AnalyzeBundle.PublicPackages publicPackagesFromProvidedJars = AnalyzeBundle.publicPackagesAggregated(artifactSet.getJarArtifactsProvided().stream().map(Artifact::getFile).collect(Collectors.toList()));
            Set<String> exportedPackagesFromProvidedDeps = publicPackagesFromProvidedJars.exportedPackageNames();
            PackageTally projectPackages = this.getProjectClassesTally();
            PackageTally compileJarsPackages = GenerateOsgiManifestMojo.definedPackages(artifactSet.getJarArtifactsToInclude());
            PackageTally includedPackages = projectPackages.combine(compileJarsPackages);
            GenerateOsgiManifestMojo.warnIfPackagesDefinedOverlapsGlobalPackages(includedPackages.definedPackages(), publicPackagesFromProvidedJars.globals);
            this.logDebugPackageSets(publicPackagesFromProvidedJars, includedPackages);
            if (this.hasJdiscCoreProvided(artifactSet.getJarArtifactsProvided())) {
                this.logMissingPackages(exportedPackagesFromProvidedDeps, projectPackages, compileJarsPackages, includedPackages);
            } else {
                this.getLog().warn((CharSequence)"This project does not have jdisc_core as provided dependency, so the generated 'Import-Package' OSGi header may be missing important packages.");
            }
            this.logOverlappingPackages(projectPackages, exportedPackagesFromProvidedDeps);
            this.logUnnecessaryPackages(compileJarsPackages, exportedPackagesFromProvidedDeps);
            Map<String, ImportPackages.Import> calculatedImports = ImportPackages.calculateImports(includedPackages.referencedPackages(), includedPackages.definedPackages(), ExportPackages.exportsByPackageName(publicPackagesFromProvidedJars.exports));
            Map manualImports = GenerateOsgiManifestMojo.emptyToNone(this.importPackage).map(GenerateOsgiManifestMojo::getManualImports).orElseGet(HashMap::new);
            for (String packageName : manualImports.keySet()) {
                calculatedImports.remove(packageName);
            }
            GenerateOsgiManifestMojo.createManifestFile(new File(this.project.getBuild().getOutputDirectory()), this.manifestContent(this.project, artifactSet.getJarArtifactsToInclude(), manualImports, calculatedImports.values(), includedPackages));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed generating osgi manifest", e);
        }
    }

    private void logDebugPackageSets(AnalyzeBundle.PublicPackages publicPackagesFromProvidedJars, PackageTally includedPackages) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Referenced packages = " + includedPackages.referencedPackages()));
            this.getLog().debug((CharSequence)("Defined packages = " + includedPackages.definedPackages()));
            this.getLog().debug((CharSequence)("Exported packages of dependencies = " + publicPackagesFromProvidedJars.exports.stream().map(e -> "(" + e.getPackageNames().toString() + ", " + e.version().orElse("")).collect(Collectors.joining(", "))));
        }
    }

    private boolean hasJdiscCoreProvided(List<Artifact> providedArtifacts) {
        return providedArtifacts.stream().anyMatch(artifact -> artifact.getArtifactId().equals("jdisc_core"));
    }

    private void logMissingPackages(Set<String> exportedPackagesFromProvidedJars, PackageTally projectPackages, PackageTally compileJarPackages, PackageTally includedPackages) {
        Set<String> missingCompilePackages;
        Sets.SetView definedAndExportedPackages = Sets.union(includedPackages.definedPackages(), exportedPackagesFromProvidedJars);
        Set<String> missingProjectPackages = projectPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages);
        if (!missingProjectPackages.isEmpty()) {
            this.getLog().warn((CharSequence)("Packages unavailable runtime are referenced from project classes (annotations can usually be ignored): " + missingProjectPackages));
        }
        if (!(missingCompilePackages = compileJarPackages.referencedPackagesMissingFrom((Set<String>)definedAndExportedPackages)).isEmpty()) {
            this.getLog().info((CharSequence)("Packages unavailable runtime are referenced from compile scoped jars (annotations can usually be ignored): " + missingCompilePackages));
        }
    }

    private void logOverlappingPackages(PackageTally projectPackages, Set<String> exportedPackagesFromProvidedDeps) {
        Sets.SetView overlappingProjectPackages = Sets.intersection(projectPackages.definedPackages(), exportedPackagesFromProvidedDeps);
        if (!overlappingProjectPackages.isEmpty()) {
            this.getLog().warn((CharSequence)("This project defines packages that are also defined in provided scoped dependencies (overlapping packages are strongly discouraged): " + (Set)overlappingProjectPackages));
        }
    }

    private void logUnnecessaryPackages(PackageTally compileJarsPackages, Set<String> exportedPackagesFromProvidedDeps) {
        Sets.SetView unnecessaryPackages = Sets.intersection(compileJarsPackages.definedPackages(), exportedPackagesFromProvidedDeps);
        if (!unnecessaryPackages.isEmpty()) {
            this.getLog().info((CharSequence)("Compile scoped jars contain the following packages that are most likely available from jdisc runtime: " + (Set)unnecessaryPackages));
        }
    }

    private static void warnIfPackagesDefinedOverlapsGlobalPackages(Set<String> internalPackages, List<String> globalPackages) throws MojoExecutionException {
        Sets.SetView overlap = Sets.intersection(internalPackages, new HashSet<String>(globalPackages));
        if (!overlap.isEmpty()) {
            throw new MojoExecutionException("The following packages are both global and included in the bundle:\n   " + String.join((CharSequence)"\n   ", (Iterable<? extends CharSequence>)overlap));
        }
    }

    private Collection<String> osgiExportPackages(Map<String, ExportPackageAnnotation> exportedPackages) {
        return exportedPackages.entrySet().stream().map(entry -> (String)entry.getKey() + ";version=" + ((ExportPackageAnnotation)entry.getValue()).osgiVersion()).collect(Collectors.toList());
    }

    private static String trimWhitespace(Optional<String> lines) {
        return Stream.of(lines.orElse("").split(",")).map(String::trim).collect(Collectors.joining(","));
    }

    private Map<String, String> manifestContent(MavenProject project, Collection<Artifact> jarArtifactsToInclude, Map<String, Optional<String>> manualImports, Collection<ImportPackages.Import> imports, PackageTally pluginPackageTally) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String importPackage = Stream.concat(manualImports.entrySet().stream().map(e -> GenerateOsgiManifestMojo.asOsgiImport((String)e.getKey(), (Optional)e.getValue())), imports.stream().map(ImportPackages.Import::asOsgiImport)).sorted().collect(Collectors.joining(","));
        String exportPackage = this.osgiExportPackages(pluginPackageTally.exportedPackages()).stream().sorted().collect(Collectors.joining(","));
        for (Pair element : Arrays.asList(Pair.of((Object)"Created-By", (Object)"vespa container maven plugin"), Pair.of((Object)"Bundle-ManifestVersion", (Object)"2"), Pair.of((Object)"Bundle-Name", (Object)project.getName()), Pair.of((Object)"Bundle-SymbolicName", (Object)this.bundleSymbolicName), Pair.of((Object)"Bundle-Version", (Object)GenerateOsgiManifestMojo.asBundleVersion(this.bundleVersion)), Pair.of((Object)"Bundle-Vendor", (Object)"Yahoo!"), Pair.of((Object)"Bundle-ClassPath", (Object)GenerateOsgiManifestMojo.bundleClassPath(jarArtifactsToInclude)), Pair.of((Object)"Bundle-Activator", (Object)this.bundleActivator), Pair.of((Object)"X-JDisc-Privileged-Activator", (Object)this.jdiscPrivilegedActivator), Pair.of((Object)"Main-Class", (Object)this.mainClass), Pair.of((Object)"X-JDisc-Application", (Object)this.discApplicationClass), Pair.of((Object)"X-JDisc-Preinstall-Bundle", (Object)GenerateOsgiManifestMojo.trimWhitespace(Optional.ofNullable(this.discPreInstallBundle))), Pair.of((Object)"WebInfUrl", (Object)this.webInfUrl), Pair.of((Object)"Import-Package", (Object)importPackage), Pair.of((Object)"Export-Package", (Object)exportPackage))) {
            if (element.getValue() == null || ((String)element.getValue()).isEmpty()) continue;
            ret.put((String)element.getKey(), (String)element.getValue());
        }
        return ret;
    }

    private static String asOsgiImport(String packageName, Optional<String> version) {
        return version.map(s -> packageName + ";version=" + GenerateOsgiManifestMojo.quote(s)).orElse(packageName);
    }

    private static String quote(String s) {
        return "\"" + s + "\"";
    }

    private static void createManifestFile(File outputDirectory, Map<String, String> manifestContent) {
        Manifest manifest = GenerateOsgiManifestMojo.toManifest(manifestContent);
        IO.withFileOutputStream(new File(outputDirectory, "META-INF/MANIFEST.MF"), outputStream -> {
            manifest.write((OutputStream)outputStream);
            return null;
        });
    }

    private static Manifest toManifest(Map<String, String> manifestContent) {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifestContent.forEach(mainAttributes::putValue);
        return manifest;
    }

    private static String bundleClassPath(Collection<Artifact> artifactsToInclude) {
        return Stream.concat(Stream.of("."), artifactsToInclude.stream().map(GenerateOsgiManifestMojo::dependencyPath)).collect(Collectors.joining(","));
    }

    private static String dependencyPath(Artifact artifact) {
        return "dependencies/" + artifact.getFile().getName();
    }

    private static String asBundleVersion(String projectVersion) {
        if (projectVersion == null) {
            throw new IllegalArgumentException("Missing project version.");
        }
        String[] parts = projectVersion.split("-", 2);
        List numericPart = Stream.of(parts[0].split("\\.")).map(s -> Strings.replaceEmptyString(s, "0")).limit(3L).collect(Collectors.toList());
        while (numericPart.size() < 3) {
            numericPart.add("0");
        }
        return String.join((CharSequence)".", numericPart);
    }

    private void warnOnUnsupportedArtifacts(Collection<Artifact> nonJarArtifacts) {
        List<Artifact> unsupportedArtifacts = nonJarArtifacts.stream().filter(a -> !a.getType().equals("pom")).collect(Collectors.toList());
        unsupportedArtifacts.forEach(artifact -> this.getLog().warn((CharSequence)String.format("Unsupported artifact '%s': Type '%s' is not supported. Please file a feature request.", artifact.getId(), artifact.getType())));
    }

    private PackageTally getProjectClassesTally() {
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        List<ClassFileMetaData> analyzedClasses = Files.allDescendantFiles(outputDirectory).filter(file -> file.getName().endsWith(".class")).map(Analyze::analyzeClass).collect(Collectors.toList());
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }

    private static PackageTally definedPackages(Collection<Artifact> jarArtifacts) {
        return PackageTally.combine(jarArtifacts.stream().map(ja -> JarFiles.withJarFile(ja.getFile(), GenerateOsgiManifestMojo::definedPackages)).collect(Collectors.toList()));
    }

    private static PackageTally definedPackages(JarFile jarFile) throws MojoExecutionException {
        ArrayList<ClassFileMetaData> analyzedClasses = new ArrayList<ClassFileMetaData>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            analyzedClasses.add(GenerateOsgiManifestMojo.analyzeClass(jarFile, entry));
        }
        return PackageTally.fromAnalyzedClassFiles(analyzedClasses);
    }

    private static ClassFileMetaData analyzeClass(JarFile jarFile, JarEntry entry) throws MojoExecutionException {
        try {
            return JarFiles.withInputStream(jarFile, entry, Analyze::analyzeClass);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("While analyzing the class '%s' in jar file '%s'", entry.getName(), jarFile.getName()), e);
        }
    }

    private static Map<String, Optional<String>> getManualImports(String importPackage) {
        try {
            HashMap<String, Optional<String>> ret = new HashMap<String, Optional<String>>();
            List<ExportPackages.Export> imports = GenerateOsgiManifestMojo.parseImportPackages(importPackage);
            for (ExportPackages.Export imp : imports) {
                Optional<String> version = GenerateOsgiManifestMojo.getVersionThrowOthers(imp.getParameters());
                imp.getPackageNames().forEach(pn -> ret.put((String)pn, version));
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error in Import-Package:" + importPackage, e);
        }
    }

    private static Optional<String> getVersionThrowOthers(List<ExportPackages.Parameter> parameters) {
        if (parameters.size() == 1 && "version".equals(parameters.get(0).getName())) {
            return Optional.of(parameters.get(0).getValue());
        }
        if (parameters.size() == 0) {
            return Optional.empty();
        }
        List paramNames = parameters.stream().map(ExportPackages.Parameter::getName).collect(Collectors.toList());
        throw new RuntimeException("A single, optional version parameter expected, but got " + paramNames);
    }

    private static List<ExportPackages.Export> parseImportPackages(String importPackages) {
        return ExportPackageParser.parseExports(importPackages);
    }

    private static Optional<String> emptyToNone(String str) {
        return Optional.ofNullable(str).map(String::trim).filter(s -> !s.isEmpty());
    }
}

