/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.plugin.mojo;

import com.yahoo.container.plugin.mojo.Artifacts;
import com.yahoo.container.plugin.util.Files;
import com.yahoo.container.plugin.util.JarFiles;
import java.io.File;
import java.nio.channels.Channels;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="assemble-container-plugin", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class AssembleContainerPluginMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project = null;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session = null;
    @Parameter
    private MavenArchiveConfiguration archiveConfiguration = new MavenArchiveConfiguration();
    @Parameter(alias="UseCommonAssemblyIds", defaultValue="false")
    private boolean useCommonAssemblyIds = false;
    @Parameter(alias="AttachBundle", defaultValue="false")
    private boolean attachBundleToArtifact;
    @Parameter(alias="BundleClassifier", defaultValue="bundle")
    private String bundleClassifierName;

    public void execute() throws MojoExecutionException {
        EnumMap<Dependencies, String> jarSuffixes = new EnumMap<Dependencies, String>(Dependencies.class);
        if (this.useCommonAssemblyIds) {
            jarSuffixes.put(Dependencies.WITHOUT, ".jar");
            jarSuffixes.put(Dependencies.WITH, "-jar-with-dependencies.jar");
        } else {
            jarSuffixes.put(Dependencies.WITHOUT, "-without-dependencies.jar");
            jarSuffixes.put(Dependencies.WITH, "-deploy.jar");
        }
        EnumMap jarFiles = new EnumMap(Dependencies.class);
        jarSuffixes.forEach((dep, suffix) -> jarFiles.put((Dependencies)((Object)dep), this.jarFileInBuildDirectory(this.build().getFinalName(), (String)suffix)));
        this.archiveConfiguration.setForced(true);
        this.archiveConfiguration.setManifestFile(new File(new File(this.build().getOutputDirectory()), "META-INF/MANIFEST.MF"));
        JarArchiver jarWithoutDependencies = new JarArchiver();
        this.addClassesDirectory(jarWithoutDependencies);
        this.createArchive((File)jarFiles.get((Object)Dependencies.WITHOUT), jarWithoutDependencies);
        this.project.getArtifact().setFile((File)jarFiles.get((Object)Dependencies.WITHOUT));
        JarArchiver jarWithDependencies = new JarArchiver();
        this.addClassesDirectory(jarWithDependencies);
        this.addDependencies(jarWithDependencies);
        this.createArchive((File)jarFiles.get((Object)Dependencies.WITH), jarWithDependencies);
        if (this.attachBundleToArtifact) {
            this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.bundleClassifierName, (File)jarFiles.get((Object)Dependencies.WITH));
        }
    }

    private File jarFileInBuildDirectory(String name, String suffix) {
        return new File(this.build().getDirectory(), name + suffix);
    }

    private void addClassesDirectory(JarArchiver jarArchiver) {
        File classesDirectory = new File(this.build().getOutputDirectory());
        if (classesDirectory.isDirectory()) {
            jarArchiver.addDirectory(classesDirectory);
        }
    }

    private void createArchive(File jarFile, JarArchiver jarArchiver) throws MojoExecutionException {
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setArchiver(jarArchiver);
        mavenArchiver.setOutputFile(jarFile);
        try {
            mavenArchiver.createArchive(this.session, this.project, this.archiveConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating archive " + jarFile.getName(), e);
        }
    }

    private void addDependencies(JarArchiver jarArchiver) {
        Artifacts.getArtifactsToInclude(this.project).forEach(artifact -> {
            if ("jar".equals(artifact.getType())) {
                jarArchiver.addFile(artifact.getFile(), "dependencies/" + artifact.getFile().getName());
                this.copyConfigDefinitions(artifact.getFile(), jarArchiver);
            } else {
                this.getLog().warn((CharSequence)("Unkown artifact type " + artifact.getType()));
            }
        });
    }

    private void copyConfigDefinitions(File file, JarArchiver jarArchiver) {
        JarFiles.withJarFile(file, jarFile -> {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("configdefinitions/") || !name.endsWith(".def")) continue;
                this.copyConfigDefinition((JarFile)jarFile, entry, jarArchiver);
            }
            return null;
        });
    }

    private void copyConfigDefinition(JarFile jarFile, ZipEntry entry, JarArchiver jarArchiver) {
        JarFiles.withInputStream(jarFile, entry, input -> {
            String defPath = entry.getName().replace("/", File.separator);
            File destinationFile = new File(this.build().getOutputDirectory(), defPath);
            destinationFile.getParentFile().mkdirs();
            Files.withFileOutputStream(destinationFile, output -> {
                output.getChannel().transferFrom(Channels.newChannel(input), 0L, Long.MAX_VALUE);
                return null;
            });
            jarArchiver.addFile(destinationFile, entry.getName());
            return null;
        });
    }

    private Build build() {
        return this.project.getBuild();
    }

    private static enum Dependencies {
        WITH,
        WITHOUT;

    }
}

