/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container.handler;

import com.yahoo.api.annotations.Beta;
import com.yahoo.application.container.handler.Headers;
import com.yahoo.text.Utf8;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Beta
public class Response {
    private static final Pattern charsetPattern = Pattern.compile("charset=([^\\s\\;]+)", 2);
    private final int status;
    private final Headers headers = new Headers();
    private final byte[] body;

    public Response() {
        this(new byte[0]);
    }

    public Response(byte[] body) {
        this(200, body);
    }

    public Response(int status, byte[] body) {
        this.status = status;
        this.body = body;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() throws CharacterCodingException {
        CharsetDecoder decoder = this.charset().newDecoder();
        return decoder.decode(ByteBuffer.wrap(this.body)).toString();
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String toString() {
        String bodyStr = this.body == null || this.body.length == 0 ? "[empty]" : "[omitted]";
        return "Response, headers: " + String.valueOf(this.headers) + ", body: " + bodyStr;
    }

    private Charset charset() {
        return Response.charset(this.headers.getFirst("Content-Type"));
    }

    static Charset charset(String contentType) {
        Matcher matcher;
        if (contentType != null && (matcher = charsetPattern.matcher(contentType)).find()) {
            try {
                return Charset.forName(matcher.group(1));
            }
            catch (UnsupportedCharsetException uce) {
                return Utf8.getCharset();
            }
        }
        return Utf8.getCharset();
    }
}

