/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application;

import ai.vespa.rankingexpression.importer.lightgbm.LightGBMImporter;
import ai.vespa.rankingexpression.importer.onnx.OnnxImporter;
import ai.vespa.rankingexpression.importer.tensorflow.TensorFlowImporter;
import ai.vespa.rankingexpression.importer.vespa.VespaImporter;
import ai.vespa.rankingexpression.importer.xgboost.XGBoostImporter;
import com.yahoo.api.annotations.Beta;
import com.yahoo.application.Networking;
import com.yahoo.application.container.JDisc;
import com.yahoo.application.container.impl.StandaloneContainerRunner;
import com.yahoo.application.content.ContentCluster;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.ConfigModelRegistry;
import com.yahoo.config.model.NullConfigModelRegistry;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.Container;
import com.yahoo.docproc.DocumentProcessor;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.path.Path;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.config.QueryProfileXMLReader;
import com.yahoo.search.rendering.Renderer;
import com.yahoo.text.StringUtilities;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.xml.sax.SAXException;

@Beta
public final class Application
implements AutoCloseable {
    public static final String vespaLocalProperty = "vespa.local";
    private final JDisc container;
    private final List<ContentCluster> contentClusters;
    private final java.nio.file.Path path;
    private final boolean deletePathWhenClosing;
    private final CompiledQueryProfileRegistry compiledQueryProfileRegistry;

    Application(java.nio.file.Path path, Networking networking, boolean deletePathWhenClosing) {
        System.setProperty(vespaLocalProperty, "true");
        this.path = path;
        this.deletePathWhenClosing = deletePathWhenClosing;
        this.contentClusters = ContentCluster.fromPath(path);
        this.container = JDisc.fromPath(path, networking, this.createVespaModel().configModelRepo());
        this.compiledQueryProfileRegistry = this.readQueryProfilesFromApplicationPackage(path);
    }

    @Beta
    public static Application fromBuilder(Builder builder) throws Exception {
        return builder.build();
    }

    public static Application fromServicesXml(String xml, Networking networking) {
        java.nio.file.Path applicationDir = StandaloneContainerRunner.createApplicationPackage((String)xml);
        return new Application(applicationDir, networking, true);
    }

    public static Application fromApplicationPackage(java.nio.file.Path path, Networking networking) {
        return new Application(path, networking, false);
    }

    public static Application fromApplicationPackage(File file, Networking networking) {
        return Application.fromApplicationPackage(file.toPath(), networking);
    }

    private CompiledQueryProfileRegistry readQueryProfilesFromApplicationPackage(java.nio.file.Path path) {
        String queryProfilePath = path + "/search/query-profiles";
        QueryProfileXMLReader queryProfileXMLReader = new QueryProfileXMLReader();
        File f = new File(queryProfilePath);
        if (f.exists() && f.isDirectory()) {
            return queryProfileXMLReader.read(queryProfilePath).compile();
        }
        return CompiledQueryProfileRegistry.empty;
    }

    private VespaModel createVespaModel() {
        try {
            List<LightGBMImporter> modelImporters = List.of(new VespaImporter(), new TensorFlowImporter(), new OnnxImporter(), new XGBoostImporter(), new LightGBMImporter());
            DeployState deployState = new DeployState.Builder().applicationPackage((ApplicationPackage)FilesApplicationPackage.fromFile((File)this.path.toFile(), (boolean)true)).modelImporters(modelImporters).deployLogger((level, s) -> {}).accessLoggingEnabledByDefault(false).build();
            return new VespaModel((ConfigModelRegistry)new NullConfigModelRegistry(), deployState);
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException("Error creating application from '" + this.path + "'", e);
        }
    }

    public JDisc getJDisc(String id) {
        return this.container;
    }

    public CompiledQueryProfileRegistry getCompiledQueryProfileRegistry() {
        return this.compiledQueryProfileRegistry;
    }

    @Override
    public void close() {
        this.container.close();
        IOUtils.recursiveDeleteDir((File)new File(this.path.toFile(), "models.generated"));
        if (this.deletePathWhenClosing) {
            IOUtils.recursiveDeleteDir((File)this.path.toFile());
        }
    }

    @Beta
    public static class Builder {
        private static final ThreadLocal<Random> random = new ThreadLocal();
        private static final String DEFAULT_CHAIN = "default";
        private final Map<String, Container> containers = new LinkedHashMap<String, Container>();
        private final java.nio.file.Path path;
        private Networking networking = Networking.disable;

        public Builder() throws IOException {
            this.path = Builder.makeTempDir("app", "standalone").toPath();
        }

        public Builder container(String id, Container container) {
            if (this.containers.size() > 0) {
                throw new RuntimeException("Only a single JDisc container is currently supported.");
            }
            this.containers.put(id, container);
            return this;
        }

        private static File makeTempDir(String prefix, String suffix) throws IOException {
            File tmpDir = File.createTempFile(prefix, suffix, Builder.getTempDir());
            if (!tmpDir.delete()) {
                throw new RuntimeException("Could not delete temp directory: " + tmpDir);
            }
            if (!tmpDir.mkdirs()) {
                throw new RuntimeException("Could not create temp directory: " + tmpDir);
            }
            return tmpDir;
        }

        private static File getTempDir() {
            String rootPath = Builder.getResourceFile("/");
            String tmpPath = rootPath + "/tmp/";
            File tmpDir = new File(tmpPath);
            if (!(tmpDir.exists() || tmpDir.mkdirs() || tmpDir.exists())) {
                throw new RuntimeException("Could not create temp dir: " + tmpDir.getAbsolutePath());
            }
            if (!tmpDir.isDirectory()) {
                throw new RuntimeException("Temp dir path is not a directory: " + tmpDir.getAbsolutePath());
            }
            return tmpDir;
        }

        private static String getResourceFile(String resource) {
            URL resourceUrl = Application.class.getResource(resource);
            if (resourceUrl == null || resourceUrl.getFile() == null || resourceUrl.getFile().isEmpty()) {
                throw new RuntimeException("Could not access resource: " + resource);
            }
            return resourceUrl.getFile();
        }

        private void createFile(java.nio.file.Path path, String content) throws IOException {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, Utf8.toBytes((String)content), new OpenOption[0]);
        }

        private static int getRandomPort() {
            Random r = random.get();
            if (r == null) {
                r = new Random(System.currentTimeMillis());
                random.set(r);
            }
            return r.nextInt(60000) + 2000;
        }

        public Builder documentType(String name, String searchDefinition) throws IOException {
            java.nio.file.Path path = this.nestedResource(ApplicationPackage.SCHEMAS_DIR, name, ".sd");
            this.createFile(path, searchDefinition);
            return this;
        }

        public Builder expressionInclude(String name, String searchDefinition) throws IOException {
            java.nio.file.Path path = this.nestedResource(ApplicationPackage.SCHEMAS_DIR, name, ".expression");
            this.createFile(path, searchDefinition);
            return this;
        }

        public Builder rankExpression(String name, String rankExpressionContent) throws IOException {
            java.nio.file.Path path = this.nestedResource(ApplicationPackage.SCHEMAS_DIR, name, ".expression");
            this.createFile(path, rankExpressionContent);
            return this;
        }

        public Builder queryProfile(String name, String queryProfile) throws IOException {
            java.nio.file.Path path = this.nestedResource(ApplicationPackage.QUERY_PROFILES_DIR, name, ".xml");
            this.createFile(path, queryProfile);
            return this;
        }

        public Builder queryProfileType(String name, String queryProfileType) throws IOException {
            java.nio.file.Path path = this.nestedResource(ApplicationPackage.QUERY_PROFILE_TYPES_DIR, name, ".xml");
            this.createFile(path, queryProfileType);
            return this;
        }

        private java.nio.file.Path nestedResource(Path nestedPath, String name, String fileType) {
            String nameWithoutSuffix = StringUtilities.stripSuffix((String)name, (String)fileType);
            return this.path.resolve(nestedPath.getRelative()).resolve(nameWithoutSuffix + fileType);
        }

        public Builder networking(Networking networking) {
            this.networking = networking;
            return this;
        }

        private Application build() throws Exception {
            Application app = null;
            Exception exception = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    this.generateXml();
                    app = new Application(this.path, this.networking, true);
                    break;
                }
                catch (Error e) {
                    Optional bindException = Exceptions.findCause((Throwable)e, BindException.class);
                    if (!bindException.isPresent()) {
                        throw new Exception(e.getCause());
                    }
                    exception = (Exception)bindException.get();
                    com.yahoo.container.Container.resetInstance();
                    continue;
                }
            }
            if (app == null) {
                throw exception;
            }
            return app;
        }

        private void generateXml() throws Exception {
            try (PrintWriter xml = new PrintWriter(Files.newOutputStream(this.path.resolve("services.xml"), new OpenOption[0]));){
                xml.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                for (Map.Entry<String, Container> entry : this.containers.entrySet()) {
                    entry.getValue().build(xml, entry.getKey(), this.networking == Networking.enable ? Builder.getRandomPort() : -1);
                }
            }
        }

        public static class Container {
            private final Map<String, List<ComponentItem<? extends DocumentProcessor>>> docprocs = new LinkedHashMap<String, List<ComponentItem<? extends DocumentProcessor>>>();
            private final Map<String, List<ComponentItem<? extends Searcher>>> searchers = new LinkedHashMap<String, List<ComponentItem<? extends Searcher>>>();
            private final List<ComponentItem<? extends Renderer>> renderers = new ArrayList<ComponentItem<? extends Renderer>>();
            private final List<ComponentItem<? extends RequestHandler>> handlers = new ArrayList<ComponentItem<? extends RequestHandler>>();
            private final List<ComponentItem<? extends ClientProvider>> clients = new ArrayList<ComponentItem<? extends ClientProvider>>();
            private final List<ComponentItem<? extends ServerProvider>> servers = new ArrayList<ComponentItem<? extends ServerProvider>>();
            private final List<ComponentItem<?>> components = new ArrayList();
            private final List<ConfigInstance> configs = new ArrayList<ConfigInstance>();
            private boolean enableSearch = false;

            public Container documentProcessor(Class<? extends DocumentProcessor> docproc) {
                return this.documentProcessor(Builder.DEFAULT_CHAIN, docproc, new ConfigInstance[0]);
            }

            public Container documentProcessor(String chainName, Class<? extends DocumentProcessor> docproc, ConfigInstance ... configs) {
                return this.documentProcessor(docproc.getName(), chainName, docproc, configs);
            }

            public Container documentProcessor(String id, String chainName, Class<? extends DocumentProcessor> docproc, ConfigInstance ... configs) {
                List<ComponentItem<? extends DocumentProcessor>> chain = this.docprocs.get(chainName);
                if (chain == null) {
                    chain = new ArrayList<ComponentItem<? extends DocumentProcessor>>();
                    this.docprocs.put(chainName, chain);
                }
                chain.add(new ComponentItem<DocumentProcessor>(id, docproc, configs));
                return this;
            }

            public Container search(boolean enableSearch) {
                this.enableSearch = enableSearch;
                return this;
            }

            public Container searcher(Class<? extends Searcher> searcher) {
                return this.searcher(Builder.DEFAULT_CHAIN, searcher, new ConfigInstance[0]);
            }

            public Container searcher(String chainName, Class<? extends Searcher> searcher, ConfigInstance ... configs) {
                return this.searcher(searcher.getName(), chainName, searcher, configs);
            }

            public Container searcher(String id, String chainName, Class<? extends Searcher> searcher, ConfigInstance ... configs) {
                List<ComponentItem<? extends Searcher>> chain = this.searchers.get(chainName);
                if (chain == null) {
                    chain = new ArrayList<ComponentItem<? extends Searcher>>();
                    this.searchers.put(chainName, chain);
                }
                chain.add(new ComponentItem<Searcher>(id, searcher, configs));
                return this;
            }

            public Container renderer(String id, Class<? extends Renderer> renderer, ConfigInstance ... configs) {
                this.renderers.add(new ComponentItem<Renderer>(id, renderer, configs));
                return this;
            }

            public Container handler(String binding, Class<? extends RequestHandler> handler) {
                this.handlers.add(new ComponentItem<RequestHandler>(binding, handler, new ConfigInstance[0]));
                return this;
            }

            public Container client(String binding, Class<? extends ClientProvider> client) {
                this.clients.add(new ComponentItem<ClientProvider>(binding, client, new ConfigInstance[0]));
                return this;
            }

            public Container server(String id, Class<? extends ServerProvider> server) {
                this.servers.add(new ComponentItem<ServerProvider>(id, server, new ConfigInstance[0]));
                return this;
            }

            public Container component(Class<?> component) {
                return this.component(component.getName(), component, new ConfigInstance[]{null});
            }

            public Container component(String id, Class<?> component, ConfigInstance ... configs) {
                this.components.add(new ComponentItem(id, component, configs));
                return this;
            }

            public Container config(ConfigInstance config) {
                this.configs.add(config);
                return this;
            }

            private void build(PrintWriter xml, String id, int port) throws Exception {
                xml.println("<container version=\"1.0\" id=\"" + id + "\">");
                if (port > 0) {
                    xml.println("<http>");
                    xml.println("<server id=\"http\" port=\"" + port + "\" />");
                    xml.println("</http>");
                }
                for (ComponentItem<? extends RequestHandler> componentItem : this.handlers) {
                    xml.println("<handler id=\"" + componentItem.component.getName() + "\">");
                    xml.println("<binding>" + componentItem.id + "</binding>");
                    xml.println("</handler>");
                }
                for (ComponentItem<? extends RequestHandler> componentItem : this.clients) {
                    xml.println("<client id=\"" + componentItem.component.getName() + "\">");
                    xml.println("<binding>" + componentItem.id + "</binding>");
                    xml.println("</client>");
                }
                for (ComponentItem<? extends RequestHandler> componentItem : this.servers) {
                    this.generateComponent(xml, componentItem, "server");
                }
                for (ConfigInstance configInstance : this.configs) {
                    this.generateConfig(xml, configInstance);
                }
                for (ComponentItem<Object> componentItem : this.components) {
                    this.generateComponent(xml, componentItem, "component");
                }
                if (!this.docprocs.isEmpty()) {
                    xml.println("<document-processing>");
                    for (Map.Entry entry : this.docprocs.entrySet()) {
                        xml.println("<chain id=\"" + (String)entry.getKey() + "\">");
                        for (ComponentItem docproc : (List)entry.getValue()) {
                            this.generateComponent(xml, docproc, "documentprocessor");
                        }
                        xml.println("</chain>");
                    }
                    xml.println("</document-processing>");
                }
                if (this.enableSearch || !this.searchers.isEmpty() || !this.renderers.isEmpty()) {
                    xml.println("<search>");
                    for (Map.Entry entry : this.searchers.entrySet()) {
                        xml.println("<chain id=\"" + (String)entry.getKey() + "\">");
                        for (ComponentItem searcher : (List)entry.getValue()) {
                            this.generateComponent(xml, searcher, "searcher");
                        }
                        xml.println("</chain>");
                    }
                    for (ComponentItem componentItem : this.renderers) {
                        this.generateComponent(xml, componentItem, "renderer");
                    }
                    xml.println("</search>");
                }
                xml.println("<accesslog type=\"disabled\" />");
                xml.println("</container>");
            }

            private void generateComponent(PrintWriter xml, ComponentItem<?> componentItem, String elementName) throws Exception {
                xml.print("<" + elementName + " id=\"" + componentItem.id + "\" class=\"" + componentItem.component.getName() + "\"");
                if (componentItem.configs.isEmpty() || !componentItem.configs.isEmpty() && componentItem.configs.get(0) == null) {
                    xml.println(" />");
                } else {
                    xml.println(">");
                    for (ConfigInstance config : componentItem.configs) {
                        this.generateConfig(xml, config);
                    }
                    xml.println("</" + elementName + ">");
                }
            }

            private void generateConfig(PrintWriter xml, ConfigInstance config) throws Exception {
                Field nameField = config.getClass().getField("CONFIG_DEF_NAME");
                String name = (String)nameField.get(config);
                Field namespaceField = config.getClass().getField("CONFIG_DEF_NAMESPACE");
                String namespace = (String)namespaceField.get(config);
                xml.println("<config name=\"" + namespace + "." + name + "\">");
                this.generateConfigNode(xml, (InnerNode)config);
                xml.println("</config>");
            }

            private void generateConfigNode(PrintWriter xml, InnerNode node) throws Exception {
                Field[] fields;
                for (Field field : fields = node.getClass().getDeclaredFields()) {
                    this.generateConfigField(xml, node, field);
                }
            }

            private void generateConfigField(PrintWriter xml, InnerNode node, Field field) throws Exception {
                LeafNodeVector vector;
                field.setAccessible(true);
                if (LeafNode.class.isAssignableFrom(field.getType())) {
                    LeafNode value = (LeafNode)field.get(node);
                    if (value.value() != null) {
                        xml.print("<" + field.getName());
                        String v = value.getValue();
                        if (v.isEmpty()) {
                            xml.println(" />");
                        } else {
                            xml.println(">" + v + "</" + field.getName() + ">");
                        }
                    }
                } else if (InnerNode.class.isAssignableFrom(field.getType())) {
                    xml.println("<" + field.getName() + ">");
                    this.generateConfigNode(xml, (InnerNode)field.get(node));
                    xml.println("</" + field.getName() + ">");
                } else if (Map.class.isAssignableFrom(field.getType())) {
                    Map map = (Map)field.get(node);
                    if (!map.isEmpty()) {
                        xml.println("<" + field.getName() + ">");
                        for (Map.Entry entry : map.entrySet()) {
                            if (entry.getValue() instanceof InnerNode) {
                                xml.println("<item key=\"" + entry.getKey() + "\">");
                                this.generateConfigNode(xml, (InnerNode)entry.getValue());
                                xml.println("</item>");
                                continue;
                            }
                            if (!(entry.getValue() instanceof LeafNode)) continue;
                            xml.println("<item key=\"" + entry.getKey() + "\">" + ((LeafNode)entry.getValue()).getValue() + "</item>");
                        }
                        xml.println("</" + field.getName() + ">");
                    }
                } else if (InnerNodeVector.class.isAssignableFrom(field.getType())) {
                    InnerNodeVector vector2 = (InnerNodeVector)field.get(node);
                    if (!vector2.isEmpty()) {
                        xml.println("<" + field.getName() + ">");
                        for (InnerNode innerNode : vector2) {
                            xml.println("<item>");
                            this.generateConfigNode(xml, innerNode);
                            xml.println("</item>");
                        }
                        xml.println("</" + field.getName() + ">");
                    }
                } else if (LeafNodeVector.class.isAssignableFrom(field.getType()) && !(vector = (LeafNodeVector)field.get(node)).isEmpty()) {
                    xml.println("<" + field.getName() + ">");
                    for (LeafNode item : vector) {
                        xml.println("<item>" + item.getValue() + "</item>");
                    }
                    xml.println("</" + field.getName() + ">");
                }
            }

            private static class ComponentItem<T> {
                private String id;
                private Class<? extends T> component;
                private List<ConfigInstance> configs = new ArrayList<ConfigInstance>();

                public ComponentItem(String id, Class<? extends T> component, ConfigInstance ... configs) {
                    this.id = id;
                    this.component = component;
                    if (configs != null) {
                        Collections.addAll(this.configs, configs);
                    }
                }
            }
        }
    }
}

