/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.application.container;

import com.yahoo.api.annotations.Beta;
import com.yahoo.application.container.ProcessingBase;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.Chain;
import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.handler.ProcessingHandler;
import com.yahoo.processing.rendering.Renderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;

@Beta
public final class Processing
extends ProcessingBase<Request, Response, Processor> {
    private final ProcessingHandler handler;

    Processing(ProcessingHandler handler) {
        this.handler = handler;
    }

    @Override
    public ChainRegistry<Processor> getChains() {
        return this.handler.getChainRegistry();
    }

    @Override
    protected Response doProcess(Chain<Processor> chain, Request request) {
        Execution execution = this.handler.createExecution(chain, request);
        return execution.process(request);
    }

    @Override
    protected CompletableFuture<Boolean> doProcessAndRender(ComponentSpecification chainSpec, Request request, Renderer<Response> renderer, ByteArrayOutputStream stream) throws IOException {
        Execution execution = this.handler.createExecution(this.getChain(chainSpec), request);
        Response response = execution.process(request);
        return renderer.renderResponse((OutputStream)stream, response, execution, request);
    }

    @Override
    protected Renderer<Response> doGetRenderer(ComponentSpecification spec) {
        return this.handler.getRendererCopy(spec);
    }
}

