/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.abicheck.classtree;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ClassFileTree
implements AutoCloseable {
    public static ClassFileTree fromJar(final JarFile jarFile) {
        final HashMap<String, Package> rootPackages = new HashMap<String, Package>();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            final JarEntry entry = jarEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            ArrayDeque<String> parts = new ArrayDeque<String>(List.of(entry.getName().split("/")));
            String className = (String)parts.removeLast();
            Package pkg = rootPackages.computeIfAbsent((String)parts.removeFirst(), name -> new Package(null, (String)name));
            for (String part : parts) {
                pkg = pkg.getOrCreateSubPackage(part);
            }
            pkg.addClass(new ClassFile(pkg, className){

                @Override
                public InputStream getInputStream() throws IOException {
                    return jarFile.getInputStream(entry);
                }
            });
        }
        return new ClassFileTree(){

            @Override
            public Collection<Package> getRootPackages() {
                return rootPackages.values();
            }

            @Override
            public void close() throws IOException {
                jarFile.close();
            }
        };
    }

    @Override
    public abstract void close() throws IOException;

    public abstract Collection<Package> getRootPackages();

    public static class Package {
        private final Package parent;
        private final String name;
        private final Map<String, Package> subPackages = new HashMap<String, Package>();
        private final Set<ClassFile> classFiles = new HashSet<ClassFile>();

        private Package(Package parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        private Package getOrCreateSubPackage(String name) {
            return this.subPackages.computeIfAbsent(name, n -> new Package(this, (String)n));
        }

        private void addClass(ClassFile klazz) {
            this.classFiles.add(klazz);
        }

        public String getFullyQualifiedName() {
            if (this.parent == null) {
                return this.name;
            }
            return this.parent.getFullyQualifiedName() + "." + this.name;
        }

        public Collection<Package> getSubPackages() {
            return this.subPackages.values();
        }

        public Collection<ClassFile> getClassFiles() {
            return this.classFiles;
        }

        public String toString() {
            return "Package(" + this.getFullyQualifiedName() + ")";
        }
    }

    public static abstract class ClassFile {
        private final Package parent;
        private final String name;

        private ClassFile(Package parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public abstract InputStream getInputStream() throws IOException;

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "ClassFile(" + this.parent.getFullyQualifiedName() + "." + this.name + ")";
        }
    }
}

