/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.abicheck.mojo;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.yahoo.abicheck.classtree.ClassFileTree;
import com.yahoo.abicheck.collector.AnnotationCollector;
import com.yahoo.abicheck.collector.PublicSignatureCollector;
import com.yahoo.abicheck.setmatcher.SetMatcher;
import com.yahoo.abicheck.signature.JavaClassSignature;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Mojo(name="abicheck", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, instantiationStrategy=InstantiationStrategy.PER_LOOKUP, threadSafe=true)
public class AbiCheck
extends AbstractMojo {
    public static final String PACKAGE_INFO_CLASS_FILE_NAME = "package-info.class";
    private static final String DEFAULT_SPEC_FILE = "abi-spec.json";
    private static final String WRITE_SPEC_PROPERTY = "abicheck.writeSpec";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project = null;
    @Parameter(required=true)
    private String publicApiAnnotation = null;
    @Parameter
    private String specFileName = "abi-spec.json";

    private static Map<String, JavaClassSignature> readSpec(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            ObjectMapper mapper = new ObjectMapper();
            MapType typeToken = mapper.getTypeFactory().constructMapType(HashMap.class, String.class, JavaClassSignature.class);
            Map map = (Map)mapper.readValue((Reader)reader, (JavaType)typeToken);
            return map;
        }
    }

    private static void writeSpec(Map<String, JavaClassSignature> signatures, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            new ObjectMapper().writer((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE)).writeValue((Writer)writer, signatures);
        }
    }

    private static boolean matchingClasses(String className, JavaClassSignature expected, JavaClassSignature actual, Log log) {
        boolean match = true;
        if (!expected.superClass.equals(actual.superClass)) {
            match = false;
            log.error((CharSequence)String.format("Class %s: Expected superclass %s, found %s", className, expected.superClass, actual.superClass));
        }
        if (!SetMatcher.compare(expected.interfaces, actual.interfaces, item -> true, item -> log.error((CharSequence)String.format("Class %s: Missing interface %s", className, item)), item -> log.error((CharSequence)String.format("Class %s: Extra interface %s", className, item)))) {
            match = false;
        }
        if (!SetMatcher.compare(new HashSet<String>(expected.attributes), new HashSet<String>(actual.attributes), item -> true, item -> log.error((CharSequence)String.format("Class %s: Missing attribute %s", className, item)), item -> log.error((CharSequence)String.format("Class %s: Extra attribute %s", className, item)))) {
            match = false;
        }
        if (!SetMatcher.compare(expected.methods, actual.methods, item -> true, item -> log.error((CharSequence)String.format("Class %s: Missing method %s", className, item)), item -> log.error((CharSequence)String.format("Class %s: Extra method %s", className, item)))) {
            match = false;
        }
        if (!SetMatcher.compare(expected.fields, actual.fields, item -> true, item -> log.error((CharSequence)String.format("Class %s: Missing field %s", className, item)), item -> log.error((CharSequence)String.format("Class %s: Extra field %s", className, item)))) {
            match = false;
        }
        return match;
    }

    private static boolean isPublicAbiPackage(ClassFileTree.Package pkg, String publicApiAnnotation) throws IOException {
        Optional<ClassFileTree.ClassFile> pkgInfo = pkg.getClassFiles().stream().filter(klazz -> klazz.getName().equals(PACKAGE_INFO_CLASS_FILE_NAME)).findFirst();
        if (!pkgInfo.isPresent()) {
            return false;
        }
        try (InputStream is = pkgInfo.get().getInputStream();){
            AnnotationCollector visitor = new AnnotationCollector();
            new ClassReader(is).accept((ClassVisitor)visitor, 7);
            boolean bl = visitor.getAnnotations().contains(publicApiAnnotation);
            return bl;
        }
    }

    static Map<String, JavaClassSignature> collectPublicAbiSignatures(ClassFileTree.Package pkg, String publicApiAnnotation) throws IOException {
        LinkedHashMap<String, JavaClassSignature> signatures = new LinkedHashMap<String, JavaClassSignature>();
        if (AbiCheck.isPublicAbiPackage(pkg, publicApiAnnotation)) {
            PublicSignatureCollector collector = new PublicSignatureCollector();
            List<ClassFileTree.ClassFile> sortedClassFiles = pkg.getClassFiles().stream().sorted(Comparator.comparing(ClassFileTree.ClassFile::getName)).toList();
            for (ClassFileTree.ClassFile klazz : sortedClassFiles) {
                InputStream is = klazz.getInputStream();
                try {
                    new ClassReader(is).accept((ClassVisitor)collector, 0);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            signatures.putAll(collector.getClassSignatures());
        }
        List<ClassFileTree.Package> sortedSubPackages = pkg.getSubPackages().stream().sorted(Comparator.comparing(ClassFileTree.Package::getFullyQualifiedName)).toList();
        for (ClassFileTree.Package subPkg : sortedSubPackages) {
            signatures.putAll(AbiCheck.collectPublicAbiSignatures(subPkg, publicApiAnnotation));
        }
        return signatures;
    }

    static boolean compareSignatures(Map<String, JavaClassSignature> expected, Map<String, JavaClassSignature> actual, Log log) {
        return SetMatcher.compare(expected.keySet(), actual.keySet(), item -> AbiCheck.matchingClasses(item, (JavaClassSignature)expected.get(item), (JavaClassSignature)actual.get(item), log), item -> log.error((CharSequence)String.format("Missing class: %s", item)), item -> log.error((CharSequence)String.format("Extra class: %s", item)));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact mainArtifact = this.project.getArtifact();
        File specFile = new File(this.project.getBasedir(), this.specFileName);
        if (mainArtifact.getFile() == null) {
            throw new MojoExecutionException("Missing project artifact file");
        }
        if (!mainArtifact.getFile().getName().endsWith(".jar")) {
            throw new MojoExecutionException("Project artifact is not a JAR");
        }
        this.getLog().debug((CharSequence)("Analyzing " + mainArtifact.getFile()));
        try (JarFile jarFile = new JarFile(mainArtifact.getFile());){
            ClassFileTree tree = ClassFileTree.fromJar(jarFile);
            LinkedHashMap<String, JavaClassSignature> signatures = new LinkedHashMap<String, JavaClassSignature>();
            for (ClassFileTree.Package pkg : tree.getRootPackages()) {
                signatures.putAll(AbiCheck.collectPublicAbiSignatures(pkg, this.publicApiAnnotation));
            }
            if (System.getProperty(WRITE_SPEC_PROPERTY) != null) {
                this.getLog().info((CharSequence)("Writing ABI specs to " + specFile.getPath()));
                AbiCheck.writeSpec(signatures, specFile);
            } else {
                Map<String, JavaClassSignature> abiSpec = AbiCheck.readSpec(specFile);
                if (!AbiCheck.compareSignatures(abiSpec, signatures, this.getLog())) {
                    throw new MojoFailureException("ABI spec mismatch.\nTo update run 'mvn package -Dabicheck.writeSpec'");
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error processing class signatures", (Exception)e);
        }
    }
}

