/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.abicheck.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Util {
    public static final List<AccessFlag> classFlags = Arrays.asList(AccessFlag.make(1, "public"), AccessFlag.make(2, "private"), AccessFlag.make(4, "protected"), AccessFlag.make(16, "final"), AccessFlag.ignored(32), AccessFlag.make(512, "interface"), AccessFlag.make(1024, "abstract"), AccessFlag.make(4096, "synthetic"), AccessFlag.make(8192, "annotation"), AccessFlag.make(16384, "enum"), AccessFlag.ignored(131072));
    public static final List<AccessFlag> methodFlags = Arrays.asList(AccessFlag.make(1, "public"), AccessFlag.make(2, "private"), AccessFlag.make(4, "protected"), AccessFlag.make(8, "static"), AccessFlag.make(16, "final"), AccessFlag.make(32, "synchronized"), AccessFlag.make(64, "bridge"), AccessFlag.make(128, "varargs"), AccessFlag.make(256, "native"), AccessFlag.make(1024, "abstract"), AccessFlag.make(2048, "strict"), AccessFlag.make(4096, "synthetic"), AccessFlag.ignored(131072));
    public static final List<AccessFlag> fieldFlags = Arrays.asList(AccessFlag.make(1, "public"), AccessFlag.make(2, "private"), AccessFlag.make(4, "protected"), AccessFlag.make(8, "static"), AccessFlag.make(16, "final"), AccessFlag.make(64, "volatile"), AccessFlag.make(128, "transient"), AccessFlag.make(4096, "synthetic"), AccessFlag.make(16384, "enum"), AccessFlag.ignored(131072));

    public static List<String> convertAccess(int access, List<AccessFlag> flags) {
        ArrayList<String> result = new ArrayList<String>();
        for (AccessFlag flag : flags) {
            if ((access & flag.bit) != 0 && flag.attribute != null) {
                result.add(flag.attribute);
            }
            access &= ~flag.bit;
        }
        if (access != 0) {
            throw new IllegalArgumentException(String.format("Unexpected access bits: 0x%x", access));
        }
        return result;
    }

    public static class AccessFlag {
        public final int bit;
        public final String attribute;

        private AccessFlag(int bit, String attribute) {
            this.bit = bit;
            this.attribute = attribute;
        }

        private static AccessFlag make(int bit, String attribute) {
            return new AccessFlag(bit, attribute);
        }

        private static AccessFlag ignored(int bit) {
            return new AccessFlag(bit, null);
        }
    }
}

