/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.yahoo.pulsar.client.admin.PersistentTopics;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.client.api.Message;
import com.yahoo.pulsar.client.api.MessageId;
import com.yahoo.pulsar.client.impl.MessageIdImpl;
import com.yahoo.pulsar.client.impl.MessageImpl;
import com.yahoo.pulsar.common.naming.DestinationName;
import com.yahoo.pulsar.common.naming.NamespaceName;
import com.yahoo.pulsar.common.partition.PartitionedTopicMetadata;
import com.yahoo.pulsar.common.policies.data.AuthAction;
import com.yahoo.pulsar.common.policies.data.ErrorData;
import com.yahoo.pulsar.common.policies.data.PartitionedTopicStats;
import com.yahoo.pulsar.common.policies.data.PersistentTopicInternalStats;
import com.yahoo.pulsar.common.policies.data.PersistentTopicStats;
import com.yahoo.pulsar.common.util.Codec;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTopicsImpl
extends BaseResource
implements PersistentTopics {
    private final WebTarget persistentTopics;
    private static final Logger log = LoggerFactory.getLogger(PersistentTopicsImpl.class);

    public PersistentTopicsImpl(WebTarget web, Authentication auth) {
        super(auth);
        this.persistentTopics = web.path("/persistent");
    }

    @Override
    public List<String> getList(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (List)this.request(this.persistentTopics.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName())).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public List<String> getPartitionedTopicList(String namespace) throws PulsarAdminException {
        try {
            NamespaceName ns = new NamespaceName(namespace);
            return (List)this.request(this.persistentTopics.path(ns.getProperty()).path(ns.getCluster()).path(ns.getLocalName()).path("partitioned")).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<String, Set<AuthAction>> getPermissions(String destination) throws PulsarAdminException {
        try {
            DestinationName ds = DestinationName.get((String)destination);
            return (Map)this.request(this.persistentTopics.path(ds.getNamespace()).path(ds.getLocalName()).path("permissions")).get((GenericType)new GenericType<Map<String, Set<AuthAction>>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void grantPermission(String destination, String role, Set<AuthAction> actions) throws PulsarAdminException {
        try {
            DestinationName ds = DestinationName.get((String)destination);
            this.request(this.persistentTopics.path(ds.getNamespace()).path(ds.getLocalName()).path("permissions").path(role)).post(Entity.entity(actions, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void revokePermissions(String destination, String role) throws PulsarAdminException {
        try {
            DestinationName ds = DestinationName.get((String)destination);
            this.request(this.persistentTopics.path(ds.getNamespace()).path(ds.getLocalName()).path("permissions").path(role)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createPartitionedTopic(String destination, int numPartitions) throws PulsarAdminException {
        try {
            this.createPartitionedTopicAsync(destination, numPartitions).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> createPartitionedTopicAsync(String destination, int numPartitions) {
        Preconditions.checkArgument((numPartitions > 1 ? 1 : 0) != 0, (Object)"Number of partitions should be more than 1");
        DestinationName ds = this.validateTopic(destination);
        return this.asyncPutRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("partitions"), Entity.entity((Object)numPartitions, (String)"application/json"));
    }

    @Override
    public void updatePartitionedTopic(String destination, int numPartitions) throws PulsarAdminException {
        try {
            this.updatePartitionedTopicAsync(destination, numPartitions).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> updatePartitionedTopicAsync(String destination, int numPartitions) {
        Preconditions.checkArgument((numPartitions > 1 ? 1 : 0) != 0, (Object)"Number of partitions must be more than 1");
        DestinationName ds = this.validateTopic(destination);
        return this.asyncPostRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("partitions"), Entity.entity((Object)numPartitions, (String)"application/json"));
    }

    @Override
    public PartitionedTopicMetadata getPartitionedTopicMetadata(String destination) throws PulsarAdminException {
        try {
            return this.getPartitionedTopicMetadataAsync(destination).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        final CompletableFuture<PartitionedTopicMetadata> future = new CompletableFuture<PartitionedTopicMetadata>();
        this.asyncGetRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("partitions"), new InvocationCallback<PartitionedTopicMetadata>(){

            public void completed(PartitionedTopicMetadata response) {
                future.complete(response);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void deletePartitionedTopic(String destination) throws PulsarAdminException {
        try {
            this.deletePartitionedTopicAsync(destination).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> deletePartitionedTopicAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        return this.asyncDeleteRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("partitions"));
    }

    @Override
    public void delete(String destination) throws PulsarAdminException {
        try {
            this.deleteAsync(destination).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> deleteAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        return this.asyncDeleteRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()));
    }

    @Override
    public List<String> getSubscriptions(String destination) throws PulsarAdminException {
        try {
            return this.getSubscriptionsAsync(destination).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<List<String>> getSubscriptionsAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        final CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        this.asyncGetRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscriptions"), new InvocationCallback<List<String>>(){

            public void completed(List<String> response) {
                future.complete(response);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public PersistentTopicStats getStats(String destination) throws PulsarAdminException {
        try {
            return this.getStatsAsync(destination).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<PersistentTopicStats> getStatsAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        final CompletableFuture<PersistentTopicStats> future = new CompletableFuture<PersistentTopicStats>();
        this.asyncGetRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("stats"), new InvocationCallback<PersistentTopicStats>(){

            public void completed(PersistentTopicStats response) {
                future.complete(response);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public PersistentTopicInternalStats getInternalStats(String destination) throws PulsarAdminException {
        try {
            return this.getInternalStatsAsync(destination).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        final CompletableFuture<PersistentTopicInternalStats> future = new CompletableFuture<PersistentTopicInternalStats>();
        this.asyncGetRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("internalStats"), new InvocationCallback<PersistentTopicInternalStats>(){

            public void completed(PersistentTopicInternalStats response) {
                future.complete(response);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public JsonObject getInternalInfo(String destination) throws PulsarAdminException {
        try {
            return this.getInternalInfoAsync(destination).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<JsonObject> getInternalInfoAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        final CompletableFuture<JsonObject> future = new CompletableFuture<JsonObject>();
        this.asyncGetRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("internal-info"), new InvocationCallback<String>(){

            public void completed(String response) {
                JsonObject json = (JsonObject)new Gson().fromJson(response, JsonObject.class);
                future.complete(json);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public PartitionedTopicStats getPartitionedStats(String destination, boolean perPartition) throws PulsarAdminException {
        try {
            return this.getPartitionedStatsAsync(destination, perPartition).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<PartitionedTopicStats> getPartitionedStatsAsync(String destination, final boolean perPartition) {
        DestinationName ds = this.validateTopic(destination);
        final CompletableFuture<PartitionedTopicStats> future = new CompletableFuture<PartitionedTopicStats>();
        this.asyncGetRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("partitioned-stats"), new InvocationCallback<PartitionedTopicStats>(){

            public void completed(PartitionedTopicStats response) {
                if (!perPartition) {
                    response.partitions.clear();
                }
                future.complete(response);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public void deleteSubscription(String destination, String subName) throws PulsarAdminException {
        try {
            this.deleteSubscriptionAsync(destination, subName).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> deleteSubscriptionAsync(String destination, String subName) {
        DestinationName ds = this.validateTopic(destination);
        String encodedSubName = Codec.encode((String)subName);
        return this.asyncDeleteRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscription").path(encodedSubName));
    }

    @Override
    public void skipAllMessages(String destination, String subName) throws PulsarAdminException {
        try {
            this.skipAllMessagesAsync(destination, subName).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> skipAllMessagesAsync(String destination, String subName) {
        DestinationName ds = this.validateTopic(destination);
        String encodedSubName = Codec.encode((String)subName);
        return this.asyncPostRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscription").path(encodedSubName).path("skip_all"), Entity.entity((Object)"", (String)"application/json"));
    }

    @Override
    public void skipMessages(String destination, String subName, long numMessages) throws PulsarAdminException {
        try {
            this.skipMessagesAsync(destination, subName, numMessages).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> skipMessagesAsync(String destination, String subName, long numMessages) {
        DestinationName ds = this.validateTopic(destination);
        String encodedSubName = Codec.encode((String)subName);
        return this.asyncPostRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscription").path(encodedSubName).path("skip").path(String.valueOf(numMessages)), Entity.entity((Object)"", (String)"application/json"));
    }

    @Override
    public void expireMessages(String destination, String subName, long expireTimeInSeconds) throws PulsarAdminException {
        try {
            this.expireMessagesAsync(destination, subName, expireTimeInSeconds).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> expireMessagesAsync(String destination, String subName, long expireTimeInSeconds) {
        DestinationName ds = this.validateTopic(destination);
        String encodedSubName = Codec.encode((String)subName);
        return this.asyncPostRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscription").path(encodedSubName).path("expireMessages").path(String.valueOf(expireTimeInSeconds)), Entity.entity((Object)"", (String)"application/json"));
    }

    @Override
    public void expireMessagesForAllSubscriptions(String destination, long expireTimeInSeconds) throws PulsarAdminException {
        try {
            this.expireMessagesForAllSubscriptionsAsync(destination, expireTimeInSeconds).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<Void> expireMessagesForAllSubscriptionsAsync(String destination, long expireTimeInSeconds) {
        DestinationName ds = this.validateTopic(destination);
        return this.asyncPostRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("all_subscription").path("expireMessages").path(String.valueOf(expireTimeInSeconds)), Entity.entity((Object)"", (String)"application/json"));
    }

    private CompletableFuture<Message> peekNthMessage(String destination, String subName, int messagePosition) {
        DestinationName ds = this.validateTopic(destination);
        String encodedSubName = Codec.encode((String)subName);
        final CompletableFuture<Message> future = new CompletableFuture<Message>();
        this.asyncGetRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscription").path(encodedSubName).path("position").path(String.valueOf(messagePosition)), new InvocationCallback<Response>(){

            public void completed(Response response) {
                try {
                    Message msg = PersistentTopicsImpl.this.getMessageFromHttpResponse(response);
                    future.complete(msg);
                }
                catch (Exception e) {
                    future.completeExceptionally(PersistentTopicsImpl.this.getApiException(e));
                }
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    @Override
    public List<Message> peekMessages(String destination, String subName, int numMessages) throws PulsarAdminException {
        try {
            return this.peekMessagesAsync(destination, subName, numMessages).get();
        }
        catch (ExecutionException e) {
            throw (PulsarAdminException)e.getCause();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarAdminException(e.getCause());
        }
    }

    @Override
    public CompletableFuture<List<Message>> peekMessagesAsync(String destination, String subName, int numMessages) {
        Preconditions.checkArgument((numMessages > 0 ? 1 : 0) != 0);
        ArrayList messages = Lists.newArrayList();
        CompletableFuture<List<Message>> futures = new CompletableFuture<List<Message>>();
        this.peekNthMessage(destination, subName, 1).handle((r, ex) -> {
            if (ex != null) {
                futures.completeExceptionally((Throwable)ex);
            } else {
                block6: {
                    messages.add(r);
                    ArrayList futureMessages = Lists.newArrayList();
                    for (int i = 2; i <= numMessages; ++i) {
                        futureMessages.add(this.peekNthMessage(destination, subName, i));
                    }
                    try {
                        for (CompletableFuture futureMessage : futureMessages) {
                            messages.add(futureMessage.get());
                        }
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof PulsarAdminException.NotFoundException) break block6;
                        futures.completeExceptionally(e.getCause());
                        return null;
                    }
                }
                futures.complete(messages);
            }
            return null;
        });
        return futures;
    }

    @Override
    public void resetCursor(String destination, String subName, long timestamp) throws PulsarAdminException {
        try {
            DestinationName ds = this.validateTopic(destination);
            String encodedSubName = Codec.encode((String)subName);
            this.request(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscription").path(encodedSubName).path("resetcursor").path(String.valueOf(timestamp))).post(Entity.entity((Object)"", (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public CompletableFuture<Void> resetCursorAsync(String destination, String subName, long timestamp) {
        DestinationName ds = this.validateTopic(destination);
        String encodedSubName = Codec.encode((String)subName);
        return this.asyncPostRequest(this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("subscription").path(encodedSubName).path("resetcursor").path(String.valueOf(timestamp)), Entity.entity((Object)"", (String)"application/json"));
    }

    @Override
    public CompletableFuture<MessageId> terminateTopicAsync(String destination) {
        DestinationName ds = this.validateTopic(destination);
        final CompletableFuture<MessageId> future = new CompletableFuture<MessageId>();
        try {
            final WebTarget target = this.persistentTopics.path(ds.getNamespace()).path(ds.getEncodedLocalName()).path("terminate");
            this.request(target).async().post(Entity.entity((Object)"", (String)"application/json"), (InvocationCallback)new InvocationCallback<MessageIdImpl>(){

                public void completed(MessageIdImpl messageId) {
                    future.complete(messageId);
                }

                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(PersistentTopicsImpl.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    private DestinationName validateTopic(String destination) {
        return DestinationName.get((String)destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getMessageFromHttpResponse(Response response) throws Exception {
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            if (response.getStatus() >= 500) {
                throw new ServerErrorException(response);
            }
            if (response.getStatus() >= 400) {
                throw new ClientErrorException(response);
            }
            throw new WebApplicationException(response);
        }
        String msgId = response.getHeaderString("X-Pulsar-Message-ID");
        try (InputStream stream = null;){
            stream = (InputStream)response.getEntity();
            byte[] data = new byte[stream.available()];
            stream.read(data);
            TreeMap properties = Maps.newTreeMap();
            MultivaluedMap headers = response.getHeaders();
            Object publishTime = headers.getFirst((Object)"X-Pulsar-publish-time");
            if (publishTime != null) {
                properties.put("publish-time", (String)publishTime);
            }
            for (Map.Entry entry : headers.entrySet()) {
                String header = (String)entry.getKey();
                if (!header.contains("X-Pulsar-PROPERTY-")) continue;
                String keyName = header.substring(header.indexOf("X-Pulsar-PROPERTY-") + 1, header.length());
                properties.put(keyName, (String)((List)entry.getValue()).get(0));
            }
            MessageImpl messageImpl = new MessageImpl(msgId, (Map)properties, data);
            return messageImpl;
        }
    }
}

