/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.yahoo.pulsar.client.admin.Clusters;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.common.policies.data.ClusterData;
import com.yahoo.pulsar.common.policies.data.ErrorData;
import com.yahoo.pulsar.common.policies.data.NamespaceIsolationData;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class ClustersImpl
extends BaseResource
implements Clusters {
    private final WebTarget clusters;

    public ClustersImpl(WebTarget web, Authentication auth) {
        super(auth);
        this.clusters = web.path("/clusters");
    }

    @Override
    public List<String> getClusters() throws PulsarAdminException {
        try {
            return (List)this.request(this.clusters).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public ClusterData getCluster(String cluster) throws PulsarAdminException {
        try {
            return (ClusterData)this.request(this.clusters.path(cluster)).get(ClusterData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        try {
            this.request(this.clusters.path(cluster)).put(Entity.entity((Object)clusterData, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateCluster(String cluster, ClusterData clusterData) throws PulsarAdminException {
        try {
            this.request(this.clusters.path(cluster)).post(Entity.entity((Object)clusterData, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteCluster(String cluster) throws PulsarAdminException {
        try {
            this.request(this.clusters.path(cluster)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public Map<String, NamespaceIsolationData> getNamespaceIsolationPolicies(String cluster) throws PulsarAdminException {
        try {
            return (Map)this.request(this.clusters.path(cluster).path("namespaceIsolationPolicies")).get((GenericType)new GenericType<Map<String, NamespaceIsolationData>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void updateNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        this.setNamespaceIsolationPolicy(cluster, policyName, namespaceIsolationData);
    }

    @Override
    public void deleteNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        this.request(this.clusters.path(cluster).path("namespaceIsolationPolicies").path(policyName)).delete(ErrorData.class);
    }

    private void setNamespaceIsolationPolicy(String cluster, String policyName, NamespaceIsolationData namespaceIsolationData) throws PulsarAdminException {
        try {
            this.request(this.clusters.path(cluster).path("namespaceIsolationPolicies").path(policyName)).post(Entity.entity((Object)namespaceIsolationData, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public NamespaceIsolationData getNamespaceIsolationPolicy(String cluster, String policyName) throws PulsarAdminException {
        try {
            return (NamespaceIsolationData)this.request(this.clusters.path(cluster).path("namespaceIsolationPolicies").path(policyName)).get(NamespaceIsolationData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }
}

