/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin;

import com.yahoo.pulsar.common.policies.data.ErrorData;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.WebApplicationException;

public class PulsarAdminException
extends Exception {
    private static final int DEFAULT_STATUS_CODE = 500;
    private final String httpError;
    private final int statusCode;

    private static String getReasonFromServer(WebApplicationException e) {
        if ("application/json".equals(e.getResponse().getHeaderString("Content-Type"))) {
            try {
                return ((ErrorData)e.getResponse().readEntity(ErrorData.class)).reason;
            }
            catch (Exception ex) {
                return e.getMessage();
            }
        }
        return e.getMessage();
    }

    public PulsarAdminException(ClientErrorException e) {
        super(PulsarAdminException.getReasonFromServer((WebApplicationException)e), (Throwable)e);
        this.httpError = e.getMessage();
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(ClientErrorException e, String message) {
        super(message, (Throwable)e);
        this.httpError = e.getMessage();
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(ServerErrorException e) {
        super(PulsarAdminException.getReasonFromServer((WebApplicationException)e), (Throwable)e);
        this.httpError = e.getMessage();
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(ServerErrorException e, String message) {
        super(message, (Throwable)e);
        this.httpError = e.getMessage();
        this.statusCode = e.getResponse().getStatus();
    }

    public PulsarAdminException(Throwable t) {
        super(t);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(String message, Throwable t) {
        super(message, t);
        this.httpError = null;
        this.statusCode = 500;
    }

    public PulsarAdminException(String message) {
        super(message);
        this.httpError = null;
        this.statusCode = 500;
    }

    public String getHttpError() {
        return this.httpError;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static class GettingAuthenticationDataException
    extends PulsarAdminException {
        public GettingAuthenticationDataException(Throwable t) {
            super(t);
        }

        public GettingAuthenticationDataException(String msg) {
            super(msg);
        }
    }

    public static class ConnectException
    extends PulsarAdminException {
        public ConnectException(Throwable t) {
            super(t);
        }

        public ConnectException(String message, Throwable t) {
            super(message, t);
        }
    }

    public static class HttpErrorException
    extends PulsarAdminException {
        public HttpErrorException(Exception e) {
            super(e);
        }

        public HttpErrorException(Throwable t) {
            super(t);
        }
    }

    public static class ServerSideErrorException
    extends PulsarAdminException {
        public ServerSideErrorException(ServerErrorException e) {
            super(e, "Some error occourred on the server");
        }
    }

    public static class PreconditionFailedException
    extends PulsarAdminException {
        public PreconditionFailedException(ClientErrorException e) {
            super(e);
        }
    }

    public static class ConflictException
    extends PulsarAdminException {
        public ConflictException(ClientErrorException e) {
            super(e);
        }
    }

    public static class NotAllowedException
    extends PulsarAdminException {
        public NotAllowedException(ClientErrorException e) {
            super(e);
        }
    }

    public static class NotFoundException
    extends PulsarAdminException {
        public NotFoundException(ClientErrorException e) {
            super(e);
        }
    }

    public static class NotAuthorizedException
    extends PulsarAdminException {
        public NotAuthorizedException(ClientErrorException e) {
            super(e);
        }
    }
}

