/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.UintMap;

public class Decompiler {
    public static final int ONLY_BODY_FLAG = 1;
    public static final int TO_SOURCE_FLAG = 2;
    public static final int INITIAL_INDENT_PROP = 1;
    public static final int INDENT_GAP_PROP = 2;
    public static final int CASE_GAP_PROP = 3;
    private static final int FUNCTION_END = 155;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private static final boolean printSource = false;

    String getEncodedSource() {
        return this.sourceToString(0);
    }

    int getCurrentOffset() {
        return this.sourceTop;
    }

    int markFunctionStart(int functionType) {
        int savedOffset = this.getCurrentOffset();
        this.addToken(105);
        this.append((char)functionType);
        return savedOffset;
    }

    int markFunctionEnd(int functionStart) {
        int offset = this.getCurrentOffset();
        this.append('\u009b');
        return offset;
    }

    void addToken(int token) {
        if (0 > token || token > 154) {
            throw new IllegalArgumentException();
        }
        this.append((char)token);
    }

    void addEOL(int token) {
        if (0 > token || token > 154) {
            throw new IllegalArgumentException();
        }
        this.append((char)token);
        this.append('\u0001');
    }

    void addName(String str) {
        this.addToken(38);
        this.appendString(str);
    }

    void addString(String str) {
        this.addToken(40);
        this.appendString(str);
    }

    void addRegexp(String regexp, String flags) {
        this.addToken(47);
        this.appendString('/' + regexp + '/' + flags);
    }

    void addJScriptConditionalComment(String str) {
        this.addToken(152);
        this.appendString(str);
    }

    void addPreservedComment(String str) {
        this.addToken(153);
        this.appendString(str);
    }

    void addNumber(double n) {
        this.addToken(39);
        long lbits = (long)n;
        if ((double)lbits != n) {
            lbits = Double.doubleToLongBits(n);
            this.append('D');
            this.append((char)(lbits >> 48));
            this.append((char)(lbits >> 32));
            this.append((char)(lbits >> 16));
            this.append((char)lbits);
        } else {
            if (lbits < 0L) {
                Kit.codeBug();
            }
            if (lbits <= 65535L) {
                this.append('S');
                this.append((char)lbits);
            } else {
                this.append('J');
                this.append((char)(lbits >> 48));
                this.append((char)(lbits >> 32));
                this.append((char)(lbits >> 16));
                this.append((char)lbits);
            }
        }
    }

    private void appendString(String str) {
        int nextTop;
        int L = str.length();
        int lengthEncodingSize = 1;
        if (L >= 32768) {
            lengthEncodingSize = 2;
        }
        if ((nextTop = this.sourceTop + lengthEncodingSize + L) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(nextTop);
        }
        if (L >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | L >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)L;
        ++this.sourceTop;
        str.getChars(0, L, this.sourceBuffer, this.sourceTop);
        this.sourceTop = nextTop;
    }

    private void append(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void increaseSourceCapacity(int minimalCapacity) {
        int newCapacity;
        if (minimalCapacity <= this.sourceBuffer.length) {
            Kit.codeBug();
        }
        if ((newCapacity = this.sourceBuffer.length * 2) < minimalCapacity) {
            newCapacity = minimalCapacity;
        }
        char[] tmp = new char[newCapacity];
        System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceTop);
        this.sourceBuffer = tmp;
    }

    private String sourceToString(int offset) {
        if (offset < 0 || this.sourceTop < offset) {
            Kit.codeBug();
        }
        return new String(this.sourceBuffer, offset, this.sourceTop - offset);
    }

    public static String decompile(String source, int flags, UintMap properties) {
        int topFunctionType;
        int length = source.length();
        if (length == 0) {
            return "";
        }
        int indent = properties.getInt(1, 0);
        if (indent < 0) {
            throw new IllegalArgumentException();
        }
        int indentGap = properties.getInt(2, 4);
        if (indentGap < 0) {
            throw new IllegalArgumentException();
        }
        int caseGap = properties.getInt(3, 2);
        if (caseGap < 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer result = new StringBuffer();
        boolean justFunctionBody = 0 != (flags & 1);
        boolean toSource = 0 != (flags & 2);
        int braceNesting = 0;
        boolean afterFirstEOL = false;
        int i = 0;
        if (source.charAt(i) == '\u0084') {
            ++i;
            topFunctionType = -1;
        } else {
            topFunctionType = source.charAt(i + 1);
        }
        if (!toSource) {
            result.append('\n');
            for (int j = 0; j < indent; ++j) {
                result.append(' ');
            }
        } else if (topFunctionType == 2) {
            result.append('(');
        }
        block97: while (i < length) {
            switch (source.charAt(i)) {
                case '\u0093': 
                case '\u0094': {
                    result.append(source.charAt(i) == '\u0093' ? "get " : "set ");
                    ++i;
                    i = Decompiler.printSourceString(source, i + 1, false, result);
                    ++i;
                    break;
                }
                case '&': 
                case '/': {
                    i = Decompiler.printSourceString(source, i + 1, false, result);
                    continue block97;
                }
                case '(': {
                    i = Decompiler.printSourceString(source, i + 1, true, result);
                    continue block97;
                }
                case '\'': {
                    i = Decompiler.printSourceNumber(source, i + 1, result);
                    continue block97;
                }
                case ',': {
                    result.append("true");
                    break;
                }
                case '+': {
                    result.append("false");
                    break;
                }
                case ')': {
                    result.append("null");
                    break;
                }
                case '*': {
                    result.append("this");
                    break;
                }
                case 'i': {
                    ++i;
                    result.append("function ");
                    break;
                }
                case '\u009b': {
                    break;
                }
                case 'U': {
                    result.append(", ");
                    break;
                }
                case 'Q': {
                    ++braceNesting;
                    if (1 == Decompiler.getNext(source, length, i)) {
                        indent += indentGap;
                    }
                    result.append('{');
                    break;
                }
                case 'R': {
                    if (justFunctionBody && --braceNesting == 0) break;
                    result.append('}');
                    switch (Decompiler.getNext(source, length, i)) {
                        case 1: 
                        case 155: {
                            indent -= indentGap;
                            break;
                        }
                        case 109: 
                        case 113: {
                            indent -= indentGap;
                            result.append(' ');
                        }
                    }
                    break;
                }
                case 'S': {
                    result.append('(');
                    break;
                }
                case 'T': {
                    result.append(')');
                    if (81 != Decompiler.getNext(source, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'O': {
                    result.append('[');
                    break;
                }
                case 'P': {
                    result.append(']');
                    break;
                }
                case '\u0001': {
                    int afterName;
                    if (toSource) break;
                    boolean newLine = true;
                    if (!afterFirstEOL) {
                        afterFirstEOL = true;
                        if (justFunctionBody) {
                            result.setLength(0);
                            indent -= indentGap;
                            newLine = false;
                        }
                    }
                    if (newLine) {
                        result.append('\n');
                    }
                    if (i + 1 >= length) break;
                    int less = 0;
                    char nextToken = source.charAt(i + 1);
                    if (nextToken == 'o' || nextToken == 'p') {
                        less = indentGap - caseGap;
                    } else if (nextToken == 'R') {
                        less = indentGap;
                    } else if (nextToken == '&' && source.charAt(afterName = Decompiler.getSourceStringEnd(source, i + 2)) == 'c') {
                        less = indentGap;
                    }
                    while (less < indent) {
                        result.append(' ');
                        ++less;
                    }
                    break;
                }
                case 'h': {
                    result.append('.');
                    break;
                }
                case '\u001e': {
                    result.append("new ");
                    break;
                }
                case '\u001f': {
                    result.append("delete ");
                    break;
                }
                case 'l': {
                    result.append("if ");
                    break;
                }
                case 'm': {
                    result.append("else ");
                    break;
                }
                case 's': {
                    result.append("for ");
                    break;
                }
                case '3': {
                    result.append(" in ");
                    break;
                }
                case 'w': {
                    result.append("with ");
                    break;
                }
                case 'q': {
                    result.append("while ");
                    break;
                }
                case 'r': {
                    result.append("do ");
                    break;
                }
                case 'M': {
                    result.append("try ");
                    break;
                }
                case 'x': {
                    result.append("catch ");
                    break;
                }
                case 'y': {
                    result.append("finally ");
                    break;
                }
                case '1': {
                    result.append("throw ");
                    break;
                }
                case 'n': {
                    result.append("switch ");
                    break;
                }
                case 't': {
                    result.append("break");
                    if (38 != Decompiler.getNext(source, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'u': {
                    result.append("continue");
                    if (38 != Decompiler.getNext(source, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'o': {
                    result.append("case ");
                    break;
                }
                case 'p': {
                    result.append("default");
                    break;
                }
                case '\u0004': {
                    result.append("return");
                    if (78 == Decompiler.getNext(source, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'v': {
                    result.append("var ");
                    break;
                }
                case 'N': {
                    result.append(';');
                    if (1 == Decompiler.getNext(source, length, i)) break;
                    result.append(' ');
                    break;
                }
                case 'V': {
                    result.append(" = ");
                    break;
                }
                case ']': {
                    result.append(" += ");
                    break;
                }
                case '^': {
                    result.append(" -= ");
                    break;
                }
                case '_': {
                    result.append(" *= ");
                    break;
                }
                case '`': {
                    result.append(" /= ");
                    break;
                }
                case 'a': {
                    result.append(" %= ");
                    break;
                }
                case 'W': {
                    result.append(" |= ");
                    break;
                }
                case 'X': {
                    result.append(" ^= ");
                    break;
                }
                case 'Y': {
                    result.append(" &= ");
                    break;
                }
                case 'Z': {
                    result.append(" <<= ");
                    break;
                }
                case '[': {
                    result.append(" >>= ");
                    break;
                }
                case '\\': {
                    result.append(" >>>= ");
                    break;
                }
                case 'b': {
                    result.append(" ? ");
                    break;
                }
                case '@': {
                    result.append(':');
                    break;
                }
                case 'c': {
                    if (1 == Decompiler.getNext(source, length, i)) {
                        result.append(':');
                        break;
                    }
                    result.append(" : ");
                    break;
                }
                case 'd': {
                    result.append(" || ");
                    break;
                }
                case 'e': {
                    result.append(" && ");
                    break;
                }
                case '\t': {
                    result.append(" | ");
                    break;
                }
                case '\n': {
                    result.append(" ^ ");
                    break;
                }
                case '\u000b': {
                    result.append(" & ");
                    break;
                }
                case '-': {
                    result.append(" === ");
                    break;
                }
                case '.': {
                    result.append(" !== ");
                    break;
                }
                case '\f': {
                    result.append(" == ");
                    break;
                }
                case '\r': {
                    result.append(" != ");
                    break;
                }
                case '\u000f': {
                    result.append(" <= ");
                    break;
                }
                case '\u000e': {
                    result.append(" < ");
                    break;
                }
                case '\u0011': {
                    result.append(" >= ");
                    break;
                }
                case '\u0010': {
                    result.append(" > ");
                    break;
                }
                case '4': {
                    result.append(" instanceof ");
                    break;
                }
                case '\u0012': {
                    result.append(" << ");
                    break;
                }
                case '\u0013': {
                    result.append(" >> ");
                    break;
                }
                case '\u0014': {
                    result.append(" >>> ");
                    break;
                }
                case ' ': {
                    result.append("typeof ");
                    break;
                }
                case 'z': {
                    result.append("void ");
                    break;
                }
                case '\u0095': {
                    result.append("const ");
                    break;
                }
                case '\u001a': {
                    result.append('!');
                    break;
                }
                case '\u001b': {
                    result.append('~');
                    break;
                }
                case '\u001c': {
                    result.append('+');
                    break;
                }
                case '\u001d': {
                    result.append('-');
                    break;
                }
                case 'f': {
                    result.append("++");
                    break;
                }
                case 'g': {
                    result.append("--");
                    break;
                }
                case '\u0015': {
                    result.append(" + ");
                    break;
                }
                case '\u0016': {
                    result.append(" - ");
                    break;
                }
                case '\u0017': {
                    result.append(" * ");
                    break;
                }
                case '\u0018': {
                    result.append(" / ");
                    break;
                }
                case '\u0019': {
                    result.append(" % ");
                    break;
                }
                case '\u008c': {
                    result.append("::");
                    break;
                }
                case '\u008b': {
                    result.append("..");
                    break;
                }
                case '\u008e': {
                    result.append(".(");
                    break;
                }
                case '\u008f': {
                    result.append('@');
                    break;
                }
                default: {
                    throw new RuntimeException("Token: " + Token.name(source.charAt(i)));
                }
            }
            ++i;
        }
        if (!toSource) {
            if (!justFunctionBody) {
                result.append('\n');
            }
        } else if (topFunctionType == 2) {
            result.append(')');
        }
        return result.toString();
    }

    private static int getNext(String source, int length, int i) {
        return i + 1 < length ? (int)source.charAt(i + 1) : 0;
    }

    private static int getSourceStringEnd(String source, int offset) {
        return Decompiler.printSourceString(source, offset, false, null);
    }

    private static int printSourceString(String source, int offset, boolean asQuotedString, StringBuffer sb) {
        int length = source.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | source.charAt(offset);
            ++offset;
        }
        if (sb != null) {
            String str = source.substring(offset, offset + length);
            if (!asQuotedString) {
                sb.append(str);
            } else {
                sb.append('\"');
                sb.append(ScriptRuntime.escapeString((String)str));
                sb.append('\"');
            }
        }
        return offset + length;
    }

    private static int printSourceNumber(String source, int offset, StringBuffer sb) {
        double number = 0.0;
        char type = source.charAt(offset);
        ++offset;
        if (type == 'S') {
            if (sb != null) {
                char ival = source.charAt(offset);
                number = ival;
            }
            ++offset;
        } else if (type == 'J' || type == 'D') {
            if (sb != null) {
                long lbits = (long)source.charAt(offset) << 48;
                lbits |= (long)source.charAt(offset + 1) << 32;
                lbits |= (long)source.charAt(offset + 2) << 16;
                number = type == 'J' ? (double)lbits : Double.longBitsToDouble(lbits |= (long)source.charAt(offset + 3));
            }
            offset += 4;
        } else {
            throw new RuntimeException();
        }
        if (sb != null) {
            sb.append(ScriptRuntime.numberToString((double)number, (int)10));
        }
        return offset;
    }
}

