/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.swagger;

import com.google.common.collect.Sets;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.swagger.converter.JsonApiModelResolver;
import com.yahoo.elide.swagger.models.media.Data;
import com.yahoo.elide.swagger.models.media.Datum;
import com.yahoo.elide.swagger.models.media.Relationship;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContextImpl;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.tuple.Pair;

public class OpenApiBuilder {
    protected EntityDictionary dictionary;
    protected Set<com.yahoo.elide.core.type.Type<?>> rootClasses;
    protected Set<com.yahoo.elide.core.type.Type<?>> managedClasses;
    protected OpenAPI openApi;
    protected Map<String, ApiResponse> globalResponses;
    protected Set<Parameter> globalParameters;
    protected Set<Operator> filterOperators;
    protected boolean supportLegacyFilterDialect;
    protected boolean supportRSQLFilterDialect;
    protected String apiVersion = "";
    protected String basePath = null;
    public static final ApiResponse UNAUTHORIZED_RESPONSE = new ApiResponse().description("Unauthorized");
    public static final ApiResponse FORBIDDEN_RESPONSE = new ApiResponse().description("Forbidden");
    public static final ApiResponse NOT_FOUND_RESPONSE = new ApiResponse().description("Not Found");
    public static final ApiResponse REQUEST_TIMEOUT_RESPONSE = new ApiResponse().description("Request Timeout");
    public static final ApiResponse TOO_MANY_REQUESTS_RESPONSE = new ApiResponse().description("Too Many Requests");

    public OpenApiBuilder(EntityDictionary dictionary) {
        this.dictionary = dictionary;
        this.supportLegacyFilterDialect = true;
        this.supportRSQLFilterDialect = true;
        this.globalResponses = new HashMap<String, ApiResponse>();
        this.globalParameters = new HashSet<Parameter>();
        this.managedClasses = new HashSet();
        this.filterOperators = Sets.newHashSet((Object[])new Operator[]{Operator.IN, Operator.NOT, Operator.INFIX, Operator.PREFIX, Operator.POSTFIX, Operator.GE, Operator.GT, Operator.LE, Operator.LT, Operator.ISNULL, Operator.NOTNULL});
        this.openApi = new OpenAPI();
    }

    public OpenApiBuilder globalResponse(String code, ApiResponse response) {
        this.globalResponses.put(code, response);
        return this;
    }

    public OpenApiBuilder supportLegacyFilterDialect(boolean enableLegacyFilterDialect) {
        this.supportLegacyFilterDialect = enableLegacyFilterDialect;
        return this;
    }

    public OpenApiBuilder supportRSQLFilterDialect(boolean enableRSQLFilterDialect) {
        this.supportRSQLFilterDialect = enableRSQLFilterDialect;
        return this;
    }

    public OpenApiBuilder globalParameter(Parameter parameter) {
        this.globalParameters.add(parameter);
        return this;
    }

    public OpenApiBuilder managedClasses(Set<com.yahoo.elide.core.type.Type<?>> classes) {
        this.managedClasses = new HashSet(classes);
        return this;
    }

    public OpenApiBuilder filterOperators(Set<Operator> ops) {
        this.filterOperators = new HashSet<Operator>(ops);
        return this;
    }

    public OpenApiBuilder filterOperators(Consumer<Set<Operator>> customizer) {
        customizer.accept(this.filterOperators);
        return this;
    }

    public OpenApiBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        if (this.apiVersion == null) {
            this.apiVersion = "";
        }
        return this;
    }

    public OpenApiBuilder applyTo(OpenAPI openApi) {
        if (this.managedClasses.isEmpty()) {
            this.managedClasses = this.dictionary.getBoundClassesByVersion(this.apiVersion);
        } else {
            this.managedClasses = Sets.intersection((Set)this.dictionary.getBoundClassesByVersion(this.apiVersion), this.managedClasses);
            if (this.managedClasses.isEmpty()) {
                throw new IllegalArgumentException("None of the provided classes are exported by Elide");
            }
        }
        ModelConverters converters = ModelConverters.getInstance();
        JsonApiModelResolver converter = new JsonApiModelResolver(this.dictionary);
        converters.addConverter((ModelConverter)converter);
        for (com.yahoo.elide.core.type.Type<?> clazz : this.managedClasses) {
            if (clazz instanceof ClassType) {
                ClassType classType = (ClassType)clazz;
                converters.readAll((Type)classType.getCls()).forEach((arg_0, arg_1) -> ((OpenAPI)openApi).schema(arg_0, arg_1));
                continue;
            }
            ModelConverterContextImpl context = new ModelConverterContextImpl(Arrays.asList(new ModelConverter[]{converter}));
            context.resolve(new AnnotatedType().type(clazz));
            context.getDefinedModels().forEach((arg_0, arg_1) -> ((OpenAPI)openApi).schema(arg_0, arg_1));
        }
        this.rootClasses = this.managedClasses.stream().filter(arg_0 -> ((EntityDictionary)this.dictionary).isRoot(arg_0)).collect(Collectors.toSet());
        Sets.SetView pathData = this.rootClasses.stream().map(this::find).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet toRemove = new HashSet();
        pathData.stream().collect(Collectors.groupingBy(p -> Pair.of(p.getType(), (Object)p.getName()))).values().forEach(pathSet -> {
            block0: for (PathMetaData path : pathSet) {
                for (PathMetaData compare : pathSet) {
                    if (compare.lineage.isEmpty() || path == compare || !compare.shorterThan(path)) continue;
                    toRemove.add(path);
                    continue block0;
                }
            }
        });
        pathData = Sets.difference(pathData, toRemove);
        for (PathMetaData pathDatum : pathData) {
            openApi.path(this.pathOf(pathDatum.getCollectionUrl()), pathDatum.getCollectionPath());
            openApi.path(this.pathOf(pathDatum.getUrl()), pathDatum.getInstancePath());
            if (pathDatum.lineage.isEmpty()) continue;
            openApi.path(this.pathOf(pathDatum.getRelationshipUrl()), pathDatum.getRelationshipPath());
        }
        this.managedClasses.stream().map(type -> new Tag().name(this.tagNameOf((com.yahoo.elide.core.type.Type<?>)type)).description(EntityDictionary.getEntityDescription((com.yahoo.elide.core.type.Type)type))).forEach(arg_0 -> ((OpenAPI)openApi).addTagsItem(arg_0));
        return this;
    }

    protected String tagNameOf(com.yahoo.elide.core.type.Type<?> type) {
        Object tagName = this.dictionary.getJsonAliasFor(type);
        if (!"".equals(this.apiVersion)) {
            tagName = "v" + this.apiVersion + "/" + (String)tagName;
        }
        return tagName;
    }

    protected String pathOf(String url) {
        if (this.basePath == null || "/".equals(this.basePath)) {
            return url;
        }
        return this.basePath + url;
    }

    public OpenApiBuilder basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public OpenAPI build() {
        this.applyTo(this.openApi);
        return this.openApi;
    }

    protected Set<PathMetaData> find(com.yahoo.elide.core.type.Type<?> rootClass) {
        ArrayDeque<PathMetaData> toVisit = new ArrayDeque<PathMetaData>();
        HashSet<PathMetaData> paths = new HashSet<PathMetaData>();
        toVisit.add(new PathMetaData(rootClass));
        while (!toVisit.isEmpty()) {
            List relationshipNames;
            PathMetaData current = (PathMetaData)toVisit.remove();
            try {
                relationshipNames = this.dictionary.getRelationships(current.getType());
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            for (String relationshipName : relationshipNames) {
                com.yahoo.elide.core.type.Type relationshipClass = this.dictionary.getParameterizedType(current.getType(), relationshipName);
                PathMetaData next = new PathMetaData(current.getFullLineage(), relationshipName, relationshipClass);
                if (current.lineageContainsType(next) || !this.managedClasses.contains(relationshipClass)) continue;
                toVisit.add(next);
            }
            paths.add(current);
        }
        return paths;
    }

    protected String getSchemaName(com.yahoo.elide.core.type.Type<?> type) {
        Object schemaName = this.dictionary.getJsonAliasFor(type);
        if (!"".equals(this.apiVersion)) {
            schemaName = "v" + this.apiVersion + "_" + (String)schemaName;
        }
        return schemaName;
    }

    protected boolean isNone(String permission) {
        return "Prefab.Role.None".equalsIgnoreCase(permission) || "NONE".equalsIgnoreCase(permission);
    }

    protected boolean canCreate(com.yahoo.elide.core.type.Type<?> type) {
        return !this.isNone(this.getCreatePermission(type));
    }

    protected boolean canRead(com.yahoo.elide.core.type.Type<?> type) {
        return !this.isNone(this.getReadPermission(type));
    }

    protected boolean canUpdate(com.yahoo.elide.core.type.Type<?> type) {
        return !this.isNone(this.getUpdatePermission(type));
    }

    protected boolean canDelete(com.yahoo.elide.core.type.Type<?> type) {
        return !this.isNone(this.getDeletePermission(type));
    }

    protected boolean canReadById(com.yahoo.elide.core.type.Type<?> type) {
        boolean excluded = this.dictionary.getIdAnnotation(type, Exclude.class) != null;
        return !this.isNone(this.getReadPermission(type)) && !excluded;
    }

    protected boolean canUpdateById(com.yahoo.elide.core.type.Type<?> type) {
        boolean excluded = this.dictionary.getIdAnnotation(type, Exclude.class) != null;
        return !this.isNone(this.getUpdatePermission(type)) && !excluded;
    }

    protected boolean canDeleteById(com.yahoo.elide.core.type.Type<?> type) {
        boolean excluded = this.dictionary.getIdAnnotation(type, Exclude.class) != null;
        return !this.isNone(this.getDeletePermission(type)) && !excluded;
    }

    protected boolean canCreate(com.yahoo.elide.core.type.Type<?> type, String field) {
        return !this.isNone(this.getCreatePermission(type, field));
    }

    protected boolean canRead(com.yahoo.elide.core.type.Type<?> type, String field) {
        return !this.isNone(this.getReadPermission(type, field));
    }

    protected boolean canUpdate(com.yahoo.elide.core.type.Type<?> type, String field) {
        return !this.isNone(this.getUpdatePermission(type, field));
    }

    protected boolean canDelete(com.yahoo.elide.core.type.Type<?> type, String field) {
        return !this.isNone(this.getDeletePermission(type, field));
    }

    protected String getCreatePermission(com.yahoo.elide.core.type.Type<?> clazz) {
        return this.getPermission(clazz, CreatePermission.class);
    }

    protected String getReadPermission(com.yahoo.elide.core.type.Type<?> clazz) {
        return this.getPermission(clazz, ReadPermission.class);
    }

    protected String getUpdatePermission(com.yahoo.elide.core.type.Type<?> clazz) {
        return this.getPermission(clazz, UpdatePermission.class);
    }

    protected String getDeletePermission(com.yahoo.elide.core.type.Type<?> clazz) {
        return this.getPermission(clazz, DeletePermission.class);
    }

    protected String getCreatePermission(com.yahoo.elide.core.type.Type<?> clazz, String field) {
        return this.getPermission(clazz, field, CreatePermission.class);
    }

    protected String getReadPermission(com.yahoo.elide.core.type.Type<?> clazz, String field) {
        return this.getPermission(clazz, field, ReadPermission.class);
    }

    protected String getUpdatePermission(com.yahoo.elide.core.type.Type<?> clazz, String field) {
        return this.getPermission(clazz, field, UpdatePermission.class);
    }

    protected String getDeletePermission(com.yahoo.elide.core.type.Type<?> clazz, String field) {
        return this.getPermission(clazz, field, DeletePermission.class);
    }

    protected String getPermission(com.yahoo.elide.core.type.Type<?> clazz, Class<? extends Annotation> permission) {
        ParseTree parseTree = this.dictionary.getPermissionsForClass(clazz, permission);
        if (parseTree != null) {
            return parseTree.getText();
        }
        return null;
    }

    protected String getPermission(com.yahoo.elide.core.type.Type<?> clazz, String field, Class<? extends Annotation> permission) {
        ParseTree parseTree = this.dictionary.getPermissionsForField(clazz, field, permission);
        if (parseTree != null) {
            return parseTree.getText();
        }
        return null;
    }

    public class PathMetaData {
        private Stack<PathMetaData> lineage;
        private String name;
        private com.yahoo.elide.core.type.Type<?> type;
        private String url;

        public PathMetaData(com.yahoo.elide.core.type.Type<?> type) {
            this(new Stack<PathMetaData>(), this$0.dictionary.getJsonAliasFor(type), type);
        }

        public PathMetaData(Stack<PathMetaData> lineage, String name, com.yahoo.elide.core.type.Type<?> type) {
            this.lineage = lineage;
            this.type = type;
            this.name = name;
            this.url = this.constructInstanceUrl();
        }

        public com.yahoo.elide.core.type.Type<?> getRootType() {
            if (this.lineage.isEmpty()) {
                return this.type;
            }
            return ((PathMetaData)this.lineage.elementAt((int)0)).type;
        }

        public String getCollectionUrl() {
            if (this.lineage.isEmpty()) {
                return "/" + this.name;
            }
            return this.lineage.peek().getUrl() + "/" + this.name;
        }

        private String constructInstanceUrl() {
            String typeName = OpenApiBuilder.this.dictionary.getJsonAliasFor(this.type);
            return this.getCollectionUrl() + "/{" + typeName + "Id}";
        }

        public String getRelationshipUrl() {
            if (this.lineage.isEmpty()) {
                throw new IllegalStateException("Root collections don't have relationships");
            }
            PathMetaData prior = this.lineage.peek();
            String baseUrl = prior.getUrl();
            return baseUrl + "/relationships/" + this.name;
        }

        public String toString() {
            return this.getUrl();
        }

        private String getTag() {
            return OpenApiBuilder.this.tagNameOf(this.type);
        }

        private List<String> getTags() {
            return Collections.singletonList(this.getTag());
        }

        private Parameter getPathParameter() {
            String typeName = OpenApiBuilder.this.dictionary.getJsonAliasFor(this.type);
            return new PathParameter().name(typeName + "Id").description(typeName + " Identifier").schema((Schema)new StringSchema());
        }

        public PathItem getRelationshipPath() {
            if (this.lineage.isEmpty()) {
                throw new IllegalStateException("Root collections don't have relationships");
            }
            PathItem path = new PathItem();
            this.lineage.stream().forEach(item -> path.addParametersItem(item.getPathParameter()));
            String schemaName = OpenApiBuilder.this.getSchemaName(this.type);
            ApiResponse okSingularResponse = new ApiResponse().description("Successful response").content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Datum(new Relationship(schemaName)))));
            ApiResponse okPluralResponse = new ApiResponse().description("Successful response").content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Data(new Relationship(schemaName)))));
            ApiResponse okEmptyResponse = new ApiResponse().description("Successful response");
            com.yahoo.elide.core.type.Type<?> parentClass = this.lineage.peek().getType();
            RelationshipType relationshipType = OpenApiBuilder.this.dictionary.getRelationshipType(parentClass, this.name);
            if (relationshipType.isToMany()) {
                if (OpenApiBuilder.this.canRead(parentClass, this.name) && OpenApiBuilder.this.canRead(this.type)) {
                    path.get(new Operation().tags(this.getTags()).description("Returns the relationship identifiers for " + this.name).responses(new ApiResponses().addApiResponse("200", okPluralResponse)));
                }
                if (OpenApiBuilder.this.canUpdate(parentClass, this.name)) {
                    path.post(new Operation().tags(this.getTags()).description("Adds items to the relationship " + this.name).requestBody(new RequestBody().content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Data(new Relationship(schemaName)))))).responses(new ApiResponses().addApiResponse("201", okPluralResponse)));
                    path.patch(new Operation().tags(this.getTags()).description("Replaces the relationship " + this.name).requestBody(new RequestBody().content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Data(new Relationship(schemaName)))))).responses(new ApiResponses().addApiResponse("204", okEmptyResponse)));
                    path.delete(new Operation().tags(this.getTags()).description("Deletes items from the relationship " + this.name).requestBody(new RequestBody().content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Data(new Relationship(schemaName)))))).responses(new ApiResponses().addApiResponse("204", okEmptyResponse)));
                }
            } else {
                if (OpenApiBuilder.this.canRead(parentClass, this.name) && OpenApiBuilder.this.canRead(this.type)) {
                    path.get(new Operation().tags(this.getTags()).description("Returns the relationship identifiers for " + this.name).responses(new ApiResponses().addApiResponse("200", okSingularResponse)));
                }
                if (OpenApiBuilder.this.canUpdate(parentClass, this.name)) {
                    path.patch(new Operation().tags(this.getTags()).description("Replaces the relationship " + this.name).requestBody(new RequestBody().content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Datum(new Relationship(schemaName)))))).responses(new ApiResponses().addApiResponse("204", okEmptyResponse)));
                }
            }
            if (path.getGet() != null) {
                for (Parameter param : this.getFilterParameters()) {
                    path.getGet().addParametersItem(param);
                }
                for (Parameter param : this.getPageParameters()) {
                    path.getGet().addParametersItem(param);
                }
            }
            this.decorateGlobalResponses(path);
            this.decorateGlobalParameters(path);
            return path;
        }

        public PathItem getCollectionPath() {
            String postDescription;
            String getDescription;
            String typeName = OpenApiBuilder.this.dictionary.getJsonAliasFor(this.type);
            String schemaName = OpenApiBuilder.this.getSchemaName(this.type);
            PathItem path = new PathItem();
            this.lineage.stream().forEach(item -> path.addParametersItem(item.getPathParameter()));
            ApiResponse okSingularResponse = new ApiResponse().description("Successful response").content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Datum(schemaName))));
            ApiResponse okPluralResponse = new ApiResponse().description("Successful response").content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Data(schemaName))));
            boolean canPost = false;
            boolean canGet = false;
            if (this.lineage.isEmpty()) {
                getDescription = "Returns the collection of type " + typeName;
                postDescription = "Creates an item of type " + typeName;
                canGet = OpenApiBuilder.this.canRead(this.type);
                canPost = OpenApiBuilder.this.canCreate(this.type);
            } else {
                getDescription = "Returns the relationship " + this.name;
                postDescription = "Creates an item of type " + typeName + " and adds it to " + this.name;
                com.yahoo.elide.core.type.Type<?> parentClass = this.lineage.peek().getType();
                canGet = OpenApiBuilder.this.canRead(parentClass, this.name) && OpenApiBuilder.this.canRead(this.type);
                canPost = OpenApiBuilder.this.canUpdate(parentClass, this.name) && OpenApiBuilder.this.canCreate(this.type);
            }
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            parameters.add(this.getSortParameter());
            parameters.add(this.getSparseFieldsParameter());
            this.getIncludeParameter().ifPresent(parameters::add);
            if (canPost) {
                path.post(new Operation().tags(this.getTags()).description(postDescription).requestBody(new RequestBody().content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Datum(schemaName))))).responses(new ApiResponses().addApiResponse("201", okSingularResponse)));
            }
            if (canGet) {
                path.get(new Operation().tags(this.getTags()).description(getDescription).parameters(parameters).responses(new ApiResponses().addApiResponse("200", okPluralResponse)));
                for (Parameter param : this.getFilterParameters()) {
                    path.getGet().addParametersItem(param);
                }
                for (Parameter param : this.getPageParameters()) {
                    path.getGet().addParametersItem(param);
                }
            }
            this.decorateGlobalResponses(path);
            this.decorateGlobalParameters(path);
            return path;
        }

        public PathItem getInstancePath() {
            String typeName = OpenApiBuilder.this.dictionary.getJsonAliasFor(this.type);
            String schemaName = OpenApiBuilder.this.getSchemaName(this.type);
            PathItem path = new PathItem();
            this.getFullLineage().stream().forEach(item -> path.addParametersItem(item.getPathParameter()));
            ApiResponse okSingularResponse = new ApiResponse().description("Successful response").content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Datum(schemaName))));
            ApiResponse okEmptyResponse = new ApiResponse().description("Successful response");
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            parameters.add(this.getSparseFieldsParameter());
            this.getIncludeParameter().ifPresent(parameters::add);
            boolean canGet = false;
            boolean canPatch = false;
            boolean canDelete = false;
            if (this.lineage.isEmpty()) {
                canGet = OpenApiBuilder.this.canReadById(this.type);
                canPatch = OpenApiBuilder.this.canUpdateById(this.type);
                canDelete = OpenApiBuilder.this.canDeleteById(this.type);
            } else {
                com.yahoo.elide.core.type.Type<?> parentClass = this.lineage.peek().getType();
                canGet = OpenApiBuilder.this.canRead(parentClass, this.name) && OpenApiBuilder.this.canReadById(this.type);
                canPatch = OpenApiBuilder.this.canUpdate(parentClass, this.name);
                canDelete = OpenApiBuilder.this.canUpdate(parentClass, this.name);
            }
            if (canGet) {
                path.get(new Operation().tags(this.getTags()).description("Returns an instance of type " + typeName).parameters(parameters).responses(new ApiResponses().addApiResponse("200", okSingularResponse)));
            }
            if (canPatch) {
                path.patch(new Operation().tags(this.getTags()).description("Modifies an instance of type " + typeName).requestBody(new RequestBody().content(new Content().addMediaType("application/vnd.api+json", new MediaType().schema((Schema)new Datum(schemaName))))).responses(new ApiResponses().addApiResponse("204", okEmptyResponse)));
            }
            if (canDelete) {
                path.delete(new Operation().tags(this.getTags()).description("Deletes an instance of type " + typeName).responses(new ApiResponses().addApiResponse("204", okEmptyResponse)));
            }
            this.decorateGlobalResponses(path);
            this.decorateGlobalParameters(path);
            return path;
        }

        private PathItem decorateGlobalParameters(PathItem path) {
            OpenApiBuilder.this.globalParameters.forEach(arg_0 -> ((PathItem)path).addParametersItem(arg_0));
            return path;
        }

        private PathItem decorateGlobalResponses(PathItem path) {
            OpenApiBuilder.this.globalResponses.forEach((code, response) -> {
                if (path.getGet() != null) {
                    path.getGet().getResponses().addApiResponse(code, response);
                }
                if (path.getDelete() != null) {
                    path.getDelete().getResponses().addApiResponse(code, response);
                }
                if (path.getPost() != null) {
                    path.getPost().getResponses().addApiResponse(code, response);
                }
                if (path.getPatch() != null) {
                    path.getPatch().getResponses().addApiResponse(code, response);
                }
            });
            return path;
        }

        private Parameter getSparseFieldsParameter() {
            String typeName = OpenApiBuilder.this.dictionary.getJsonAliasFor(this.type);
            List fieldNames = OpenApiBuilder.this.dictionary.getAllExposedFields(this.type);
            return new QueryParameter().schema((Schema)new ArraySchema().items((Schema)new StringSchema()._enum(fieldNames))).name("fields[" + typeName + "]").description("Selects the set of " + typeName + " fields that should be returned in the result.").style(Parameter.StyleEnum.FORM).explode(Boolean.valueOf(false));
        }

        private Optional<Parameter> getIncludeParameter() {
            List relationshipNames = OpenApiBuilder.this.dictionary.getRelationships(this.type);
            if (relationshipNames.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new QueryParameter().schema((Schema)new ArraySchema().items((Schema)new StringSchema()._enum(relationshipNames))).name("include").description("Selects the set of relationships that should be expanded as a compound document in the result.").style(Parameter.StyleEnum.FORM).explode(Boolean.valueOf(false)));
        }

        private List<Parameter> getPageParameters() {
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            params.add(new QueryParameter().name("page[number]").description("Number of pages to return.  Can be used with page[size]").schema((Schema)new IntegerSchema()));
            params.add(new QueryParameter().name("page[size]").description("Number of elements per page.  Can be used with page[number]").schema((Schema)new IntegerSchema()));
            params.add(new QueryParameter().name("page[offset]").description("Offset from 0 to start paginating.  Can be used with page[limit]").schema((Schema)new IntegerSchema()));
            params.add(new QueryParameter().name("page[limit]").description("Maximum number of items to return.  Can be used with page[offset]").schema((Schema)new IntegerSchema()));
            params.add(new QueryParameter().name("page[totals]").description("For requesting total pages/records be included in the response page meta data").schema((Schema)new StringSchema()));
            return params;
        }

        private Parameter getSortParameter() {
            List filterAttributes = OpenApiBuilder.this.dictionary.getAttributes(this.type).stream().filter(name -> {
                com.yahoo.elide.core.type.Type attributeClass = OpenApiBuilder.this.dictionary.getType(this.type, name);
                return attributeClass.isPrimitive() || ClassType.STRING_TYPE.isAssignableFrom(attributeClass);
            }).map(name -> Arrays.asList(name, "-" + name)).flatMap(Collection::stream).collect(Collectors.toList());
            filterAttributes.add("id");
            filterAttributes.add("-id");
            return new QueryParameter().name("sort").schema((Schema)new ArraySchema().items((Schema)new StringSchema()._enum(filterAttributes))).description("Sorts the collection on the selected attributes.  A prefix of '-' sorts descending").style(Parameter.StyleEnum.FORM).explode(Boolean.valueOf(false));
        }

        private List<Parameter> getFilterParameters() {
            String typeName = OpenApiBuilder.this.dictionary.getJsonAliasFor(this.type);
            List attributeNames = OpenApiBuilder.this.dictionary.getAttributes(this.type);
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            if (OpenApiBuilder.this.supportRSQLFilterDialect) {
                params.add(new QueryParameter().schema((Schema)new StringSchema()).name("filter[" + typeName + "]").description("Filters the collection of " + typeName + " using a 'disjoint' RSQL expression"));
                if (this.lineage.isEmpty()) {
                    params.add(new QueryParameter().schema((Schema)new StringSchema()).name("filter").description("Filters the collection of " + typeName + " using a 'joined' RSQL expression"));
                }
            }
            if (OpenApiBuilder.this.supportLegacyFilterDialect) {
                for (Operator op : OpenApiBuilder.this.filterOperators) {
                    attributeNames.forEach(name -> {
                        com.yahoo.elide.core.type.Type attributeClass = OpenApiBuilder.this.dictionary.getType(this.type, name);
                        if (attributeClass.isPrimitive() || ClassType.STRING_TYPE.isAssignableFrom(attributeClass)) {
                            params.add(new QueryParameter().schema((Schema)new StringSchema()).name("filter[" + typeName + "." + name + "][" + op.getNotation() + "]").description("Filters the collection of " + typeName + " by the attribute " + name + " using the operator " + op.getNotation()));
                        }
                    });
                }
            }
            return params;
        }

        public Stack<PathMetaData> getFullLineage() {
            Stack<PathMetaData> fullLineage = new Stack<PathMetaData>();
            fullLineage.addAll(this.lineage);
            fullLineage.add(this);
            return fullLineage;
        }

        public boolean shorterThan(PathMetaData compare) {
            return this.url.split("/").length < compare.getUrl().split("/").length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PathMetaData)) {
                return false;
            }
            PathMetaData that = (PathMetaData)o;
            return this.url.equals(that.getUrl());
        }

        public int hashCode() {
            return Objects.hash(this.lineage, this.name, this.type);
        }

        private boolean lineageContainsType(PathMetaData other) {
            if (this.type.equals(other.type)) {
                return true;
            }
            if (this.lineage.isEmpty()) {
                return false;
            }
            for (PathMetaData compare : this.lineage) {
                if (!compare.type.equals(other.type)) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public com.yahoo.elide.core.type.Type<?> getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

