/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.orm.jpa.config;

import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.datastores.jpa.JpaDataStore;
import com.yahoo.elide.datastores.jpql.porting.QueryLogger;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.orm.jpa.EntityManagerProxySupplier;
import com.yahoo.elide.spring.orm.jpa.PlatformJpaTransactionSupplier;
import com.yahoo.elide.spring.orm.jpa.config.JpaDataStoreRegistration;
import jakarta.persistence.EntityManagerFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class JpaDataStoreRegistrations {
    private JpaDataStoreRegistrations() {
    }

    public static JpaDataStoreRegistration buildJpaDataStoreRegistration(String entityManagerFactoryName, EntityManagerFactory entityManagerFactory, String platformTransactionManagerName, PlatformTransactionManager platformTransactionManager, ElideConfigProperties settings, Optional<QueryLogger> optionalQueryLogger, Class<?>[] managedClasses) {
        DefaultTransactionDefinition writeJpaTransactionDefinition = new DefaultTransactionDefinition(0);
        writeJpaTransactionDefinition.setName("Elide Write Transaction (" + entityManagerFactoryName + "," + platformTransactionManagerName + ")");
        JpaDataStore.JpaTransactionSupplier writeJpaTransactionSupplier = JpaDataStoreRegistrations.buildJpaTransactionSupplier(platformTransactionManager, entityManagerFactory, (TransactionDefinition)writeJpaTransactionDefinition, settings);
        DefaultTransactionDefinition readJpaTransactionDefinition = new DefaultTransactionDefinition(0);
        readJpaTransactionDefinition.setName("Elide Read Transaction (" + entityManagerFactoryName + "," + platformTransactionManagerName + ")");
        readJpaTransactionDefinition.setReadOnly(true);
        JpaDataStore.JpaTransactionSupplier readJpaTransactionSupplier = JpaDataStoreRegistrations.buildJpaTransactionSupplier(platformTransactionManager, entityManagerFactory, (TransactionDefinition)readJpaTransactionDefinition, settings);
        JpaDataStoreRegistration.JpaDataStoreRegistrationBuilder builder = JpaDataStoreRegistration.builder().name(entityManagerFactoryName).entityManagerSupplier(JpaDataStoreRegistrations.buildEntityManagerSupplier()).readTransactionSupplier(readJpaTransactionSupplier).writeTransactionSupplier(writeJpaTransactionSupplier).queryLogger(optionalQueryLogger.orElse(JpaDataStore.DEFAULT_LOGGER));
        if (managedClasses != null && managedClasses.length > 0) {
            HashSet models = new HashSet();
            Arrays.stream(managedClasses).map(ClassType::of).forEach(models::add);
            builder.managedClasses(models);
        } else {
            builder.metamodelSupplier(() -> ((EntityManagerFactory)entityManagerFactory).getMetamodel());
        }
        return builder.build();
    }

    public static JpaDataStore.JpaTransactionSupplier buildJpaTransactionSupplier(PlatformTransactionManager transactionManager, EntityManagerFactory entityManagerFactory, TransactionDefinition transactionDefinition, ElideConfigProperties settings) {
        return new PlatformJpaTransactionSupplier(transactionDefinition, transactionManager, entityManagerFactory, settings.getJpaStore().isDelegateToInMemoryStore());
    }

    public static JpaDataStore.EntityManagerSupplier buildEntityManagerSupplier() {
        return new EntityManagerProxySupplier();
    }
}

