/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.datastore.config;

import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.datastores.multiplex.MultiplexManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class DataStoreBuilder {
    private final List<DataStore> dataStores = new ArrayList<DataStore>();
    private Function<DataStore[], DataStore> multiplexer = MultiplexManager::new;

    public DataStoreBuilder dataStores(List<DataStore> dataStores) {
        this.dataStores.clear();
        this.dataStores.addAll(dataStores);
        return this;
    }

    public DataStoreBuilder dataStores(Consumer<List<DataStore>> customizer) {
        customizer.accept(this.dataStores);
        return this;
    }

    public DataStoreBuilder dataStore(DataStore dataStore) {
        this.dataStores.add(dataStore);
        return this;
    }

    public DataStoreBuilder multiplexer(Function<DataStore[], DataStore> multiplexer) {
        this.multiplexer = Objects.requireNonNull(multiplexer, "Multiplexer cannot be null");
        return this;
    }

    public DataStore build() {
        if (this.dataStores.isEmpty()) {
            return null;
        }
        if (this.dataStores.size() == 1) {
            return this.dataStores.get(0);
        }
        return this.multiplexer.apply((DataStore[])this.dataStores.toArray(DataStore[]::new));
    }
}

