/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.controllers;

import com.yahoo.elide.Elide;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.exceptions.InvalidApiVersionException;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.graphql.QueryRunners;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import com.yahoo.elide.spring.security.AuthenticationUser;
import com.yahoo.elide.utils.HeaderProcessor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"${elide.graphql.path}"})
public class GraphqlController {
    private static final Logger log = LoggerFactory.getLogger(GraphqlController.class);
    private final Elide elide;
    private final ElideConfigProperties settings;
    private final QueryRunners runners;
    private final HeaderProcessor headerProcessor;
    private final RouteResolver routeResolver;
    private static final String JSON_CONTENT_TYPE = "application/json";

    public GraphqlController(Elide elide, QueryRunners runners, HeaderProcessor headerProcessor, ElideConfigProperties settings, RouteResolver routeResolver) {
        log.debug("Started ~~");
        this.elide = elide;
        this.runners = runners;
        this.settings = settings;
        this.headerProcessor = headerProcessor;
        this.routeResolver = routeResolver;
    }

    @PostMapping(value={"/**", ""}, consumes={"application/json"}, produces={"application/json"})
    public Callable<ResponseEntity<String>> post(@RequestHeader HttpHeaders requestHeaders, @RequestParam MultiValueMap<String, String> allRequestParams, final @RequestBody String graphQLDocument, HttpServletRequest request, Authentication principal) {
        final AuthenticationUser user = new AuthenticationUser(principal);
        final Map requestHeadersCleaned = this.headerProcessor.process((Map)requestHeaders);
        String prefix = this.settings.getGraphql().getPath();
        String baseUrl = this.getBaseUrl(prefix);
        String pathname = this.getPath(request, prefix);
        final Route route = this.routeResolver.resolve(JSON_CONTENT_TYPE, baseUrl, pathname, (Map)requestHeaders, allRequestParams);
        final QueryRunner runner = this.runners.getRunner(route.getApiVersion());
        return new Callable<ResponseEntity<String>>(){

            @Override
            public ResponseEntity<String> call() throws Exception {
                ElideResponse response = runner == null ? QueryRunner.handleRuntimeException((Elide)GraphqlController.this.elide, (RuntimeException)new InvalidApiVersionException("Invalid API Version")) : runner.run(route.getBaseUrl(), graphQLDocument, user, UUID.randomUUID(), requestHeadersCleaned);
                return ResponseEntity.status((int)response.getStatus()).body((Object)((String)response.getBody()));
            }
        };
    }

    private String getPath(HttpServletRequest request, String prefix) {
        String pathname = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return pathname.replaceFirst(prefix, "");
    }

    protected String getBaseUrl(String prefix) {
        Object baseUrl = this.settings.getBaseUrl();
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = ServletUriComponentsBuilder.fromCurrentContextPath().build().toUriString();
        }
        if (prefix.length() > 1) {
            baseUrl = ((String)baseUrl).endsWith("/") ? ((String)baseUrl).substring(0, ((String)baseUrl).length() - 1) + prefix : (String)baseUrl + prefix;
        }
        return baseUrl;
    }
}

