/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.controllers;

import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import io.reactivex.Observable;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"${elide.async.export.path:/export}"})
public class ExportController {
    private static final Logger log = LoggerFactory.getLogger(ExportController.class);
    private ResultStorageEngine resultStorageEngine;

    public ExportController(ResultStorageEngine resultStorageEngine) {
        log.debug("Started ~~");
        this.resultStorageEngine = resultStorageEngine;
    }

    @GetMapping(path={"/{asyncQueryId}"})
    public ResponseEntity<StreamingResponseBody> export(@PathVariable String asyncQueryId, HttpServletResponse response) {
        Observable observableResults = this.resultStorageEngine.getResultsByID(asyncQueryId);
        StreamingResponseBody streamingOutput = outputStream -> observableResults.subscribe(resultString -> outputStream.write(resultString.concat(System.lineSeparator()).getBytes()), error -> {
            String message = error.getMessage();
            try {
                log.debug(message);
                if (message != null && message.equals("Unable to retrieve results.")) {
                    response.sendError(404, asyncQueryId + "not found");
                } else {
                    response.sendError(500);
                }
            }
            catch (IOException | IllegalStateException e) {
                outputStream.write("Error Occured....".concat(System.lineSeparator()).getBytes());
                log.debug(e.getMessage());
            }
            finally {
                outputStream.flush();
                outputStream.close();
            }
        }, () -> {
            outputStream.flush();
            outputStream.close();
        });
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + asyncQueryId})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)streamingOutput);
    }
}

