/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.Elide;
import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.graphql.subscriptions.hooks.SubscriptionScanner;
import jakarta.jms.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnProperty(name={"elide.graphql.enabled"}, havingValue="true")
@ConditionalOnExpression(value="${elide.graphql.subscription.enabled:false} && ${elide.graphql.subscription.publishing.enabled:true}")
public class ElideSubscriptionScanningConfiguration {
    private RefreshableElide refreshableElide;
    private ConnectionFactory connectionFactory;

    public ElideSubscriptionScanningConfiguration(RefreshableElide refreshableElide, ConnectionFactory connectionFactory) {
        this.refreshableElide = refreshableElide;
        this.connectionFactory = connectionFactory;
    }

    @EventListener(value={ContextRefreshedEvent.class, RefreshScopeRefreshedEvent.class})
    public void onStartOrRefresh(ApplicationEvent event) {
        Elide elide = this.refreshableElide.getElide();
        SubscriptionScanner scanner = SubscriptionScanner.builder().deliveryDelay(0L).messagePriority(4).timeToLive(0L).deliveryMode(2).scanner(elide.getScanner()).entityDictionary(elide.getElideSettings().getEntityDictionary()).connectionFactory(this.connectionFactory).build();
        scanner.bindLifecycleHooks();
    }
}

