/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.ElideMapper;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.ElideSettingsBuilderCustomizer;
import com.yahoo.elide.Serdes;
import com.yahoo.elide.Settings;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.request.route.RouteResolver;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.datastores.jms.websocket.SubscriptionWebSocketConfigurator;
import com.yahoo.elide.datastores.jms.websocket.SubscriptionWebSocketConfiguratorBuilderCustomizer;
import com.yahoo.elide.graphql.subscriptions.websocket.SubscriptionWebSocket;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import graphql.execution.DataFetcherExceptionHandler;
import jakarta.jms.ConnectionFactory;
import jakarta.websocket.server.ServerEndpointConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@ConditionalOnProperty(name={"elide.graphql.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ElideConfigProperties.class})
public class ElideSubscriptionConfiguration {
    @Bean
    @ConditionalOnProperty(name={"elide.graphql.subscription.enabled"}, havingValue="true")
    ServerEndpointConfig serverEndpointConfig(ElideConfigProperties config, SubscriptionWebSocketConfigurator.SubscriptionWebSocketConfiguratorBuilder builder) {
        String path = config.getGraphql().getSubscription().getPath();
        return ServerEndpointConfig.Builder.create(SubscriptionWebSocket.class, (String)path).subprotocols(SubscriptionWebSocket.SUPPORTED_WEBSOCKET_SUBPROTOCOLS).configurator((ServerEndpointConfig.Configurator)builder.build()).build();
    }

    @Bean
    @ConditionalOnProperty(name={"elide.graphql.subscription.enabled"}, havingValue="true")
    ServerEndpointConfig serverEndpointConfigPath(ElideConfigProperties config, SubscriptionWebSocketConfigurator.SubscriptionWebSocketConfiguratorBuilder builder) {
        Object path = config.getGraphql().getSubscription().getPath();
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        path = (String)path + "{path}";
        return ServerEndpointConfig.Builder.create(SubscriptionWebSocket.class, (String)path).subprotocols(SubscriptionWebSocket.SUPPORTED_WEBSOCKET_SUBPROTOCOLS).configurator((ServerEndpointConfig.Configurator)builder.build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.graphql.subscription.enabled"}, havingValue="true")
    @Scope(value="prototype")
    SubscriptionWebSocketConfigurator.SubscriptionWebSocketConfiguratorBuilder subscriptionWebSocketConfiguratorBuilder(ElideConfigProperties config, SubscriptionWebSocket.UserFactory userFactory, ConnectionFactory connectionFactory, DataFetcherExceptionHandler dataFetcherExceptionHandler, RouteResolver routeResolver, ObjectProvider<SubscriptionWebSocketConfiguratorBuilderCustomizer> customizers, Injector injector, Serdes.SerdesBuilder serdesBuilder, ElideMapper elideMapper, AuditLogger auditLogger, ObjectProvider<Settings.SettingsBuilder> settingsProvider, ObjectProvider<ElideSettingsBuilderCustomizer> customizerProvider) {
        SubscriptionWebSocketConfigurator.SubscriptionWebSocketConfiguratorBuilder builder = SubscriptionWebSocketConfigurator.builder().baseUrl(config.getGraphql().getSubscription().getPath()).sendPingOnSubscribe(config.getGraphql().getSubscription().isSendPingOnSubscribe()).connectionTimeout(config.getGraphql().getSubscription().getConnectionTimeout()).maxSubscriptions(config.getGraphql().getSubscription().maxSubscriptions).maxMessageSize(config.getGraphql().getSubscription().maxMessageSize).maxIdleTimeout(config.getGraphql().getSubscription().getIdleTimeout()).connectionFactory(connectionFactory).userFactory(userFactory).elideSettingsBuilderCustomizer(elideSettingsBuilder -> {
            ((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)((ElideSettings.ElideSettingsBuilder)elideSettingsBuilder.serdes(serdes -> serdes.entries(entries -> {
                entries.clear();
                serdesBuilder.build().entrySet().stream().forEach(entry -> entries.put((Class)entry.getKey(), (Serde)entry.getValue()));
            }))).objectMapper(elideMapper.getObjectMapper())).auditLogger(auditLogger)).verboseErrors(config.isVerboseErrors())).maxPageSize(config.getMaxPageSize())).defaultPageSize(config.getDefaultPageSize());
            settingsProvider.orderedStream().forEach(xva$0 -> {
                ElideSettings.ElideSettingsBuilder cfr_ignored_0 = (ElideSettings.ElideSettingsBuilder)elideSettingsBuilder.settings(new Settings.SettingsBuilder[]{xva$0});
            });
            customizerProvider.orderedStream().forEach(customizer -> customizer.customize(elideSettingsBuilder));
        }).dataFetcherExceptionHandler(dataFetcherExceptionHandler).routeResolver(routeResolver).injector(injector);
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.graphql.subscription.enabled"}, havingValue="true")
    ServerEndpointExporter serverEndpointExporter() {
        ServerEndpointExporter exporter = new ServerEndpointExporter();
        return exporter;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"elide.graphql.subscription.enabled"}, havingValue="true")
    SubscriptionWebSocket.UserFactory userFactory() {
        return SubscriptionWebSocket.DEFAULT_USER_FACTORY;
    }
}

