/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.spring.config;

import com.yahoo.elide.Elide;
import com.yahoo.elide.RefreshableElide;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.async.export.formatter.CsvExportFormatter;
import com.yahoo.elide.async.export.formatter.JsonExportFormatter;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.hooks.AsyncQueryHook;
import com.yahoo.elide.async.hooks.TableExportHook;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.ResultType;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.service.AsyncCleanerService;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.async.service.dao.AsyncApiDao;
import com.yahoo.elide.async.service.dao.DefaultAsyncApiDao;
import com.yahoo.elide.async.service.storageengine.FileResultStorageEngine;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import com.yahoo.elide.spring.config.AsyncProperties;
import com.yahoo.elide.spring.config.ElideAutoConfiguration;
import com.yahoo.elide.spring.config.ElideConfigProperties;
import graphql.execution.DataFetcherExceptionHandler;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EntityScan(basePackageClasses={AsyncQuery.class})
@EnableConfigurationProperties(value={ElideConfigProperties.class})
@ConditionalOnExpression(value="${elide.async.enabled:false}")
public class ElideAsyncConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AsyncExecutorService asyncExecutorService(RefreshableElide elide, ElideConfigProperties settings, AsyncApiDao asyncQueryDao, Optional<ResultStorageEngine> optionalResultStorageEngine, Optional<DataFetcherExceptionHandler> optionalDataFetcherExceptionHandler) {
        AsyncProperties asyncProperties = settings.getAsync();
        ExecutorService executor = Executors.newFixedThreadPool(asyncProperties.getThreadPoolSize());
        ExecutorService updater = Executors.newFixedThreadPool(asyncProperties.getThreadPoolSize());
        AsyncExecutorService asyncExecutorService = new AsyncExecutorService(elide.getElide(), executor, updater, asyncQueryDao, optionalDataFetcherExceptionHandler);
        AsyncQueryHook asyncQueryHook = new AsyncQueryHook(asyncExecutorService, asyncProperties.getMaxAsyncAfter());
        EntityDictionary dictionary = elide.getElide().getElideSettings().getEntityDictionary();
        dictionary.bindTrigger(AsyncQuery.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PREFLUSH, (LifeCycleHook)asyncQueryHook, false);
        dictionary.bindTrigger(AsyncQuery.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, (LifeCycleHook)asyncQueryHook, false);
        dictionary.bindTrigger(AsyncQuery.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PRESECURITY, (LifeCycleHook)asyncQueryHook, false);
        boolean exportEnabled = ElideAutoConfiguration.isExportEnabled(asyncProperties);
        if (exportEnabled) {
            boolean writeCSVHeader = asyncProperties.getExport() != null && asyncProperties.getExport().getFormat().getCsv().isWriteHeader();
            HashMap<ResultType, TableExportFormatter> supportedFormatters = new HashMap<ResultType, TableExportFormatter>();
            supportedFormatters.put(ResultType.CSV, (TableExportFormatter)new CsvExportFormatter(elide.getElide(), writeCSVHeader));
            supportedFormatters.put(ResultType.JSON, (TableExportFormatter)new JsonExportFormatter(elide.getElide()));
            TableExportHook tableExportHook = this.getTableExportHook(asyncExecutorService, settings, supportedFormatters, optionalResultStorageEngine.orElse(null));
            dictionary.bindTrigger(TableExport.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PREFLUSH, (LifeCycleHook)tableExportHook, false);
            dictionary.bindTrigger(TableExport.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT, (LifeCycleHook)tableExportHook, false);
            dictionary.bindTrigger(TableExport.class, LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PRESECURITY, (LifeCycleHook)tableExportHook, false);
        }
        return asyncExecutorService;
    }

    private TableExportHook getTableExportHook(AsyncExecutorService asyncExecutorService, ElideConfigProperties settings, Map<ResultType, TableExportFormatter> supportedFormatters, ResultStorageEngine resultStorageEngine) {
        return new TableExportHook(asyncExecutorService, settings.getAsync().getMaxAsyncAfter(), supportedFormatters, resultStorageEngine);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="elide.async.cleanup", name={"enabled"}, matchIfMissing=false)
    public AsyncCleanerService asyncCleanerService(RefreshableElide elide, ElideConfigProperties settings, AsyncApiDao asyncQueryDao) {
        AsyncCleanerService.init((Elide)elide.getElide(), (Duration)settings.getAsync().getCleanup().getQueryMaxRunTime(), (Duration)settings.getAsync().getCleanup().getQueryRetentionDuration(), (Duration)settings.getAsync().getCleanup().getQueryCancellationCheckInterval(), (AsyncApiDao)asyncQueryDao);
        return AsyncCleanerService.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean
    public AsyncApiDao asyncApiDao(RefreshableElide elide) {
        return new DefaultAsyncApiDao(elide.getElide().getElideSettings(), elide.getElide().getDataStore());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="elide.async.export", name={"enabled"}, matchIfMissing=false)
    public ResultStorageEngine resultStorageEngine(ElideConfigProperties settings) {
        FileResultStorageEngine resultStorageEngine = new FileResultStorageEngine(settings.getAsync().getExport().getStorageDestination(), settings.getAsync().getExport().isAppendFileExtension());
        return resultStorageEngine;
    }
}

