/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.elide.modelconfig.model.Rule;
import java.util.LinkedHashSet;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"roles", "rules"})
public class ElideSecurityConfig {
    @JsonProperty(value="roles")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> roles = new LinkedHashSet<String>();
    @JsonProperty(value="rules")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<Rule> rules = new LinkedHashSet<Rule>();

    public boolean hasCheckDefined(String role) {
        return this.roles.stream().anyMatch(role::equals);
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="roles")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @JsonProperty(value="rules")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setRules(Set<Rule> rules) {
        this.rules = rules;
    }

    public String toString() {
        return "ElideSecurityConfig(roles=" + this.getRoles() + ", rules=" + this.getRules() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElideSecurityConfig)) {
            return false;
        }
        ElideSecurityConfig other = (ElideSecurityConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Set<Rule> this$rules = this.getRules();
        Set<Rule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElideSecurityConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Set<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public ElideSecurityConfig(Set<String> roles, Set<Rule> rules) {
        this.roles = roles;
        this.rules = rules;
    }

    public ElideSecurityConfig() {
    }
}

