/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.elide.modelconfig.model.Argument;
import com.yahoo.elide.modelconfig.model.Grain;
import com.yahoo.elide.modelconfig.model.Named;
import com.yahoo.elide.modelconfig.model.TableSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "friendlyName", "description", "category", "hidden", "readAccess", "definition", "cardinality", "type", "grains", "tags", "arguments", "values", "tableSource", "filterTemplate"})
public class Dimension
implements Named {
    private static final long serialVersionUID = 7886036651874169795L;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="friendlyName")
    private String friendlyName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="category")
    private String category;
    @JsonProperty(value="hidden")
    private Boolean hidden;
    @JsonProperty(value="readAccess")
    private String readAccess;
    @JsonProperty(value="definition")
    private String definition;
    @JsonProperty(value="cardinality")
    private String cardinality;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="grains")
    private List<Grain> grains = new ArrayList<Grain>();
    @JsonProperty(value="tags")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> tags = new LinkedHashSet<String>();
    @JsonProperty(value="arguments")
    private List<Argument> arguments = new ArrayList<Argument>();
    @JsonProperty(value="values")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> values = new LinkedHashSet<String>();
    @JsonProperty(value="tableSource")
    private TableSource tableSource;
    @JsonProperty(value="filterTemplate")
    private String filterTemplate;

    public String getDescription() {
        return this.description == null ? this.getName() : this.description;
    }

    public boolean hasArgument(String argName) {
        return this.hasName(this.arguments, argName);
    }

    private static Boolean $default$hidden() {
        return false;
    }

    private static String $default$readAccess() {
        return "Prefab.Role.All";
    }

    public static DimensionBuilder builder() {
        return new DimensionBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getCategory() {
        return this.category;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public String getReadAccess() {
        return this.readAccess;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public String getType() {
        return this.type;
    }

    public List<Grain> getGrains() {
        return this.grains;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public TableSource getTableSource() {
        return this.tableSource;
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="friendlyName")
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @JsonProperty(value="hidden")
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @JsonProperty(value="readAccess")
    public void setReadAccess(String readAccess) {
        this.readAccess = readAccess;
    }

    @JsonProperty(value="definition")
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @JsonProperty(value="cardinality")
    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="grains")
    public void setGrains(List<Grain> grains) {
        this.grains = grains;
    }

    @JsonProperty(value="tags")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="arguments")
    public void setArguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    @JsonProperty(value="values")
    @JsonDeserialize(as=LinkedHashSet.class)
    public void setValues(Set<String> values) {
        this.values = values;
    }

    @JsonProperty(value="tableSource")
    public void setTableSource(TableSource tableSource) {
        this.tableSource = tableSource;
    }

    @JsonProperty(value="filterTemplate")
    public void setFilterTemplate(String filterTemplate) {
        this.filterTemplate = filterTemplate;
    }

    public String toString() {
        return "Dimension(name=" + this.getName() + ", friendlyName=" + this.getFriendlyName() + ", description=" + this.getDescription() + ", category=" + this.getCategory() + ", hidden=" + this.getHidden() + ", readAccess=" + this.getReadAccess() + ", definition=" + this.getDefinition() + ", cardinality=" + this.getCardinality() + ", type=" + this.getType() + ", grains=" + this.getGrains() + ", tags=" + this.getTags() + ", arguments=" + this.getArguments() + ", values=" + this.getValues() + ", tableSource=" + this.getTableSource() + ", filterTemplate=" + this.getFilterTemplate() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$readAccess = this.getReadAccess();
        String other$readAccess = other.getReadAccess();
        if (this$readAccess == null ? other$readAccess != null : !this$readAccess.equals(other$readAccess)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        String this$cardinality = this.getCardinality();
        String other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<Grain> this$grains = this.getGrains();
        List<Grain> other$grains = other.getGrains();
        if (this$grains == null ? other$grains != null : !((Object)this$grains).equals(other$grains)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Argument> this$arguments = this.getArguments();
        List<Argument> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Set<String> this$values = this.getValues();
        Set<String> other$values = other.getValues();
        if (this$values == null ? other$values != null : !((Object)this$values).equals(other$values)) {
            return false;
        }
        TableSource this$tableSource = this.getTableSource();
        TableSource other$tableSource = other.getTableSource();
        if (this$tableSource == null ? other$tableSource != null : !((Object)this$tableSource).equals(other$tableSource)) {
            return false;
        }
        String this$filterTemplate = this.getFilterTemplate();
        String other$filterTemplate = other.getFilterTemplate();
        return !(this$filterTemplate == null ? other$filterTemplate != null : !this$filterTemplate.equals(other$filterTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dimension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $readAccess = this.getReadAccess();
        result = result * 59 + ($readAccess == null ? 43 : $readAccess.hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        String $cardinality = this.getCardinality();
        result = result * 59 + ($cardinality == null ? 43 : $cardinality.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<Grain> $grains = this.getGrains();
        result = result * 59 + ($grains == null ? 43 : ((Object)$grains).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Set<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        TableSource $tableSource = this.getTableSource();
        result = result * 59 + ($tableSource == null ? 43 : ((Object)$tableSource).hashCode());
        String $filterTemplate = this.getFilterTemplate();
        result = result * 59 + ($filterTemplate == null ? 43 : $filterTemplate.hashCode());
        return result;
    }

    public Dimension(String name, String friendlyName, String description, String category, Boolean hidden, String readAccess, String definition, String cardinality, String type, List<Grain> grains, Set<String> tags, List<Argument> arguments, Set<String> values, TableSource tableSource, String filterTemplate) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.description = description;
        this.category = category;
        this.hidden = hidden;
        this.readAccess = readAccess;
        this.definition = definition;
        this.cardinality = cardinality;
        this.type = type;
        this.grains = grains;
        this.tags = tags;
        this.arguments = arguments;
        this.values = values;
        this.tableSource = tableSource;
        this.filterTemplate = filterTemplate;
    }

    public Dimension() {
        this.hidden = Dimension.$default$hidden();
        this.readAccess = Dimension.$default$readAccess();
    }

    public static class DimensionBuilder {
        private String name;
        private String friendlyName;
        private String description;
        private String category;
        private boolean hidden$set;
        private Boolean hidden$value;
        private boolean readAccess$set;
        private String readAccess$value;
        private String definition;
        private String cardinality;
        private String type;
        private ArrayList<Grain> grains;
        private Set<String> tags;
        private ArrayList<Argument> arguments;
        private Set<String> values;
        private TableSource tableSource;
        private String filterTemplate;

        DimensionBuilder() {
        }

        @JsonProperty(value="name")
        public DimensionBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="friendlyName")
        public DimensionBuilder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        @JsonProperty(value="description")
        public DimensionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="category")
        public DimensionBuilder category(String category) {
            this.category = category;
            return this;
        }

        @JsonProperty(value="hidden")
        public DimensionBuilder hidden(Boolean hidden) {
            this.hidden$value = hidden;
            this.hidden$set = true;
            return this;
        }

        @JsonProperty(value="readAccess")
        public DimensionBuilder readAccess(String readAccess) {
            this.readAccess$value = readAccess;
            this.readAccess$set = true;
            return this;
        }

        @JsonProperty(value="definition")
        public DimensionBuilder definition(String definition) {
            this.definition = definition;
            return this;
        }

        @JsonProperty(value="cardinality")
        public DimensionBuilder cardinality(String cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        @JsonProperty(value="type")
        public DimensionBuilder type(String type) {
            this.type = type;
            return this;
        }

        public DimensionBuilder grain(Grain grain) {
            if (this.grains == null) {
                this.grains = new ArrayList();
            }
            this.grains.add(grain);
            return this;
        }

        @JsonProperty(value="grains")
        public DimensionBuilder grains(Collection<? extends Grain> grains) {
            if (grains == null) {
                throw new NullPointerException("grains cannot be null");
            }
            if (this.grains == null) {
                this.grains = new ArrayList();
            }
            this.grains.addAll(grains);
            return this;
        }

        public DimensionBuilder clearGrains() {
            if (this.grains != null) {
                this.grains.clear();
            }
            return this;
        }

        @JsonProperty(value="tags")
        @JsonDeserialize(as=LinkedHashSet.class)
        public DimensionBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public DimensionBuilder argument(Argument argument) {
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.add(argument);
            return this;
        }

        @JsonProperty(value="arguments")
        public DimensionBuilder arguments(Collection<? extends Argument> arguments) {
            if (arguments == null) {
                throw new NullPointerException("arguments cannot be null");
            }
            if (this.arguments == null) {
                this.arguments = new ArrayList();
            }
            this.arguments.addAll(arguments);
            return this;
        }

        public DimensionBuilder clearArguments() {
            if (this.arguments != null) {
                this.arguments.clear();
            }
            return this;
        }

        @JsonProperty(value="values")
        @JsonDeserialize(as=LinkedHashSet.class)
        public DimensionBuilder values(Set<String> values) {
            this.values = values;
            return this;
        }

        @JsonProperty(value="tableSource")
        public DimensionBuilder tableSource(TableSource tableSource) {
            this.tableSource = tableSource;
            return this;
        }

        @JsonProperty(value="filterTemplate")
        public DimensionBuilder filterTemplate(String filterTemplate) {
            this.filterTemplate = filterTemplate;
            return this;
        }

        public Dimension build() {
            List<Grain> grains = switch (this.grains == null ? 0 : this.grains.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.grains.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Grain>(this.grains));
            };
            List<Argument> arguments = switch (this.arguments == null ? 0 : this.arguments.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.arguments.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Argument>(this.arguments));
            };
            Boolean hidden$value = this.hidden$value;
            if (!this.hidden$set) {
                hidden$value = Dimension.$default$hidden();
            }
            String readAccess$value = this.readAccess$value;
            if (!this.readAccess$set) {
                readAccess$value = Dimension.$default$readAccess();
            }
            return new Dimension(this.name, this.friendlyName, this.description, this.category, hidden$value, readAccess$value, this.definition, this.cardinality, this.type, grains, this.tags, arguments, this.values, this.tableSource, this.filterTemplate);
        }

        public String toString() {
            return "Dimension.DimensionBuilder(name=" + this.name + ", friendlyName=" + this.friendlyName + ", description=" + this.description + ", category=" + this.category + ", hidden$value=" + this.hidden$value + ", readAccess$value=" + this.readAccess$value + ", definition=" + this.definition + ", cardinality=" + this.cardinality + ", type=" + this.type + ", grains=" + this.grains + ", tags=" + this.tags + ", arguments=" + this.arguments + ", values=" + this.values + ", tableSource=" + this.tableSource + ", filterTemplate=" + this.filterTemplate + ")";
        }
    }
}

