/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.yahoo.elide.modelconfig.jsonformats.ValidateDimPropertiesValidator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ValidateTimeDimPropertiesValidator
extends AbstractKeywordValidator {
    private static final Set<String> ADDITIONAL_TIME_DIM_PROPERTIES = ImmutableSet.of((Object)"grains");
    public static final String KEYWORD = "validateTimeDimensionProperties";
    public static final String ADDITIONAL_KEY = "validateTimeDimensionProperties.error.addtional";
    public static final String ADDITIONAL_MSG = "Properties: %s are not allowed for time dimensions.";
    private boolean validate;

    public ValidateTimeDimPropertiesValidator(JsonNode digest) {
        super(KEYWORD);
        this.validate = digest.get(this.keyword).booleanValue();
    }

    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        if (this.validate) {
            JsonNode instance = data.getInstance().getNode();
            HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
            fields.removeAll(ValidateDimPropertiesValidator.COMMON_DIM_PROPERTIES);
            fields.removeAll(ADDITIONAL_TIME_DIM_PROPERTIES);
            if (!fields.isEmpty()) {
                report.error(this.newMsg(data, bundle, ADDITIONAL_KEY).putArgument("value", (Object)((Object)fields).toString()));
            }
        }
    }

    public String toString() {
        return this.keyword;
    }
}

