/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ValidateDimPropertiesValidator
extends AbstractKeywordValidator {
    public static final Set<String> COMMON_DIM_PROPERTIES = ImmutableSet.of((Object)"name", (Object)"friendlyName", (Object)"description", (Object)"category", (Object)"hidden", (Object)"readAccess", (Object[])new String[]{"definition", "cardinality", "tags", "type", "arguments", "filterTemplate"});
    private static final Set<String> ADDITIONAL_DIM_PROPERTIES = ImmutableSet.of((Object)"values", (Object)"tableSource");
    public static final String KEYWORD = "validateDimensionProperties";
    public static final String ATMOST_ONE_KEY = "validateDimensionProperties.error.atmostOne";
    public static final String ATMOST_ONE_MSG = "tableSource and values cannot both be defined for a dimension. Choose One or None.";
    public static final String ADDITIONAL_KEY = "validateDimensionProperties.error.addtional";
    public static final String ADDITIONAL_MSG = "Properties: %s are not allowed for dimensions.";
    private boolean validate;

    public ValidateDimPropertiesValidator(JsonNode digest) {
        super(KEYWORD);
        this.validate = digest.get(this.keyword).booleanValue();
    }

    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        if (this.validate) {
            JsonNode instance = data.getInstance().getNode();
            HashSet fields = Sets.newHashSet((Iterator)instance.fieldNames());
            if (fields.contains("values") && fields.contains("tableSource")) {
                report.error(this.newMsg(data, bundle, ATMOST_ONE_KEY));
            }
            fields.removeAll(COMMON_DIM_PROPERTIES);
            fields.removeAll(ADDITIONAL_DIM_PROPERTIES);
            if (!fields.isEmpty()) {
                report.error(this.newMsg(data, bundle, ADDITIONAL_KEY).putArgument("value", (Object)((Object)fields).toString()));
            }
        }
    }

    public String toString() {
        return this.keyword;
    }
}

