/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Pattern;

public class JavaClassNameWithExtFormatAttr
extends AbstractFormatAttribute {
    private static final Pattern CLASS_NAME_FORMAT_PATTERN = Pattern.compile("^(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+class$");
    public static final String FORMAT_NAME = "javaClassNameWithExt";
    public static final String FORMAT_KEY = "javaClassNameWithExt.error.format";
    public static final String FORMAT_MSG = "Input value[%s] is not a valid Java class name with .class extension.";

    public JavaClassNameWithExtFormatAttr() {
        super(FORMAT_NAME, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        if (!CLASS_NAME_FORMAT_PATTERN.matcher(input).matches()) {
            report.error(this.newMsg(data, bundle, FORMAT_KEY).putArgument("value", (Object)input));
        }
    }
}

