/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.modelconfig.jsonformats;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.RSQLParserException;

public class ElideRSQLFilterFormatAttr
extends AbstractFormatAttribute {
    public static final String FORMAT_NAME = "elideRSQLFilter";
    public static final String FORMAT_KEY = "elideRSQLFilter.error.format";
    public static final String FORMAT_MSG = "Input value[%s] is not a valid RSQL filter expression. Please visit page https://elide.io/pages/guide/v5/11-graphql.html#operators for samples.";

    public ElideRSQLFilterFormatAttr() {
        super(FORMAT_NAME, NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        try {
            new RSQLParser(RSQLFilterDialect.getDefaultOperatorsWithIsnull()).parse(input);
        }
        catch (RSQLParserException e) {
            report.error(this.newMsg(data, bundle, FORMAT_KEY).putArgument("value", (Object)input));
        }
    }
}

